;/-----------------------------------------------
;/ Ejemplo de Driver con temporizacion RTC      /
;/                                              /
;/ Andres Prieto-Moreno Torres                  /
;/ ETC-II                                       /
;/----------------------------------------------/

; ETIQUETAS DEL PROGRAMA

SERV  EQU 0EE01H  ; codigo que indentifica al driver
ERRN  EQU 0FFH
OK    EQU 00H
VIDEO EQU 0B800H   ; Posicion de memoria donde empieza el modo 80x25


; CODIGO DEL PROGRAMA

codesg  SEGMENT
	assume cs:codesg, DS:codesg, SS:codesg , ES:codesg
	; El ORG 100H es necesario para generar programas .COM ya que
	; la zona de memoria anterior es ocupada por el PSP
	ORG	100H

start:
	jmp instalar  ; la primera vez que se ejecuta lo dejamos residente


;************************************************
;* Funciones del RTC                            *
;************************************************


; Funcion que configura el periodo del RTC
config_rtc proc far
        PUSH ax

        CLI
        ; configuro PIC
        IN    AL,021H
        AND   AL, 0FBH
        OUT   021H, AL   ; Pongo a 0 bit 2 puerto 21H
        IN    AL,0A1H
        AND   AL, 0FEH
        OUT   0A1H, AL   ; Pongo a 0 bit 0 puerto A1H

        ; configuro la frecuencia
        MOV   AL, 0AH
        OUT   070H,AL
        MOV   AL,02FH   ; 0010-xxxx
        OUT   071H,AL

        STI
        POP AX
        RET
config_rtc endp


; Activa las interrupciones del RTC
start_rtc proc far
        PUSH AX
        CLI

        ; activo interrupcion PIE
        MOV   AL, 0BH
        OUT   070H,AL
        IN    AL,071H
        OR    AL,040H
        AND   AL,047H
        MOV   AH,AL
        MOV   AL,0BH
        OUT   070H,AL
        MOV   AL,AH
        OUT   071H,AL
        MOV   AL, 0CH   ; necesario para activar las interrupciones
        OUT   070H,AL
        IN    al,071H

        STI
        POP   AX
        RET
start_rtc endp


; Desactiva las interrupciones del RTC
stop_rtc proc far
        PUSH AX
        CLI
        ; desactivo interrupcion PIE
        MOV   AL, 0BH
        OUT   070H,AL
        IN    AL,071H
        AND   AL,0BFH
        MOV   AH,AL
        MOV   AL,0BH
        OUT   070H,AL
        MOV   AL, AH
        OUT   071H,AL
        MOV   AL, 0CH
        OUT   070H,AL
        IN    AL,071H

        STI
        POP   AX
        RET
stop_rtc endp



;........................................................................
;. Rutina de servicio de la interrupcion 1CH (pos en tabla 70H)         .
;........................................................................
serv70_int proc far
	CLI
	PUSH AX BX ES DS DX

	MOV  AX,CS
	MOV  DS,AX

	; compruebo que ha sido el PIE quien ha interrumpido
	MOV  AL, 0CH
	OUT  070H,AL
	IN   AL,071H
	AND  AL,040H
	JNZ  pi_int
	JMP  salir

;------------------------------------------------------------------------
;-  Codigo de mi rutina de interrupcion:
;-     rota un caracter en la pantalla
;-     hace parpadear un LED colocado en el bit D3 del puerto paralelo
;------------------------------------------------------------------------
pi_int:  
	MOV  AX,VIDEO
	MOV  ES,AX      ; ES apunta a la memoria de video
	MOV  BX, CONT   ; BX contiene el estado del puntero a la tabla
	INC  BX
	CMP  BX,4     ; hemos superado el final tabla ?
	JNE  sigue     ; NO -> apunta al carater que corresponda
	MOV  BX,0      ; SI -> apunta al primer caracter

; pinta el caracter en la esquina superior izquierda
sigue:
	MOV  AL, TABLA[BX+0]
	MOV  byte ptr ES:[09EH],AL
	; devuelve el control
	MOV  word ptr CONT,BX
	
	; Hace parpadear el LED 
	MOV DX, DIR_BASE
	IN  AL, DX
	XOR AL, 08H
	OUT DX, AL
	
;---------------------------------------------------------
;- Fin de mi codigo de la rutina de interrupcion
;---------------------------------------------------------

salir:   ;  necesario para terminar correctamente la interrrupcion
	MOV  al, 020H   ; cargo EOI
	OUT  020H, al   ; mando EOI al PIC maestro
	OUT  0A0H, al   ; mando EOI al PIC esclavo

	POP  DX DS ES BX AX
	STI
	IRET
serv70_int endp



;************************************************
;* Servicios del Driver                         *
;************************************************

;............................................
;. SERVICIO AH=0 Comprobacin del DRIVER    .
;. E - AH=0 Comprobacion del driver         .
;. S - AX=0xEE01H                           .
;............................................

status:
	MOV  AX, SERV
	IRET


;............................................
;. SERVICIO AH=1 Desinstalar                .
;. E - AH=1 Desinstalar                     .
;. S - AH=OK                                .
;............................................
desinstalar:
	;-- codigo que desinstala el driver --
	MOV AH,OK
	IRET


;............................................
;. SERVICIO AH=2 Read                       .
;. E - AH=2 Read                            .
;. E - DI=posicion a leer                   .
;. S - AH=ERRN(fuera tamao o no disponible).
;. S - AH=OK                                .
;. S - AL=Dato ledo                        .
;............................................

read:
	; -- cdigo que accede a la memoria fsica y lee valor --
	
	; -- vamos a decir que leemos 0AAH y que no hay error para probar !!!!
	MOV AH,OK
	MOV AL,0AAH   
	
	IRET


;............................................
;. SERVICIO AH=3 Write                      .
;. E - AH=3 Write                           .
;. E - DI=posicion a escribir               .
;. E - AL=Dato a escribir                   .
;. S - AH=OK                                .
;.   - AH=ERRN(fuera de rango o no se pudo) .
;............................................

write:
	; -- cdigo que accede a la memoria fsica y escribe valor --
	IRET


;............................................
;. SERVICIO AH=4 Working                    .
;. E - AH=4 Working                         .
;. S - AH=OK  puede procesar otras ordenes  .
;.   - AH=ERRN (dispositivo ocupado)        .
;............................................
working:
	; -- aadir el codigo de working --
	IRET


;............................................
;. SERVICIO AH=5 EESIZE                     .
;. E - AH=4 EESIZE                          .
;. S - AX=Tamao (512bytes)                 .
;. S - BL=OK                                .
;............................................
eesize:
	MOV AX,512 
	MOV BL,OK
	IRET



;............................................
;. SERVICIO AH=6 Led                        .
;. E - AH=6 Led                             .
;. E - AL=0 apaga - 1 enciende              .
;. S - AH=OK                                .
;............................................
led:
	MOV  AH,OK
	CMP  AL,0
	JE   apaga_led
enciende_led:
	;-- codigo que enciende el LED --
	IRET
apaga_led:	
	;-- codigo que apaga el LED --
	IRET


;............................................
;. SERVICIO AH=7 Efecto RTC                 .
;. E - AH=6 RT                              .
;. E - AL=0 apaga - 1 enciende              .
;. S - AH=OK                                .
;............................................
efecto:
	MOV  AH,OK
	CMP  AL,0
	JE   apaga_parpadeo
enciende_parpadeo:
	CALL start_RTC
	IRET
apaga_parpadeo:	
	CALL stop_RTC
	IRET



;***********************************************************
;* Programa principal del driver                           *
;* Comprueba los servicios solicitados                     *
;***********************************************************

; Cuando llamamos a la INT61H esto es lo que se tiene que ejecutar


driver proc far   
	JMP  parser
	
	; chequeo extra driver
	DW   0CAFEH    

;---------- Declaracion de variables --------------------
			; para guardar los valores originales de la interrupcin 61h
OFFSET_DRV  DW 0
SEGMEN_DRV  DW 0

OFFSET_RTC  DW 0
SEGMEN_RTC  DW 0

DIR_BASE    DW 0

OFFSET_O   DW 0
SEGMEN_O   DW 0

TABLA      DB  02FH, 07CH, 05CH, 02DH
CONT       DW 0


;----------- Fin declaracion variables -----------------

parser:
	CMP  AH, 0
	JE   status

	CMP  AH, 1
	JE   desinstalar

	CMP  AH, 2
	JE   read
	
	CMP  AH, 3
	JE   write

	CMP  AH, 4
	JE   working

	CMP  AH, 5
	JE   eesize

	CMP  AH, 6
	JE   led

	CMP  AH, 7
	JE   efecto
	
	; error en llamada a funcion
	MOV  AH, ERRN
	IRET
driver  endp


;===================================================
; CODIGO QUE INSTALA EL DRIVER
; Tambien instala la rutina de interrupcion del RTC
;===================================================

instalar proc 

	CLI

	; saco la direccion del LPT1 (miro en la BIOS)
	MOV  AX, 0040H     ; zona de la BIOS que me indica las direcciones de los puertos
	MOV  ES, AX
	MOV  DX, ES:[08H] ; direccion Puerto Paralelo 1
	MOV  DIR_BASE,DX

	;---------------------------------------------------------
	; RTC: Instalo el vector de interrupcion 70H  (pos 1C0H)
    ;---------------------------------------------------------

	XOR AX,AX
	MOV ES,AX
    
    ; guardo los valores iniciales
    MOV  AX, word ptr ES:[01C0H]
    MOV  OFFSET_RTC, AX
    MOV  AX, word ptr ES:[01C2H]
    MOV  SEGMEN_RTC, AX
    
	; pongo los nuevos
    ; hago que apunte a la subrutina 'serv70_int'
    MOV  word ptr ES:[01C0H],offset serv70_int
    MOV  word ptr ES:[01C2H],cs
    
	; Configuro el RTC
	call config_rtc
	
	;----------------------------------------------------------
	; Instalo el Driver:
	;     primero configuro los registros de interrupcion 61H
	;     salgo del programa dejandolo residente en memoria
	;----------------------------------------------------------
	
	XOR AX,AX
	MOV ES,AX
    
	; actualizo tabla interrupciones para colocar la 61h
	; guardo los valores iniciales
    MOV  AX, word ptr ES:[061H*4]
    MOV  OFFSET_DRV, AX
    MOV  AX, word ptr ES:[061H*4+2]
    MOV  SEGMEN_DRV, AX

	; pongo el nuevo valor apuntando al trozo de programa que queremos que se ejecute al 
	; llamar a la interrupcion (driver)
	MOV  ES:[061H*4]  , OFFSET driver  ; colocamos el OFFSET al codigo de inicio en la tabla de interrupciones
	MOV  ES:[061H*4+2], CS             ; colocamos el SEGMENTO al codido de inicio en la tabla de interrupciones
	STI
	
	; funcion que se encarga de dejar el programa residente
	MOV  DX, OFFSET instalar   
	INT  27H
instalar endp

codesg	ends

end	start

