#!/usr/bin/env python
# -*- coding: utf-8 -*-

# Form implementation generated from reading ui file 'iris.ui'
#
# Created: Wed May 16 00:01:56 2007
#      by: PyQt4 UI code generator 4.0.1
#
# WARNING! All changes made in this file will be lost!

import sys
import gui
from PyQt4 import QtCore, QtGui
sys.path = ['..'] + sys.path

#---------------------------
#-- Modulos de LibIris
#---------------------------
import libIris.Pic16_Bootloader
import libIris.Pic16_Firmware
import libIris.IntelHex

#-- Timeout para la deteccion del bootloader (en segundos)
TIMEOUT = 5

#------------------------------------------------------------------------
#-- Ventana principal. Hay que crear una clase propia para implementar 
#-- los metodos de Drag and Drop
#------------------------------------------------------------------------
class MyWindow(QtGui.QMainWindow):
  def __init__(self,ui):
    QtGui.QMainWindow.__init__(self)
    self.setAcceptDrops(True)
    self.ui = ui
    self.prog = None
    
  def dragEnterEvent(self, event):
    event.acceptProposedAction()

  def dragMoveEvent(self, event):
    event.acceptProposedAction()

  def dropEvent(self, event):
    
    #-- Obtener la lista de ficheros recibidos y quedarse solo con el primero
    lista = event.mimeData().urls()
    file = lista[0].path()
    
    #-- Meter nombre del fichero en el entry
    self.ui.lineEdit.setText(file)
    
    #-- Invocar la descarga
    self.download()
    event.accept()
    

#------------------------------------------------------------------------
#-- Clase principal que implementa las funciones de retrollama
#-- del interfaz
#------------------------------------------------------------------------
class pydownloader_qt:
  def __init__(self,ui,app,MainWindow):
  
    #-- Configurar las funciones de retrollamada
    QtCore.QObject.connect(ui.pushButton,
                           QtCore.SIGNAL("clicked()"),
                           self.abrir)
    QtCore.QObject.connect(ui.pushButton_8,
                           QtCore.SIGNAL("clicked()"),
                           self.boton_test)

    QtCore.QObject.connect(ui.pushButton_6,
                           QtCore.SIGNAL("clicked()"),
                           self.boton_cancelar)

    QtCore.QObject.connect(ui.pushButton_2,
                           QtCore.SIGNAL("clicked()"),
                           self.boton_monitor) 
                           
    QtCore.QObject.connect(ui.pushButton_3,
                           QtCore.SIGNAL("clicked()"),
                           self.boton_servos8)

    QtCore.QObject.connect(ui.pushButton_4,
                           QtCore.SIGNAL("clicked()"),
                           self.boton_picp)    
                           
    QtCore.QObject.connect(ui.pushButton_5,
                           QtCore.SIGNAL("clicked()"),
                           self.boton_eco)    
                          
    QtCore.QObject.connect(ui.pushButton_7,
                           QtCore.SIGNAL("clicked()"),
                           self.boton_grabar)   

    #-- Almacenar informacion en el objeto
    self.ui = ui
    self.app = app
    self.cancelar=False
    
    #-- Pruebas drag and drop
    self.ui.lineEdit.setAcceptDrops(False)
    self.ui.comboBox.setAcceptDrops(False)
    self.ui.comboBox.lineEdit().setAcceptDrops(False)
    
    #-- Estado inicial del interfaz
    self.ui.pushButton_6.setEnable=False
    self.botones_modo_descarga()


  #------------------------------------------------------------------
  #-- Funcion de retrollamada del boton de exploracion de ficheros 
  #------------------------------------------------------------------ 
  def abrir(self):
  
    #-- Abrir un dialogo de busqueda de ficheros y obtener el fichero
    #-- TODO: Como se especifican filtros? Para solo sacar fichero .hex
    fileName = QtGui.QFileDialog.getOpenFileName ()
    
    #-- Se ha indicado un fichero?
    if len(fileName)==0:
      return    # No, terminar
      
    else: #-- Si
      #-- Meter el fichero en el entry "fichero .hex"
      self.ui.lineEdit.setText(fileName)
      
  #-----------------------------------------------------------------
  #-- Funciones de retrollamada de los diferentes botones 
  #-----------------------------------------------------------------
  def boton_test(self): 
      self.download_program(libIris.Pic16_Firmware.ledp1)
      
  def boton_grabar(self): 
      self.download()

  def boton_cancelar(self): 
      self.cancelar = True   
      
  def boton_monitor(self): 
      self.download_program(libIris.Pic16_Firmware.generic)
      
  def boton_servos8(self): 
      self.download_program(libIris.Pic16_Firmware.servos8)
     
  def boton_picp(self): 
      self.download_program(libIris.Pic16_Firmware.picp)

  def boton_eco(self): 
      self.download_program(libIris.Pic16_Firmware.echo)

  #------------------------------------------------------------
  #-- Activar todos los botones relacionados con la descarga
  #-- El boton de cancel se desactiva
  #------------------------------------------------------------    
  def botones_modo_descarga(self):
    #-- Cancelar: Deshabilitado
    #-- Resto: Habilitados
    self.ui.pushButton_6.setEnabled(False)
    
    self.ui.pushButton_2.setEnabled(True)
    self.ui.pushButton_3.setEnabled(True)
    self.ui.pushButton_4.setEnabled(True)
    self.ui.pushButton_5.setEnabled(True)
    self.ui.pushButton_7.setEnabled(True)
    self.ui.pushButton_8.setEnabled(True)
 
    
  #-----------------------------------------------------------------------
  #-- Desactivar todos los botones de descarga. El de cancelar se activa  
  #-----------------------------------------------------------------------
  def botones_modo_cancelar(self):
    #-- Cancelar Activado, resto desactivados
    self.ui.pushButton_6.setEnabled(True)
    
    self.ui.pushButton_2.setEnabled(False)
    self.ui.pushButton_3.setEnabled(False)
    self.ui.pushButton_4.setEnabled(False)
    self.ui.pushButton_5.setEnabled(False)
    self.ui.pushButton_7.setEnabled(False)
    self.ui.pushButton_8.setEnabled(False)
 

  #---------------------------------------------------------
  #-- Metodo para descargar un fichero .hex en la skypic
  #-- Se lee el nombre del fichero de la interfaz grafica
  #---------------------------------------------------------
  def download(self):
    
    #----------------------------------------
    #-- Abrir y parsear el fichero .hex
    #----------------------------------------
    #-- Obtener el nombre
    file = self.ui.lineEdit.text()
    
    #-- Convertir a cadena de texto
    file = "%s" % file
   
    #-- Realizar el parseo
    try:
      hr = libIris.IntelHex.HexReader (file)
    except libIris.IntelHex.ReaderError,msg:
      #-- Convertir el mensaje a una cadena
      msg = "%s" % msg
      self.ui.statusbar.showMessage(msg)
      return 
      
    #----------------------------------
    #-- Realizar la descarga!!
    #----------------------------------
    
    #-- Obtener el programa en el formato correcto
    program = hr.dataBlocks16()
    
    #-- Descargar
    self.download_program(program)
  
  
  #------------------------------------------------------------------------
  #-- Funcion de retrollamada de libIris. Segun el estado de la descarga
  #-- Se hace una cosa u otra
  #------------------------------------------------------------------------
  def state(self,op,inc,total):
    
    #---------------------------------------------------
    #-- Comienzo de la identificacion del bootloader    
    #---------------------------------------------------    
    if op==libIris.Pic16_Bootloader.IDENT_START:
      
      #-- Hay que esperar a que detecte el Bootloader
      self.ui.statusbar.showMessage("Pulse Reset en la skypic")
      self.app.processEvents()
      
      return True
      
    #-----------------------------------------------------------------
    #-- Respuesta no recibida del bootloader tras un mini-timeout    
    #-----------------------------------------------------------------
    elif op==libIris.Pic16_Bootloader.IDENT_NACK:
    
      #-- Mientras que el tiempo total acumulado sea menor que el 
      #-- TIMEOUT indicado, continuar esperando
      self.app.processEvents()
      
      #-- Si apretado boton de cancelar abortar...
      if self.cancelar:
        return False
      
      if total<=TIMEOUT:
       return True
      else :
        return False      
      
    #-----------------------------
    #-- Comienzo de descarga
    #-----------------------------
    elif op==libIris.Pic16_Bootloader.WRITING_START: 
      #-- Barra de progreso a cero
      self.ui.progressBar.setValue(0)
     
      #-- Actualizar barra de status
      self.ui.statusbar.showMessage("Descargando...")
      self.app.processEvents()
      
      return True

    #------------------------------
    #-- Incremento en la descarga  
    #------------------------------    
    elif op==libIris.Pic16_Bootloader.WRITING_INC:
      self.ui.progressBar.setValue(100*inc/total)
      self.app.processEvents()
      
      #-- Comprobar si se ha apretado boton de Cancelar
      if self.cancelar:
        return False
        
      return True
      
    #-------------------------------
    #-- Fin de la descarga
    #-------------------------------
    elif op==libIris.Pic16_Bootloader.WRITING_END: 
      self.ui.progressBar.setValue(100)
      self.ui.statusbar.showMessage("Completado")
      self.app.processEvents()
      return True  
  
  #----------------------------------------
  #- Descargar un programa 
  #----------------------------------------
  def download_program(self,prog):
    
    #-- Poner la barra de progreso a 0
    self.ui.progressBar.setValue(0)
    self.app.processEvents()
  
    #-- Desactivar flag de cancelacion
    self.cancelar=False

    #------------------------------------
    #-- Abrir puerto serie
    #------------------------------------
    #-- Primero obtener el nombre del dispositivo serie
    serialName=self.ui.comboBox.currentText()
    
    #-- Convertirlo en una cadena
    serialName = "%s" % serialName
    
    try:
      iris = libIris.Pic16_Bootloader.Iris(serialName,logCallback=None)
    except libIris.Pic16_Bootloader.IrisError,msg:
    
      #-- Si hay error indicarlo en la barra de estado y abortar
      msg = "%s" % msg
      self.ui.statusbar.showMessage(msg)
      return   
     
    #-- Actualizar la sensibilidad de los botones
    self.botones_modo_cancelar()
    self.app.processEvents()
    
    try:
      iris.download(prog,stateCallback=self.state)
    except libIris.Pic16_Bootloader.IrisError,msg:
      msg= "%s" % msg
      self.ui.statusbar.showMessage(msg)
      
      #-- Poner botones en su estado inicial:
      self.botones_modo_descarga()
      return
      
    #-- Poner botones en su estado inicial:
    self.botones_modo_descarga()    


#-------------------------
#- Programa principal 
#-------------------------
if __name__ == "__main__":
    app = QtGui.QApplication(sys.argv)
    
    ui = gui.Ui_MainWindow()
    MainWindow = MyWindow(ui)
    ui.setupUi(MainWindow)
    MainWindow.show()
    
    #-- Crear aplicacion 
    myProgram = pydownloader_qt(ui,app,MainWindow)
    
    #-- La funcion de retrollamada de Drop de Mainwindows tiene que
    #-- invocar el metodo download()
    MainWindow.download = myProgram.download
    
    sys.exit(app.exec_())
