#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-

# Copyright: (C) 2007 by Juan González Gómez
#            (C) 2007 by Rafael Treviño Menéndez
# Authors: Juan González Gómez     <juan@iearobotics.com>
#          Rafael Treviño Menéndez <skasi.7@gmail.com>

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#-----------------------------------------------------------------------
#  Programa de pruebas del servidor servos8
#  Se hace parpadear el led de la Skypic
#
# LICENCIA GPL
#-----------------------------------------------------------------------

import sys
import time
sys.path = ['..'] + sys.path
import libStargate.Servos8


#-----------------------
#-- Mostrar la ayuda 
#-----------------------
def help():
  print """
Uso: test-servos8 <port>

 <Port>: Nombre del dispositivo serie a utilizar   
 
 Ejemplo: ./test-servos8 /dev/ttyUSB0
"""

#--------------------------------
#- Leer argumentos
#--------------------------------
def leer_argumentos():
  #- Argumento 1: puerto serie 
  try:
    serialName = sys.argv [1]
  except IndexError:
    print "-->Puerto serie no especificado"
    help()
    sys.exit(-1)

  return sys.argv[1]

#----------------------
#   MAIN
#----------------------
if __name__ == '__main__':

  #-- Procesador argumentos
  serialName = leer_argumentos()
  
  #-- Abrir la conexion y devolver el stargate generico
  s=libStargate.Servos8.Open_session(serialName)
  if s==None: sys.exit(-1)
    
  #-- Habilitar servo 1
  s.enable(0x01);

  print "\nMoviendo servo 1...."

  try:
    #-- Hacer una mini-secuencia
    for i in range(10):
      s[1]=45
      time.sleep(0.5)
      s[1]=-45
      time.sleep(0.5)
      s[1]=0
      time.sleep(0.5)
  except:
    pass  
  
print "TERMINADO"
