#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-

#-----------------------------------------------------------------------
#- Programa de pruebas de los diferentes servicios del servidor PICP  
#
# LICENCIA GPL
#-------------------------------------------------------------------

# Description: libStargate is a library for comunication to stargates
# Copyright: (C) 2007 by Juan González Gómez
#            (C) 2007 by Rafael Treviño Menéndez
# Authors: Juan González Gómez     <juan@iearobotics.com>
#          Rafael Treviño Menéndez <skasi.7@gmail.com>

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import sys
import consola_io

sys.path = ['..'] + sys.path
import libStargate.Picp


#----------------------------------------------------------------------
#- LEDP1.  Programa del ledp, que hace parpadear el led de la skypic
#----------------------------------------------------------------------
ledp1=[[0x0000, 0x0000, 0x118A, 0x120A, 0x2821, 0x0000, 0x30FD, 0x1683, 0x1303, 0x0086, 0x3002, 0x1283, 0x0686, 0x30FF, 0x00FF, 0x30FF, 0x2012],[0x0010, 0x2809, 0x0008, 0x1283, 0x1303, 0x00A3, 0x087F, 0x00A2, 0x0822, 0x0423, 0x1903, 0x2820, 0x30FF, 0x07A2, 0x1C03, 0x03A3, 0x2817],[0x0020, 0x0008, 0x118A, 0x120A, 0x2805],]

#----------------------------------------------------------------------
#- LEDP2.  Programa del ledp, que hace parpadear el led de la skypic. 
#- Se diferencia del ledp1 en que el parpadeo es mas rapido
#----------------------------------------------------------------------
ledp2=[[0x0000, 0x0000, 0x118A, 0x120A, 0x2821, 0x0000, 0x30FD, 0x1683, 0x1303, 0x0086, 0x3002, 0x1283, 0x0686, 0x3000, 0x00FF, 0x3080, 0x2012],[0x0010, 0x2809, 0x0008, 0x1283, 0x1303, 0x00A3, 0x087F, 0x00A2, 0x0822, 0x0423, 0x1903, 0x2820, 0x30FF, 0x07A2, 0x1C03, 0x03A3, 0x2817],[0x0020, 0x0008, 0x118A, 0x120A, 0x2805],]


bootloader=[[0x0000, 0x0000, 0x158A, 0x160A, 0x2E88],
[0x1E80, 0x158A, 0x160A, 0x2E80, 0x018A, 0x158A, 0x160A, 0x2E83, 0x0000, 0x1E03,
0x2E83, 0x1683, 0x3087, 0x0086, 0x1283, 0x0186, 0x3090, 0x0098, 0x1683, 0x1518, 0x1698, 0x301F, 0x0099, 0x1283, 0x3003, 0x00FA, 0x3031, 0x0090, 0x140C, 0x26F1, 0x3AEA, 0x1D03, 0x2EB4, 0x01FA, 0x2EBB, 0x26F1, 0x00F9, 0x3AE3, 0x1903, 0x2EBD, 0x0879, 0x3AEA, 0x1903, 0x2EBB, 0x0879, 0x3AED, 0x1D03, 0x2EA2, 0x30E4, 0x26EC, 0x3003, 0x00FA, 0x26F1, 0x0190, 0x0198, 0x1683, 0x0198, 0x1283, 0x018C, 0x2E83, 0x30EB, 0x2EEA, 0x26F1, 0x00F6, 0x26F1, 0x00F5, 0x26F1, 0x00F1, 0x00FB, 0x26F1, 0x00F3, 0x01F2, 0x3021, 0x1283, 0x1303, 0x0276, 0x1903, 0x2ED6, 0x0875, 0x3903, 0x00FC, 0x00FD, 0x1003, 0x0DFC, 0x3020, 0x077C, 0x2ED7, 0x3020, 0x0084, 0x26F1, 0x0080, 0x07F2, 0x0A84, 0x0BFB, 0x2ED8, 0x0872, 0x0673, 0x30E8, 0x1D03, 0x2EEA, 0x30E7, 0x26EC, 0x2703, 0x3800, 0x30E4, 0x1903, 0x30E5, 0x26EC, 0x2EA2, 0x0064, 0x1E0C, 0x2EEC, 0x0099, 0x0008, 0x0064, 0x087A, 0x1903, 0x2EFF, 0x1C0C, 0x2EFF, 0x1010, 0x0BFA, 0x2EFB, 0x3400, 0x100C, 0x300B, 0x008F, 0x1410, 0x1E8C, 0x2EF1, 0x081A, 0x0008, 0x3021, 0x0276, 0x1903, 0x2F55, 0x1683, 0x1703, 0x178C, 0x1283, 0x1303, 0x0875, 0x39FC, 0x1703, 0x008D, 0x1303, 0x0876, 0x1703, 0x008F, 0x3020, 0x0084, 0x1303, 0x087D, 0x1903, 0x2F2D, 0x1683, 0x1703, 0x140C, 0x0000, 0x0000, 0x1283, 0x080E, 0x0080, 0x0A84, 0x080C, 0x0080, 0x0A84, 0x0A8D, 0x1303, 0x03FD, 0x03F5, 0x0AF1, 0x0AF1, 0x2F16, 0x0871, 0x00FC, 0x3E20, 0x0084, 0x1003, 0x0CFC, 0x0876, 0x1703, 0x008F, 0x1303, 0x0875, 0x1703, 0x008D, 0x1303, 0x087C, 0x1703, 0x078D, 0x1903, 0x0A8F, 0x1703, 0x080D, 0x3903, 0x1903, 0x2F55, 0x1683, 0x140C, 0x0000, 0x0000, 0x1283, 0x080E, 0x0080, 0x0A84, 0x080C, 0x0080, 0x0A84, 0x0A8D, 0x1303, 0x0AF1, 0x0AF1, 0x2F40, 0x0875, 0x00F7, 0x0876, 0x00F8, 0x01FB, 0x3002, 0x00F4, 0x0871, 0x027B, 0x1803, 0x3401, 0x087B, 0x3E20, 0x0084, 0x3021, 0x0278, 0x1703, 0x1683, 0x1903, 0x2F73, 0x178C, 0x0183, 0x301E, 0x0278, 0x3080, 0x1903, 0x0277, 0x1803, 0x2FBB, 0x2F75, 0x138C, 0x0183, 0x0877, 0x1703, 0x008D, 0x1303, 0x0878, 0x1D03, 0x2F8A, 0x3004, 0x0277, 0x1803, 0x2F8A, 0x1703, 0x1683, 0x1F8C, 0x2F87, 0x1283, 0x3084, 0x078D, 0x0183, 0x301E, 0x2F8B, 0x0878, 0x1703, 0x008F, 0x0800, 0x008E, 0x0A84, 0x0800, 0x008C, 0x1683, 0x150C, 0x3055, 0x008D, 0x30AA, 0x008D, 0x148C, 0x0000, 0x0000, 0x0183, 0x1683, 0x1703, 0x1B8C, 0x2FC3, 0x1283, 0x1303, 0x0064, 0x1E0D, 0x2FA2, 0x120D, 0x1683, 0x1703, 0x110C, 0x140C, 0x0000, 0x0000, 0x1283, 0x0384, 0x0800, 0x060E, 0x1D03, 0x2FB7, 0x0A84, 0x0800, 0x060C, 0x1903, 0x2FBB, 0x0183, 0x0BF4, 0x2F5C, 0x3400, 0x1283, 0x1303, 0x3002, 0x07FB, 0x0AF7, 0x1903, 0x0AF8, 0x2F5A, 0x1283, 0x1303, 0x120D, 0x1683, 0x1703, 0x110C, 0x1283, 0x1703, 0x080D, 0x3903, 0x3C03, 0x1D03, 0x2FBB, 0x3003, 0x028D, 0x1283, 0x1303, 0x3004, 0x00FC, 0x3007, 0x0284, 0x0000, 0x1683, 0x1703, 0x140C, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0000, 0x0800, 0x1283, 0x1703, 0x060E, 0x1D03, 0x2FED, 0x0A84, 0x0800, 0x060C, 0x1903, 0x2FF4, 0x1283, 0x1303, 0x30FC, 0x05F7, 0x3006, 0x02FB, 0x2FB7, 0x1283, 0x1703, 0x0A8D, 0x0A84, 0x1283, 0x1303, 0x0BFC,
0x2FD8, 0x2FBB],]



#-- Caracter de escape
ESC = '\x1B'

#-----------------------
#-- Mostrar la ayuda 
#-----------------------
def help():
  print """
Uso: test-picp <port>
     <Port>: Nombre del dispositivo serie a utilizar   
Ejemplo: ./test-generic /dev/ttyUSB0
"""

#--------------------------------
#- Leer argumentos
#--------------------------------
def leer_argumentos():
  #- Argumento 1: puerto serie 
  try:
    serialName = sys.argv [1]
  except IndexError:
    print "-->Puerto serie no especificado"
    help()
    sys.exit(-1)

  return sys.argv[1]


#-------------------------------------------------------
#-- Hacer un volcado del numero de palabras indicado,
#-- comenzando por el valor del PC actual
#-------------------------------------------------------
def dump(tam):
  for i in xrange (tam):
  
    try:
      data = picp.readDataPM()
      picp.incAddr ()
    except:
      print "Error en volcado"
      return;

    #-- Dato leido ok: imprimir
    sys.stdout.write("%04x " % data)
    sys.stdout.flush()
 
  print ""

#-----------------
#-- Sacar el menu
#-----------------
def menu():
  print """

 Menu de opciones
 ----------------

--- Servicios basicos ---
 1.- PING
 2.- IDENTIFICACION
 3.- RESET DEL PC
 4.- Leer valor actual (Read Data)
 5.- Incrementar PC
 6.- Enviar el valor 0x1555 (LOAD DATA)
 7.- Enviar el valor 0x0AAA (LOAD DATA)
 8.- Comenzar ciclo de prog/borrado
 9.- Load config
 0.- Jump (16 posiciones)

--- Servicios avanzados --
 a.- Dump
 b.- Lectura de la configuracion (id, config)
 c.- Escribir palabra de configuracion (0x3F3A)
 d.- Grabar y verificar el ledp1
 e.- Grabar y verificar el ledp2
 f.- Grabar el bootloader

 SP.- Volver a sacar el menu
 ESC.- Terminar
"""

#----------------------
#   MAIN
#----------------------
if __name__ == '__main__':

  #-------------------------------------------------
  #- COMPROBACIONES INICIALES
  #--------------------------------------------------

  #-- Procesador argumentos
  serialName = leer_argumentos()
  
  #-- Abrir la conexion y devolver el stargate PICP
  picp=libStargate.Picp.Open_session(serialName)
  if picp==None: sys.exit(-1)
  
  
  #--------------------------------------------
  #-- BUCLE PRINCIPAL
  #--------------------------------------------
  
  #-- Sacar menu
  menu()

  while 1:

    #-- Leer tecla
    c = consola_io.getkey()

    #-- Procesar tecla
    if c=='1':
      if (picp.ping()):
        print 'Pink OK'
      else: 
        print 'No hay ping'
        
    elif c=='2': 
      id = picp.id();
      print 'Id: %s' % id
        
    elif c=='3':
      try:
        picp.Reset_target();
        print ("Reset OK");
      except libStargate.Picp.Error, msg:
        print msg
        
    elif c=='4':
      try:
        print "Leido: %4X" % picp.readDataPM()
      except libStargate.Picp.Error, msg:
        print msg
        
    elif c=='5':
      try:
        picp.incAddr()
        print "Increment Address ok"
      except libStargate.Picp.Error, msg:
        print msg
        
    elif c=='6':
      try:
        picp.loadDataPM(0x1555)
        print "Load Data OK (0x1555)"
      except libStargate.Picp.Error, msg:
        print msg
                
    elif c=='7':
      try:
        picp.loadDataPM(0x0AAA)
        print "Load Data OK (0x0AAA)"
      except libStargate.Picp.Error, msg:
        print msg

    elif c=='8':
      try:
        picp.beginCycle();
        print "BeginCycle OK"
      except libStargate.Picp.Error, msg:
        print msg  

    elif c=='9':
      try:
        picp.loadConfig()
        print "Acceso a memoria configuracion OK"
      except libStargate.Picp.Error, msg:
        print msg  

    elif c=='0':
      try:
        picp.jump(0x1FF8);
        print "Salto de 16 palabras"
      except libStargate.Picp.Error, msg:
        print msg  
        
    elif c=='a': dump(16)

    elif c=='b':
      try:
        id,config = picp.readConfig()
        print "Id: %X, Config: %X" % (id,config)
      except: 
        print 'Error leyendo configuracion'

    elif c=='c':
      try:
        picp.writeConfig(0x3F3A)
        print 'Escrita configuracion 0x3F3A'
      except:
        print 'Error de escritura de la configuracion'
        
    elif c=='d':
      print "Ledp1"
      try:
        ok=status=picp.writeProgram (ledp1)
      except:
        print "\nError en grabacion"
        continue
        
      if (not ok):
        print "\nError de verificacion"
        
    elif c=='e':
      print "ledp2"
      try:
        ok=status=picp.writeProgram (ledp2)
      except:
        print "\nError en grabacion"
        continue;
        
      if (not ok):
        print "\nError de verificacion"
        
    elif c=='f':
      print "Bootloader"
      try:
        ok=status=picp.writeProgram (bootloader)
      except:
        print "\nError en grabacion"
        continue;
        
      if (not ok):
        print "\nError de verificacion"    

      
    elif c==' ': menu()
    elif c==ESC: break   #-- Salir del bucle

  #-- Terminar
  print "-- FIN --"
