#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-

# Copyright: (C) 2007 by Juan González Gómez
#            (C) 2007 by Rafael Treviño Menéndez
# Authors: Juan González Gómez     <juan@iearobotics.com>
#          Rafael Treviño Menéndez <skasi.7@gmail.com>

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#-----------------------------------------------------------------------
#  Programa de pruebas del servidor generico
#  Se hace parpadear el led de la Skypic
#
# LICENCIA GPL
#-----------------------------------------------------------------------

import sys
import time
sys.path = ['..'] + sys.path
import libStargate.Generic
from libStargate.pic16f876 import * 

#-- Periodo de parpadeo del led, en segundos
PERIODO = 0.3

#-----------------------
#-- Mostrar la ayuda 
#-----------------------
def help():
  print """
Uso: test-generic <port>

 <Port>: Nombre del dispositivo serie a utilizar   
 
 Ejemplo: ./test-generic /dev/ttyUSB0
"""

#--------------------------------
#- Leer argumentos
#--------------------------------
def leer_argumentos():
  #- Argumento 1: puerto serie 
  try:
    serialName = sys.argv [1]
  except IndexError:
    print "-->Puerto serie no especificado"
    help()
    sys.exit(-1)

  return sys.argv[1]

#----------------------
#   MAIN
#----------------------
if __name__ == '__main__':

  #-- Procesador argumentos
  serialName = leer_argumentos()
  
  #-- Abrir la conexion y devolver el stargate generico
  g=libStargate.Generic.Open_session(serialName)
  if g==None: sys.exit(-1)
    
  #------------------------------------------
  #-- Hacer parpaear el led de la skypic  
  #------------------------------------------
  print "\nLed parpadeando...."
  try:
    while 1:
      g[PORTB]=0x02
      time.sleep(PERIODO/2.0)
      g[PORTB]=0x00
      time.sleep(PERIODO/2.0)
  except libStargate.Generic.Error,msg:
    print msg
  except:
    pass
  
  
  print "TERMINADO"
