#! /usr/bin/python
#---------------------------------------------------------------------------
#   boton.py 
#
#   La Skypic debe tener grabado el servidor generico
#
#---------------------------------------------------------------------------
#--  (C)Juan Gonzalez. Abril-2007
#--  LICENCIA GPL
#---------------------------------------------------------------------------

import sys
import time
sys.path = ['..'] + sys.path
import libStargate.Generic
from libStargate.pic16f876 import * 


ON = 1
OFF = 0

#-----------------------
#-- Mostrar la ayuda 
#-----------------------
def help():
  print """
Uso: test-generic <port>

 <Port>: Nombre del dispositivo serie a utilizar   
 
 Ejemplo: ./test-generic /dev/ttyUSB0
"""

#--------------------------------
#- Leer argumentos
#--------------------------------
def leer_argumentos():
  #- Argumento 1: puerto serie 
  try:
    serialName = sys.argv [1]
  except IndexError:
    print "-->Puerto serie no especificado"
    help()
    sys.exit(-1)

  return sys.argv[1]


#----------------------
#   MAIN
#----------------------
if __name__ == '__main__':

  #-- Procesador argumentos
  serialName = leer_argumentos()
  
  #-- Abrir la conexion y devolver el stargate generico
  g=libStargate.Generic.Open_session(serialName)
  if g==None: sys.exit(-1)
    
  #-- Configurar puerto B como salida  
  g[TRISB]=0x01
  
  #-- Estado inicial
  oldboton=1
  estado_led = False
  
  sys.stdout.write("Pulsador: ")
  
  #----------------------------------------------------------------
  #-- Bucle principal
  #-- Cada vez que se haga un click en el pulsador de la skypic
  #-- se cambia el estado del led
  #----------------------------------------------------------------
  
  #-- En cuanto haya una excepcion se termina
  try:
 
    while 1:
    
      #-- Leer estado actual del boton
      boton = g[PORTB] & 0x01
      
      #-- Compararlo con el estado anterior
      if boton!=oldboton:
        if boton==0: #-- Boton pulsado
          estado_led = not estado_led
          
      #-- Actualizar el led segun el estado
      if estado_led==True:
        g[PORTB]=0x02
      else:
        g[PORTB]=0x00      
      
      oldboton=boton;
      sys.stdout.write("%d\b" % boton)
      sys.stdout.flush()
      time.sleep(0.05)
        
  except libStargate.Generic.Error,msg:
    print msg

  except:
    pass

  print "TERMINADO"
