#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-

# Copyright: (C) 2007 by Juan González Gómez
#            (C) 2007 by Rafael Treviño Menéndez
# Authors: Juan González Gómez     <juan@iearobotics.com>
#          Rafael Treviño Menéndez <skasi.7@gmail.com>

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

#-----------------------------------------------------------------------
#  Programa de pruebas de la grabacion de firmware en el PICP  
#  Se graba el fichero .hex pasado como parametro
#
# LICENCIA GPL
#-----------------------------------------------------------------------

import sys
sys.path = ['..'] + sys.path
import libStargate.Picp
import libIris.IntelHex


#-- Palabra de configuracion a utilizar
CONFIG = 0x3F3A

#-----------------------
#-- Mostrar la ayuda 
#-----------------------
def help():
  print """
Uso: test-writeProgram <programa> [<port>]

 -Programa: Fichero .hex con el firmware a grabar
 -Port: Nombre del dispositivo serie a utilizar   
 
 Ejemplo:
    
    ./test-writeProgram ledp.hex /dev/ttyUSB0
"""

#--------------------------------
#- Leer argumentos
#--------------------------------
def leer_argumentos():

  #-- Argumento 1: Nombre del fichero .hex
  try:
    file = sys.argv[1]
  except IndexError:
    print "-->Nombre de programa no indicado"
    help()
    sys.exit(-1)

  #- Argumento 2: puerto serie 
  try:
    serialName = sys.argv [2]
  except IndexError:
    print "-->Puerto serie no especificado"
    help()
    sys.exit(-1)

  return sys.argv[1],sys.argv[2]

#----------------------
#   MAIN
#----------------------
if __name__ == '__main__':

  #-- Leer los argumentos
  file,serialName = leer_argumentos()
  
  #-------------------------------------------  
  #-- Analizar fichero .hex
  #-------------------------------------------
  try:
    hr = libIris.IntelHex.HexReader (file)
  except libIris.IntelHex.ReaderError,msg:
    print msg
    sys.exit(-1)

  #-- Obtener el programa en el formato correcto
  program = hr.dataBlocks() 
  
  #-------------------------------------------------
  #-- Abrir la conexion y devolver el stargate PICP
  #-------------------------------------------------
  picp=libStargate.Picp.Open_session(serialName)
  if picp==None: sys.exit(-1)
  
  #-----------------------------
  #-- Detectar el PIC destino  
  #-----------------------------
  try:
    id,config = picp.readConfig()
  except libStargate.Picp.Error,msg: 
    print "%s" % msg

  if id==0x3FFF:
    print "PIC DESTINO no detectado."
    sys.exit(-1);
  
  print "PIC DETECTADO. Id: %04X" % (id)
  print ""
  
  
  #-------------------------------------
  #-- TODO OK. Realizar la grabacion
  #-------------------------------------
  
  print 'Fichero: "%s"' % file

  try:
    picp.writeProgram (program)
  except libStargate.Picp.Error,msg:
    print "\n %s" % msg
    sys.exit(-1)
    
  print "Grabando palabra de configuracion: %04X" % CONFIG
  try:
    picp.writeConfig(CONFIG)
  except:
    print 'Error de escritura de la configuracion'

  print "OK"
