#!/usr/bin/env python
# -*- coding: iso-8859-15 -*-

#-----------------------------------------------------------------------------
#
#-  Modulo stargate Generico, que implementa los servicios load y Store
#
# LICENCIA GPL
#-----------------------------------------------------------------------------

# Description: libStargate is a library for comunication to stargates
# Copyright: (C) 2007 by Juan González Gómez
#            (C) 2007 by Rafael Treviño Menéndez
# Authors: Juan González Gómez     <juan@iearobotics.com>
#          Rafael Treviño Menéndez <skasi.7@gmail.com>

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
#------------------------------------------------------------------------------

import libStargate.Main


#--- Cadena identificativa del servidor PICP
GENERIC_IDENT = "GENERIC"

#-----------------------------------
#------ Cabeceras de la trama 
#-----------------------------------
TRAMA_LOAD_CAB   = 'L'   #-- Servicio LOAD
TRAMA_RLOAD_CAB  = 'L'
TRAMA_STORE_CAB  = 'S'   #-- Servicio STORE
TRAMA_RSTORE_CAB = 'S'


#-----------------------------------------------
#- Abrir la conexion con el servidor generico
#-----------------------------------------------
def Open_session(serialName,logCallback=libStargate.Main.default_log):
  
  #-- Abrir puerto serie 
  try:
    g = libStargate.Generic.Open (serialName,logCallback)
  except:
    logCallback("Error al abrir puerto serie")
    return None
    
  #---------------------------------------------
  #-- Comprobar la conexion con el servidor   
  #---------------------------------------------
  
  #--- Comprobar si hay conexion
  ok=g.check_connection();
  if (not ok):
    return None
  
  #-- Comprobar si el servidor al que se accede es el correcto (GENERIC)
  ok=g.check_server_type();
  if (not ok):
    return None
    
  return g  


#----------------------------------------
#- Clase para la gestion de los errores
#----------------------------------------
class Error (Exception):
  """
  Excepciones producidas en el modulo Generic
  """
  pass


#---------------------------------------------------------------------
#  CLASS STARGATE GENERIC
#---------------------------------------------------------------------
class Open (libStargate.Main.Stargate):

  #-- Inicializar la clase
  def __init__(self, port, logCallback=libStargate.Main.default_log):
    libStargate.Main.Stargate.__init__(self,port,logCallback)
    

  #------------------------------------------------
  #-- Obtener si el servidor es el correcto (PICP)
  #------------------------------------------------
  def check_server_type(self):
  
    #-- servidor debe ser del tipo PICP
    ok=libStargate.Main.Stargate.check_server_type(self,GENERIC_IDENT);
    
    if ok:
      self.log("Servidor correcto");
      self.log("\n");
      return True;
    else:
      self.log("Servidor esperado: %s. \n" % GENERIC_IDENT);
      self.log("---> SERVIDOR INCORRECTO\n");
      return False;
    

  #-----------------------------------
  #-- Servicio LOAD
  #-- Devuelve el valor leido
  #-- POR HACER: si no puede leer el valor, se deberia lanzar una excepcion
  #-----------------------------------
  def load(self,dir):
  
    #-- Si puerto serie no abierto retornar
    if self.serial==None: return 0
    
    #-- Enviar trama 
    self.serial.write(TRAMA_LOAD_CAB)
    self.serial.write(chr(dir & 0xFF))
    self.serial.write(chr((dir >>8)&0xFF))
    
    #-- Esperar respuesta
    load = self.serial.read(2);
    
    #-- Timeout o dato incorrecto
    if len(load)==0 or load[0]!=TRAMA_RLOAD_CAB: 
    
      #-- Vaciar los buffers de entrada y salida
      self.serial.flushInput()
      self.serial.flushOutput()
      raise Error, "ERROR DE COMUNICACION (load)"
    
    #-- load ok
    return ord(load[1])
    
  #---------------------------------------
  #- Metodo GET. Equivalente a un LOAD  
  #---------------------------------------
  def __getitem__(self, dir):
    return self.load(dir) 

  #-------------------
  #-- Servicio STORE
  #-------------------
  def store(self, dir, valor):
  
    #-- Si puerto serie no abierto retornar
    if self.serial==None: return 0
    
    #-- Enviar trama 
    self.serial.write(TRAMA_STORE_CAB)
    self.serial.write(chr(dir & 0xFF))
    self.serial.write(chr((dir >>8)&0xFF))
    self.serial.write(chr(valor&0xFF))
    
    #-- Esperar respuesta
    store = self.serial.read(1);
    
    #-- Timeout o dato incorrecto
    if len(store)==0 or store!=TRAMA_RSTORE_CAB:
    
      #-- Vaciar los buffers de entrada y salida
      self.serial.flushInput()
      self.serial.flushOutput()
      raise Error, "ERROR DE COMUNICACION (Store)"
      
 
  #---------------------------------------
  #- Metodo GET. Equivalente a un STORE
  #---------------------------------------
  def __setitem__(self, dir, valor): 
    return self.store(dir,valor)
