;/-----------------------------------------------
;/ Ejemplo de Driver con temporizacion RTC      /
;/ con Acceso a la memoria EEWire               /
;/                                              /
;/ Andres Prieto-Moreno Torres                  /
;/ ETC-II                                       /
;/----------------------------------------------/


; ETIQUETAS DEL PROGRAMA

SERV  EQU 0EE01H  ; codigo que indentifica al driver
ERRN  EQU 0FFH
OK    EQU 00H
VIDEO EQU 0B800H   ; Posicion de memoria donde empieza el modo 80x25
CONTA EQU 2H


; CODIGO DEL PROGRAMA

codesg  SEGMENT
	assume cs:codesg, DS:codesg, SS:codesg , ES:codesg
	; El ORG 100H es necesario para generar programas .COM ya que
	; la zona de memoria anterior es ocupada por el PSP
	ORG	100H

start:
	jmp instalar  ; la primera vez que se ejecuta lo dejamos residente




;************************************************
;* Funciones del RTC                            *
;************************************************

; Funcion que configura el periodo del RTC
config_rtc proc far
        PUSH ax

        CLI
        ; configuro PIC
        IN    AL,021H
        AND   AL, 0FBH
        OUT   021H, AL   ; Pongo a 0 bit 2 puerto 21H
        IN    AL,0A1H
        AND   AL, 0FEH
        OUT   0A1H, AL   ; Pongo a 0 bit 0 puerto A1H

        ; configuro la frecuencia
        MOV   AL, 0AH
        OUT   070H,AL
        MOV   AL,02FH   ; 0010-xxxx
        OUT   071H,AL

        STI
        POP AX
        RET
config_rtc endp


; Activa las interrupciones del RTC
start_rtc proc far
        PUSH AX
        CLI

        ; activo interrupcion PIE
        MOV   AL, 0BH
        OUT   070H,AL
        IN    AL,071H
        OR    AL,040H
        AND   AL,047H
        MOV   AH,AL
        MOV   AL,0BH
        OUT   070H,AL
        MOV   AL,AH
        OUT   071H,AL
        MOV   AL, 0CH   ; necesario para activar las interrupciones
        OUT   070H,AL
        IN    al,071H

        STI
        POP   AX
        RET
start_rtc endp


; Desactiva las interrupciones del RTC
stop_rtc proc far
        PUSH AX
        CLI

        ; desactivo interrupcion PIE
        MOV   AL, 0BH
        OUT   070H,AL
        IN    AL,071H
        AND   AL,0BFH
        MOV   AH,AL
        MOV   AL,0BH
        OUT   070H,AL
        MOV   AL, AH
        OUT   071H,AL
        MOV   AL, 0CH
        OUT   070H,AL
        IN    AL,071H

        STI
        POP   AX
        RET
stop_rtc endp



;........................................................................
;. Rutina de servicio de la interrupcion 1CH (pos en tabla 70H)         .
;........................................................................
serv70_int proc far
	CLI
	PUSH AX BX ES DS DX

	MOV  AX,CS
	MOV  DS,AX

	; compruebo que ha sido el PIE quien ha interrumpido
	MOV  AL, 0CH
	OUT  070H,AL
	IN   AL,071H
	AND  AL,040H
	JNZ  pi_int
	JMP  salir

;------------------------------------------------------------------------
;-  Codigo de mi rutina de interrupcion:
;-     rota un caracter en la pantalla
;-     hace parpadear un LED colocado en el bit D3 del puerto paralelo
;------------------------------------------------------------------------
pi_int:  
	MOV  AX,VIDEO
	MOV  ES,AX      ; ES apunta a la memoria de video
	MOV  BX, CONT   ; BX contiene el estado del puntero a la tabla
	INC  BX
	CMP  BX,4     ; hemos superado el final tabla ?
	JNE  sigue     ; NO -> apunta al carater que corresponda
	MOV  BX,0      ; SI -> apunta al primer caracter

; pinta el caracter en la esquina superior izquierda
sigue:
	MOV  AL, TABLA[BX+0]
	MOV  byte ptr ES:[09EH],AL
	; devuelve el control
	MOV  word ptr CONT,BX
	
	; Hace parpadear el LED 
	MOV DX, DIR_BASE
	IN  AL, DX
	XOR AL, 08H
	OUT DX, AL
	
;---------------------------------------------------------
;- Fin de mi codigo de la rutina de interrupcion
;---------------------------------------------------------

salir:   ;  necesario para terminar correctamente la interrrupcion
	MOV  al, 020H   ; cargo EOI
	OUT  020H, al   ; mando EOI al PIC maestro
	OUT  0A0H, al   ; mando EOI al PIC esclavo

	POP  DX DS ES BX AX
	STI
	IRET
serv70_int endp




;******************************************************************
;* Funciones de acceso a la memoria EEWIRE                        *
;******************************************************************

;****************************************************************
;*                                                              *
;*  Puerto Datos   D7   D6   D5   D4   D3   D2   D1   D0        *
;*  Descripcion   VCC   --  ORG   --  LED   DI  CLK   CS        *
;*   Fijos          1    0    0    0    X    X    X    X        *
;*                                                              *  
;****************************************************************

tic proc
	call pausa
	OR   AL, 10000010B
	OUT  DX, AL
	call pausa
	AND  AL, 11111101B  
	OUT  DX, AL
	call pausa
	RET
tic endp

;****************************************************
;* Envia ERAL  : Borra toda la memoria              *
;****************************************************

eral_eewire proc
	PUSH  AX DX

	; para apuntar bien a las variables
	MOV  DX,CS
	MOV  Ds,DX
	; cargo la direccion base del puerto
	MOV DX, DIR_BASE
		
	XOR CX,CX
	XOR AX,AX
	
	; El estado inicial deberia ser
	; VCC = 1, ORG=0   (obligatiorio)
	; CLK, DI, CS todos a cero (lo ponemos ahora )
	
	MOV  AL, 10000000B   ; solo la memoria activada
	OUT  DX,AL      ; salida por el puerto paralelo
	CALL pausa      ; por si no estaba activada, le doy un tiempo de estabilizacion
	
	
	; --- Pongo CS y DI a 1 para iniciar una START CONDITION
	OR   AL, 00000001B   ; subo CS
	OUT  DX,AL
	OR   AL, 00000100B   ; subo DI
	OUT  DX,AL
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora mando el OPCODE (00)
	AND  AL, 11111011B    ; DI=0
	OUT  DX, AL

	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora mando (10) y luego otros 7 'unos' para rellenar.
	OR   AL, 00000100B    ; DI=1
	OUT  DX,AL
	CALL tic

	AND  AL, 11111011B    ; DI=0
	OUT  DX, AL
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; --- termino de mandar el comando
	AND  AL, 10001000B   ; dejo VCC y estado LED
	OUT  DX, AL

	POP DX AX
	RET
eral_eewire endp



;****************************************************
;* Envia EWEN  : Activacion escritura y borrado     *
;****************************************************

ewen proc
	PUSH  AX DX

	; para apuntar bien a las variables
	MOV  DX,CS
	MOV  Ds,DX
	; cargo la direccion base del puerto
	MOV DX, DIR_BASE
		
	XOR CX,CX
	XOR AX,AX
	
	; El estado inicial deberia ser
	; VCC = 1, ORG=0   (obligatiorio)
	; CLK, DI, CS todos a cero (lo ponemos ahora )
	
	MOV  AL, 10000000B   ; solo la memoria activada
	OUT  DX,AL      ; salida por el puerto paralelo
	CALL pausa      ; por si no estaba activada, le doy un tiempo de estabilizacion
	
	
	; --- Pongo CS y DI a 1 para iniciar una START CONDITION
	OR   AL, 00000001B   ; subo CS
	OUT  DX,AL
	OR   AL, 00000100B   ; subo DI
	OUT  DX,AL
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora mando el OPCODE (00)
	AND  AL, 11111011B    ; DI=0
	OUT  DX, AL

	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora mando (11) y luego otros 7 'unos' para rellenar.
	OR   AL, 00000100B
	OUT  DX,AL
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; --- termino de mandar el comando
	AND  AL, 10001000B   ; dejo VCC y estado LED
	OUT  DX, AL

	POP DX AX
	RET
ewen endp


;****************************************************
;* Read Address: Lee una posicion de memoria        *
;****************************************************

read_eewire proc
	PUSH  AX BX DX

	; para apuntar bien a las variables
	MOV  DX,CS
	MOV  Ds,DX
	; cargo la direccion base del puerto
	MOV DX, DIR_BASE
		
	XOR CX,CX
	XOR AX,AX
	
	; El estado inicial deberia ser
	; VCC = 1, ORG=0   (obligatiorio)
	; CLK, DI, CS todos a cero (lo ponemos ahora )
	
	MOV  AL, 10000000B   ; solo la memoria activada
	OUT  DX,AL      ; salida por el puerto paralelo
	CALL pausa      ; por si no estaba activada, le doy un tiempo de estabilizacion
	
	; --- Pongo CS y DI a 1 para iniciar una START CONDITION
	OR   AL, 00000001B   ; subo CS
	OUT  DX,AL
	OR   AL, 00000100B   ; subo DI
	OUT  DX,AL
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora mando el OPCODE (10)
	CALL tic; 
	
	AND  AL, 11111011B    ; DI=0
	OUT  DX, AL
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora mando la direccion 9 bits menos significativos de BX 
	; --- Estoy mirando posicion 000001111B
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	OR   AL, 00000100B
	OUT  DX,AL
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora leo los datos 
	; leo los bits de mayor peso a menor peso
	; lo repito 8 veces
	
	XOR  CH,CH
	MOV  CL,8
	
lee_bit:
	
	;CALL tic
;------------------ parte 1 flanco subida	
	call pausa
	OR   AL, 10000010B
	OUT  DX, AL
	call pausa
;----------------- fin parte 1	
	
	PUSH AX   ; Guardo el valor del Puerto de Datos
	INC  DX
	
	IN   AL, DX
	AND  AL, 020H  ; E5 entrada de datos
	CMP  AL, 0
	JE   leido_cero
	SHL  CH,1      ; lo muevo a la izquierda 
	OR   CH, 1
	JMP  next
leido_cero:
	SHL  CH,1
	AND  CH, 0FEH
	
next:
	POP  AX   ; recupero el valor del Puerto de DATOS
	DEC  DX

;-------- parte 2 flanco bajada
	AND  AL, 11111101B  
	OUT  DX, AL
;------ fin parte 2

	MOV  AUX,CH  ; guardo variable
	DEC  CL
	CMP  CL,0
	JNE  lee_bit
	; fin lectura
	
	; --- termino de leer el dato
	AND  AL, 10001000B   ; dejo VCC y estado LED
	OUT  DX, AL
	
	call pausa

	POP DX BX AX
	RET
read_eewire endp


;****************************************************
;* Write Address: Escribe una posicion de memoria   *
;****************************************************

write_eewire proc
	PUSH  AX BX DX

	; para apuntar bien a las variables
	MOV  DX,CS
	MOV  Ds,DX
	; cargo la direccion base del puerto
	MOV DX, DIR_BASE
		
	XOR CX,CX
	XOR AX,AX
	
	; El estado inicial deberia ser
	; VCC = 1, ORG=0   (obligatiorio)
	; CLK, DI, CS todos a cero (lo ponemos ahora )
	
	MOV  AL, 10000000B   ; solo la memoria activada
	OUT  DX,AL      ; salida por el puerto paralelo
	CALL pausa      ; por si no estaba activada, le doy un tiempo de estabilizacion
	
	; --- Pongo CS y DI a 1 para iniciar una START CONDITION
	OR   AL, 00000001B   ; subo CS
	OUT  DX,AL
	OR   AL, 00000100B   ; subo DI
	OUT  DX,AL
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora mando el OPCODE (01)
	AND  AL, 11111011B    ; DI=0
	OUT  DX, AL
	CALL tic
	
	OR   AL, 00000100B    ; DI=1
	OUT  DX, AL
	CALL tic
	
	AND  AL, 11111011B    ; DI=0
	OUT  DX, AL
	
	; --- Ahora mando la direccion 9 bits menos significativos de BX 
	; --- Estoy mirando posicion 000001111B
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	OR   AL, 00000100B
	OUT  DX,AL
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; hago un pulso de reloj
	CALL tic
	
	; --- Ahora escribo el dato 
	; bits de mayor peso a menor peso
		
	; escribo byte = 10010110B = 096H

	;bit 7 = 1
	OR   AL, 00000100B
	OUT  DX,AL
	CALL tic
	
	; bit 6 = 0
	AND  AL, 11111011B
	OUT  DX,AL
	CALL tic

	; bit 5 = 0
	CALL tic
	
	; bit 4 = 1
	OR   AL, 00000100B
	OUT  DX,AL
	CALL tic
	
	; bit 3 = 0
	AND  AL, 11111011B
	OUT  DX,AL
	CALL tic

	; bit 2 = 1
	OR   AL, 00000100B
	OUT  DX,AL
	CALL tic
	
	; bit 1 = 1
	CALL tic
	
	; bit 0 = 0
	AND  AL, 11111011B
	OUT  DX,AL
	CALL tic
	
	; fin escritura
	
	; --- termino de escribir el dato
	AND  AL, 10001000B   ; dejo VCC y estado LED
	OUT  DX, AL
	
	call pausa

	POP DX BX AX
	RET
	
write_eewire endp




;***********************************************
;* Funciones auxiliares                        *
;***********************************************

pausa proc
	PUSH AX
	MOV  AX,CONTA
sig:
	DEC  AX
	CMP  AX,0
	JNE  sig
	POP  AX
	RET
pausa endp




;************************************************
;* Servicios del Driver                         *
;************************************************

;............................................
;. SERVICIO AH=0 Comprobacin del DRIVER    .
;. E - AH=0 Comprobacion del driver         .
;. S - AX=0xEE01H                           .
;............................................

status:
	MOV  AX, SERV
	IRET


;............................................
;. SERVICIO AH=1 Desinstalar                .
;. E - AH=1 Desinstalar                     .
;. S - AH=OK                                .
;............................................
desinstalar:
	;-- codigo que desinstala el driver --
	MOV AH,OK
	IRET


;............................................
;. SERVICIO AH=2 Read                       .
;. E - AH=2 Read                            .
;. E - DI=posicion a leer                   .
;. S - AH=ERRN(fuera tamao o no disponible).
;. S - AH=OK                                .
;. S - AL=Dato ledo                        .
;............................................

read:
	; -- cdigo que accede a la memoria fsica y lee valor --
	call read_eewire
	; -- vamos a decir que leemos 0AAH y que no hay error para probar !!!!
	MOV AH,OK
	MOV AL,0AAH   
	
	IRET


;............................................
;. SERVICIO AH=3 Write                      .
;. E - AH=3 Write                           .
;. E - DI=posicion a escribir               .
;. E - AL=Dato a escribir                   .
;. S - AH=OK                                .
;.   - AH=ERRN(fuera de rango o no se pudo) .
;............................................

write:
	; -- cdigo que accede a la memoria fsica y escribe valor --
	call ewen
	call write_eewire
	; -- vamos a decir que leemos 0AAH y que no hay error para probar !!!!
	MOV AH,OK
	MOV AL,0AAH   
	
	IRET


;............................................
;. SERVICIO AH=4 Working                    .
;. E - AH=4 Working                         .
;. S - AH=OK  puede procesar otras ordenes  .
;.   - AH=ERRN (dispositivo ocupado)        .
;............................................
working:
	; -- aadir el codigo de working --
	IRET


;............................................
;. SERVICIO AH=5 EESIZE                     .
;. E - AH=4 EESIZE                          .
;. S - AX=Tamao (512bytes)                 .
;. S - BL=OK                                .
;............................................
eesize:
	MOV AX,512 
	MOV BL,OK
	IRET



;............................................
;. SERVICIO AH=6 Led                        .
;. E - AH=6 Led                             .
;. E - AL=0 apaga - 1 enciende              .
;. S - AH=OK                                .
;............................................
led:
	PUSH DX
	PUSH DS
	
	MOV  DX,CS
	MOV  Ds,DX
	
	MOV  AH,OK
	CMP  AL,0
	JE   apaga_led
enciende_led:
	;-- codigo que enciende el LED --
	MOV DX, DIR_BASE
	IN  AL, DX
	OR  AL, 08H
	OUT DX, AL
	
	POP DS
	POP DX
	IRET
apaga_led:	
	;-- codigo que apaga el LED --
	MOV DX, DIR_BASE
	IN  AL, DX
	AND AL, 0F7H
	OUT DX, AL
	
	POP DS
	POP DX
	IRET


;............................................
;. SERVICIO AH=7 Efecto RTC                 .
;. E - AH=6 RT                              .
;. E - AL=0 apaga - 1 enciende              .
;. S - AH=OK                                .
;............................................
efecto:
	MOV  AH,OK
	CMP  AL,0
	JE   apaga_parpadeo
enciende_parpadeo:
	CALL start_RTC
	IRET
apaga_parpadeo:	
	CALL stop_RTC
	IRET


;............................................
;. SERVICIO AH=8 ERAL                       .
;. E - AH=8 ERAL                            .
;. S - AH=OK                                .
;.   - AH=ERRN(fuera de rango o no se pudo) .
;............................................

eral:
	; -- cdigo que accede a la memoria fsica y escribe valor --
	call ewen    ; desprotejo la escritura
	call eral_eewire
	; -- vamos a decir que leemos 0AAH y que no hay error para probar !!!!
	MOV AH,OK
	MOV AL,0AAH   
	
	IRET




;***********************************************************
;* Programa principal del driver                           *
;* Comprueba los servicios solicitados                     *
;***********************************************************

; Cuando llamamos a la INT61H esto es lo que se tiene que ejecutar


driver proc far   
	JMP  parser
	
	; chequeo extra driver
	DW   0CAFEH    

;---------- Declaracion de variables --------------------
			; para guardar los valores originales de la interrupcin 61h
OFFSET_DRV  DW 0
SEGMEN_DRV  DW 0

OFFSET_RTC  DW 0
SEGMEN_RTC  DW 0

DIR_BASE    DW 0

OFFSET_O   DW 0
SEGMEN_O   DW 0

TABLA      DB  02FH, 07CH, 05CH, 02DH
CONT       DW 0

AUX        DB 0
FLAG       DB 0

;----------- Fin declaracion variables -----------------

parser:
	CMP  AH, 0
	JNE  p1
	JMP  status

p1:
	CMP  AH, 1
	JNE  p2
	JMP  desinstalar

p2:
	CMP  AH, 2
	JNE  p3
	JMP  read
	
p3:
	CMP  AH, 3
	JNE  p4
	JMP  write

p4:
	CMP  AH, 4
	JNE  p5
	JMP  working

p5:
	CMP  AH, 5
	JNE  p6
	JMP   eesize

p6:
	CMP  AH, 6
	JNE  p7
	JMP   led

p7:
	CMP  AH, 7
	JNE  p8
	JMP  efecto
	
p8:
	CMP  AH, 8
	JE   eral
	; error en llamada a funcion
	MOV  AH, ERRN
	IRET
driver  endp


;===================================================
; CODIGO QUE INSTALA EL DRIVER
; Tambien instala la rutina de interrupcion del RTC
;===================================================

instalar proc 

	CLI

	; saco la direccion del LPT1 (miro en la BIOS)
	MOV  AX, 0040H     ; zona de la BIOS que me indica las direcciones de los puertos
	MOV  ES, AX
	MOV  DX, ES:[08H] ; direccion Puerto Paralelo 1
	MOV  DIR_BASE,DX

	MOV  AL,080H      ; Enciendo la memoria
	OUT  DX,AL
	
	;---------------------------------------------------------
	; RTC: Instalo el vector de interrupcion 70H  (pos 1C0H)
    ;---------------------------------------------------------

	XOR AX,AX
	MOV ES,AX
    
    ; guardo los valores iniciales
    MOV  AX, word ptr ES:[01C0H]
    MOV  OFFSET_RTC, AX
    MOV  AX, word ptr ES:[01C2H]
    MOV  SEGMEN_RTC, AX
    
	; pongo los nuevos
    ; hago que apunte a la subrutina 'serv70_int'
    MOV  word ptr ES:[01C0H],offset serv70_int
    MOV  word ptr ES:[01C2H],cs
    
	; Configuro el RTC
	call config_rtc
	
	;----------------------------------------------------------
	; Instalo el Driver:
	;     primero configuro los registros de interrupcion 61H
	;     salgo del programa dejandolo residente en memoria
	;----------------------------------------------------------
	
	XOR AX,AX
	MOV ES,AX
    
	; actualizo tabla interrupciones para colocar la 61h
	; guardo los valores iniciales
    MOV  AX, word ptr ES:[061H*4]
    MOV  OFFSET_DRV, AX
    MOV  AX, word ptr ES:[061H*4+2]
    MOV  SEGMEN_DRV, AX

	; pongo el nuevo valor apuntando al trozo de programa que queremos que se ejecute al 
	; llamar a la interrupcion (driver)
	MOV  ES:[061H*4]  , OFFSET driver  ; colocamos el OFFSET al codigo de inicio en la tabla de interrupciones
	MOV  ES:[061H*4+2], CS             ; colocamos el SEGMENTO al codido de inicio en la tabla de interrupciones
	STI
	
	; funcion que se encarga de dejar el programa residente
	MOV  DX, OFFSET instalar   
	INT  27H
instalar endp



codesg	ends

end	start

