//--------------------------------------------------
//- Hacked_servo.h
//-                        Library for hacked servo
//--------------------------------------------------
//- This library is almost identical to the Servo 
//- library of Arduino, but adds extra funcionalities
//- for reading the actual position of the servo.
//--------------------------------------------------
//- Author: David Estévez
//- GPL license
//--------------------------------------------------


#include <Servo.h>
#include "WProgram.h"
#include "Hacked_servo.h"

//- Constructor

Hacked_servo::Hacked_servo()
{
	_pin_servo = -1;
	_pin_analog = -1;
	_min_value = 0;
	_max_value = 1023;

}

//- Standard Servo library functions:

void Hacked_servo::write( int value) { servo.write(value); }
void Hacked_servo::writeMicroseconds(int ms) { servo.write(ms); }

int Hacked_servo::read() { return servo.read(); }

bool Hacked_servo::attached() { return servo.attached(); }
void Hacked_servo::detach() { if (_pin_servo != -1) servo.detach(); }

//- New functions

//Attachs a servo to pin_servo, sets pin_analog as analog input
void Hacked_servo::attach( int pin_servo, int pin_analog)
{
	_pin_servo = pin_servo;
	_pin_analog = pin_analog;

	servo.attach(pin_servo);
}

int  Hacked_servo::readPos()
{
	float value = analogRead(_pin_analog);
	int angle = map(value, _min_value, _max_value, 0, 180);
        return angle;
}

void Hacked_servo::calibrate( int min_value, int max_value) 
{
	_min_value = min_value;
	_max_value = max_value;
}

