/****************************************************/
/* Ejemplo para mover un motor paso a paso          */
/* Entrenadora GpBot + GpIfaz                       */
/*--------------------------------------------------*/
/* Andres Prieto-Moreno                      UAM09  */
/*--------------------------------------------------*/
/*                                                  */
/* El motor paso a paso se conectara a las entradas */
/* M1 y M2 de la GpIfaz.                            */
/*                                                  */
/* La alimentacin del motor es de 12v y se usa la  */
/* toma externa de la GpIfaz. Para ello configurar  */
/*   Posicin JP5: 2-3                              */
/*   Posicin JP6: 1-2                              */ 
/****************************************************/


#include <MC68HC908GP32.h>
  

// En cada paso cambia la polarizacin de una bobina mientras
// se mantiene sin variar al resto
#define STEP1 0x18;   // 0001.1000
#define STEP2 0x0C;   // 0000.1100
#define STEP3 0x06;   // 0000.0110
#define STEP4 0x12;   // 0001.0010

  
/************************************************/
/* Inicializacion del temporizador. Se debe     */
/* llamar esta funcion antes de hacer cualquier */
/* pausa.                                       */
/************************************************/
void delay_init(void)
{
	/*-----------------------------*/
	/*- Configurar el temporizador */
	/*-----------------------------*/
	T1SC   = 0x02;    // Prescaler
	T1MODH = 0x08;    // Establecer modulo 0x0800
	T1MODL = 0x00;
}


/***************************************************/
/* Rutina de pausa                                 */
/*-------------------------------------------------*/
/* ENTRADAS:                                       */
/*   time: Numero de unidades de tiempo a esperar  */
/***************************************************/
void delay(unsigned char time)
{
	while (time>0) {
	  //-- Esperar a que se ponga a '1' el Flag de Overflow del temporizador
	  while(!(T1SC & 0x80));
		
    //-- Poner a 0 el flag
	  T1SC&=(~0x80);

		time--;
	}		
}


void main(void) {


	/*----------------------------*/
	/* Configurar el sistema      */
	/*----------------------------*/
	CONFIG1|=0x01;  //-- Deshabilitar el COP  (WatchDog)
	DDRB=0xFF;      //-- Configurar Puerto B para salida
	PTB=0x00;       //-- Poner a 0 Puerto B
	DDRC=0x1E;  	  //-- Configurar pines PTC1, PTC2, PTC3 y PTC4 para salida
	PTC=0x00;       //-- Poner a 0 el Puerto C
	
	//-- Inicializar el modulo de pausa
	delay_init();
	

  for(;;) {
  
    // Hago la secuencia de pasos, entre paso y paso dejo una pausa porque necesito
    // dar tiempo a las bobinas para que se polaricen.
      
    PTC=STEP1; //-- Paso 1
    PTB^=0x40; //-- Cambiar de estado bit6 del puerto B (LED)
		delay(1);  //-- Pausa
		
		PTC=STEP2; //-- Paso 2	
    PTB^=0x40; //-- Cambiar de estado bit6 del puerto B (LED)
		delay(1);  //-- Pausa
		
		PTC=STEP3; //-- Paso 3	
    PTB^=0x40; //-- Cambiar de estado bit6 del puerto B (LED)
		delay(1);  //-- Pausa
		
		PTC=STEP4; //-- Paso 4	
    PTB^=0x40; //-- Cambiar de estado bit6 del puerto B (LED)
		delay(1);  //-- Pausa
		
		// Vuelvo a repetir la secuencia. Si quiero cambiar el sentido la hago a la inversa
		
  } /* loop forever */
  /* please make sure that you never leave this function */
}
