/*******************************************************************/
/* Rutinas de acceso al puerto serie                               */
/* (c) Juan Gonzalez 2007. LICENCIA GPL                            */
/*******************************************************************/

#include 	<termios.h>  
#include 	<fcntl.h>
#include	<string.h>
#include <sys/ioctl.h>
#include <unistd.h>

#include "serial.h"


/******************************************************/
/* Abrir puerto serie.                                */
/* ENTRADAS:                                          */
/*   -disp: Dispositivo serie                         */
/* SALIDAS:                                           */
/*   *Descriptor del fichero                          */
/*   * -1 si ha habido un error                       */
/******************************************************/
int sg_serial_open(char *disp)
{
  struct termios newtermios;
  int fd;

  fd = open(disp,O_RDWR | O_NOCTTY); /* Abrir puerto serie */

  /* Modificar los atributos */
  newtermios.c_cflag= CBAUD | CS8 | CLOCAL | CREAD;
  newtermios.c_iflag=IGNPAR;
  newtermios.c_oflag=0;
  newtermios.c_lflag=0;
  newtermios.c_cc[VMIN]=1;
  newtermios.c_cc[VTIME]=0;

  /* Establecer velocidad por defecto */
  cfsetospeed(&newtermios,B38400);
  cfsetispeed(&newtermios,B38400);
  
  /* Vaciar los buffers de entrada y salida */
  if (tcflush(fd,TCIFLUSH)==-1) {
    return -1;
  }

  /* Vaciar buffer de salida */
  if (tcflush(fd,TCOFLUSH)==-1) {
    return -1;
  }

  /* Escribir los nuevos atributos */
  if (tcsetattr(fd,TCSANOW,&newtermios)==-1) {
    return -1;
  }  

  return fd;
}

/************************************************/
/* Leer un caracter con timeout.                */
/* ENTRADAS:                                    */
/*  -fd: Descriptor del fichero                 */
/*  -timeout: Timeout en microsengundos         */
/* SALIDAS:                                     */
/*  -car: caracter leido                        */
/* DEVUELVE:                                    */
/*    1: ok                                     */
/*    0: Timeout                                */
/************************************************/
int read_car(int fd, unsigned char *car, unsigned int tout)
{
  fd_set fds;
  ssize_t n;
  struct timeval timeout;
  int ret;

  //-- Leer mediante select
  FD_ZERO(&fds);
  FD_SET (fd, &fds);
  
  timeout.tv_sec = 0;      //-- Establecer el TIMEOUT
  timeout.tv_usec = tout;

  ret=select (FD_SETSIZE,&fds, NULL, NULL,&timeout);
  
  if (ret==1) {  //-- Lectura OK
    n=read (fd, car, 1);
    return 1;
  }
  else {  //-- Timeout
    return 0;
  }  
}

void sc_signal_dtr_set(int fd, int estado)
/***********************************************************/
/*  Establecer el estado de la señal DTR.                  */
/***********************************************************/
{
  int arg;
  int cmd;

  /* Señal a modificar */
  arg = TIOCM_DTR;

  if (estado==DTR_ON) {
    cmd=TIOCMBIS;
  }
  else cmd=TIOCMBIC;

  /* Escribir estado actual */
  ioctl(fd,cmd,&arg);
}

/***********************************************************/
/* Enviar una cadena por el puerto serie                   */
/***********************************************************/
void sg_serial_enviar(int serial_fd, char *trama, int tam)
{
  write(serial_fd, trama, tam);
}
