/************************************************************************/
/* Descarga de programas en la skypic.                                  */
/* (C) 1999 HI-TECH Software                                            */
/* (C) 2005 Javier Pascual Soriano                                      */
/* (C) 2006-2007 Juan Gonzalez                                          */
/*----------------------------------------------------------------------*/
/* Licencia GPL                                                         */
/************************************************************************/

#include <unistd.h>
#include <stdio.h>
#include <stdlib.h>
#include <string.h>


#include "serial.h"
#include "proto.h"
#include "gethex.h"

/*****************************/
/* CONSTANTES                */
/*****************************/
#define VERSION "1.2"
#define MaxBuf 32

#define DEF_PORT "/dev/ttyS0"
#define DEF_SPEED "38400"
#define MAX_RETRY 50

/*-----------------------------------------------------------------------*/
/* ESTO ES MUY IMPORTANTE!!! Valores de los Timeouts, en micro-segundos  */
/*-----------------------------------------------------------------------*/
//-- Timeout para la identificacion
#define TIMEOUT_IDENT 100000
#define TIMEOUT_WRITING 300000


/*****************************/
/* VARIABLES                 */
/*****************************/
static int serial_fd;          //-- Descriptor para el puerto serie
static char serial_name[255];  //-- Nombre del dispositivo serie
static char fich[255];         //-- Nombre del fichero a descargar

//-- Variables externas
extern prog_data prog[ROM_SIZE];
extern unsigned total;


static unsigned char last=0;



void sendbyte(unsigned char ch) {
    last = ch;
    write(serial_fd, &ch, 1);
}


/**********************************************/
/* Indicar al bootloader que se ha terminado  */
/**********************************************/
void SendDone(void) {
    unsigned char ch;

    printf("Activating program...");
    fflush(stdout);
    sendbyte(DONE);
    read_car(serial_fd, &ch,TIMEOUT_WRITING);
    if (ch==WOK) {
        printf(" - OK\n");
        return;
    }
    printf("bad write [%X]\n\n",ch);
    exit(1);
}

/*************************************/
/* Decargar el fichero HEX           */
/*************************************/
void DownLoad(void) 
{

  unsigned char buff[MaxBuf]={0};
  unsigned char chk,ch,*ptr;
  unsigned count,address,buftot,last,loop;

   
    printf("Writing: ");
    fflush(stdout);
  
    count=0;
    while (count < total) {   /* put MaxBuf bytes into buff array */
        ptr=buff;
        address = prog[count].address;
        buftot=0;
        chk=0;
        for(last=address; ((buftot < MaxBuf) && (count < total)); ) {
            *ptr++ = prog[count].data[0];
            *ptr++ = prog[count].data[1];
            chk+= prog[count].data[0];
            chk+= prog[count].data[1];
            buftot+=2;
            ++count;
            ++last;
            if ((prog[count].address) != last)
                break;
        }
        // printf("Writing 0x%X - 0x%X (%d words)\n",address,last-1,buftot/2);
        // fflush(stdout);
  
                            /* send the buffer to the PIC */
        sendbyte(WRITE);
        sendbyte(address>>8);  /* send the start address */
        sendbyte(address);
        sendbyte(buftot);      /* send how many bytes to write */
        sendbyte(chk);         /* send check sum */
        for(loop=0; loop < buftot; ++loop)
            sendbyte(buff[loop]);     /* send the data */
        read_car(serial_fd,&ch,TIMEOUT_WRITING);
        if (ch != DATA_OK) {          /* data sent ok? */
            printf(" - data error [%X]\n",ch);
            exit(1);
        }
        read_car(serial_fd,&ch,TIMEOUT_WRITING);
        if (ch != WOK) {                  /* data written ok? */
            printf(" - bad write [%X]\n",ch);
            exit(1);
        }
        fflush(stdout);
    }
    printf(" - OK\n");
}


/***************************************************************/
/* Esperar hasta que se identifique el bootloader              */
/* Para ello se envia el caracter IDENT y se espera recibir    */
/* el caracter IDACK.                                          */
/***************************************************************/
void identificar_bootloader(void)
{  
  unsigned char inbyte;
  int status;
  char ident[]={IDENT};
  
  printf("Esperando conexion: ");
  fflush(stdout);

  do{
    //-- Enviar el caracter de identificacion
    sg_serial_enviar(serial_fd,ident,1);
    
    //-- Esperar la respuesta, con un timeout  
    status = read_car(serial_fd,&inbyte,TIMEOUT_IDENT);
    
    //-- Si hay timeout, se imprime un punto
    if (status==0) printf(".");
    else {
      //-- Si ha llegado un caracter diferente del esperado,
      //-- Imprimir una X
      if (inbyte!=IDACK) printf ("X");
    }    
    
    fflush(stdout);
    
    //-- Si el caracter recibido es distinto de IDACK o ha ocurrido un
    //-- timeout se repite el bucle    
  } while(inbyte != IDACK || status!=1);
  
  printf(" - OK\n");
}

/***************************/
/* Sacar la ayuda          */
/***************************/
static void help()
{
  printf ("Forma de uso:\n");
  printf ("PIC_downloader fichero.hex [-Pdispositivo_serie]\n");
  printf ("\n");
  printf ("Ejemplo: PIC_downloader ledp.hex -P/dev/ttyS0\n");
  printf ("\n");
}


/******************************/
/* Analizar los parametros    */
/******************************/
static void analizar_parametros(int argc, char ** argv)
{
  //-- Al menos debe haber un parametro
  if (argc<2) {
    printf ("Fichero .hex no especificado\n");
    help();
    exit(1);
  }
  
  //-- Leer nombre del fichero
  strcpy(fich,argv[1]);
  
  //-- El siguiente argumento, si lo hay, es el puerto serie
  if (argc>2) {
    strcpy(serial_name,&argv[2][2]);
  }
  else {
    strcpy(serial_name,DEF_PORT);
  }
}


/************************************/
/* Mostrar el mensaje inicial       */
/************************************/
void Mensaje_inicial(void) 
{
  printf ("PIC_downloader %s. Descarga de programas en la tarjeta Skypic\n",
           VERSION);
  printf ("Licencia GPL\n\n");
}


/***************/
/* MAIN        */
/***************/
int main(int argc, char ** argv)
{

  Mensaje_inicial();
  analizar_parametros(argc,argv);
  
  printf ("Fichero: %s\n",fich);
  printf ("Puerto serie: %s\n",serial_name);
  printf ("\n");

  //-- Abrir el puerto serie
  serial_fd = sg_serial_open(serial_name);
  if (serial_fd<0) {
    printf ("Error al abrir puerto serie\n");
    exit(1);
  }
  
  //-- Hacer reset de la skypic
  sc_signal_dtr_set(serial_fd,DTR_OFF);
  usleep(500000);
  sc_signal_dtr_set(serial_fd,DTR_ON);
  
  //-- Comenzar el protocolo de grabacion
  //-- 1) Identificar el bootloader
  identificar_bootloader();
  
  //-- 2) Leer el fichero .hex
  if (!LoadHex(fich))
		exit(1);
    
  //-- 3) Enviar los datos del fichero
  DownLoad();

  //-- 4) Terminar
  SendDone();
  

  //-- Cerrar el puerto serie  
  close(serial_fd);

  return 0;
}
