using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WiimoteLib;    // Indico libreria WiiMote

namespace Wii_PCBot
{
    public partial class Wii_PCBot : Form
    {

        private
            int tmpleds = 0;
            Wiimote wm;
            byte[] tx_buffer = new byte[1];
                   
        public Wii_PCBot()
        {
            InitializeComponent();

            // Permitimos llamadas cruzadas entre hilos
            CheckForIllegalCrossThreadCalls = false;

            // creamos el objeto WiiMote         
            wm = new Wiimote();    
            label1.Text="Stop";
        }

        private void Wii_PCBot_Load(object sender, EventArgs e)
        {
            // Aado los manejadores de los Callbacks de recepcin de informes
            wm.WiimoteChanged += new WiimoteLib.WiimoteChangedEventHandler(wm_WiimoteChanged);
            wm.WiimoteExtensionChanged += new WiimoteLib.WiimoteExtensionChangedEventHandler(wm_WiimoteExtensionChanged);


            try
            {
                serialPort1.Open();
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
                Application.Exit();
            }        
            
        }
        
        private void Wii_PCBot_FormClosing(object sender, FormClosingEventArgs e)
        {
            serialPort1.Close();
        }

        void wm_WiimoteExtensionChanged(object sender, WiimoteLib.WiimoteExtensionChangedEventArgs args)
        {
            // throw new Exception("The method or operation is not implemented.");
            
        }


        void wm_WiimoteChanged(object sender, WiimoteLib.WiimoteChangedEventArgs args)
        {
            progressBarX.Value = args.WiimoteState.AccelState.RawX;
            textBox1.Text = progressBarX.Value.ToString();
            progressBarY.Value = args.WiimoteState.AccelState.RawY;
            textBox2.Text = progressBarY.Value.ToString();
            progressBarZ.Value = args.WiimoteState.AccelState.RawZ;
            textBox3.Text = progressBarZ.Value.ToString();
           
            if (Analog.Checked)
            {
                if (progressBarX.Value <= 120)
                {
                    label1.Text = "Izquierda";
                    tx_buffer[0] = 0x6F;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
                else if (progressBarX.Value >= 150)
                {
                    label1.Text = "Derecha";
                    tx_buffer[0] = 0x70;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
                else if (progressBarY.Value <= 120)
                {
                    label1.Text = "Atras";
                    tx_buffer[0] = 0x61;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
                else if (progressBarY.Value >= 150)
                {
                    label1.Text = "Adelante";
                    tx_buffer[0] = 0x71;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
                else
                {
                    label1.Text = "Stop";
                    tx_buffer[0] = 0x20;
                    serialPort1.Write(tx_buffer, 0, 1);
                }

            }

            else
            {
                //throw new Exception("The method or operation is not implemented.");
                if (args.WiimoteState.ButtonState.Down)
                {
                    label1.Text = "Abajo";
                    tx_buffer[0] = 0x61;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
                else if (args.WiimoteState.ButtonState.Up)
                {
                    label1.Text = "Arriba";
                    tx_buffer[0] = 0x71;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
                else if (args.WiimoteState.ButtonState.Left)
                {
                    label1.Text = "Izquierda";
                    tx_buffer[0] = 0x6F;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
                else if (args.WiimoteState.ButtonState.Right)
                {
                    label1.Text = "Derecha";
                    tx_buffer[0] = 0x70;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
                else
                {
                    label1.Text = "Stop";
                    tx_buffer[0] = 0x20;
                    serialPort1.Write(tx_buffer, 0, 1);
                }
            }

            
        }

        /*-------------------------------------*/
        /*-    FUNCIONES DEL PROGRAMA         -*/
        /*-------------------------------------*/
        // Hace un efecto luminoso al activar el Joystick de la Wii
        private void timer1_Tick(object sender, EventArgs e)
        {
            wm.SetLEDs(tmpleds);
            tmpleds=(tmpleds*2)+1;
            if (tmpleds == 31)
            {
                tmpleds = 0;
            }       
        }

        // Detecta cuando hemos activado el Joystick de la Wii
        private void Joystick_CheckedChanged(object sender, EventArgs e)
        {
            if (Joystick.Checked)
            {
                try
                {
                    wm.Connect();
                  
                    // Lectura aceleraciones, botones, bateria e IR
                    wm.SetReportType(Wiimote.InputReport.IRAccel, true);
                }
                catch (Exception ee)
                {
                    MessageBox.Show(ee.Message);
                    Application.Exit();
                }               
                timer1.Start();
            }
            else
            {
                wm.SetLEDs(false, false, false, false);
                wm.Disconnect();
                timer1.Stop();
                            
            }
        }                     
    }
}