/*******************************************************/
/* Libreria SkyRGB                            Oct-2008 */
/*-----------------------------------------------------*/
/* Libreria para el control de la tarjeta SkyRGB       */
/*-----------------------------------------------------*/
/* Andres Prieto-Moreno                                */
/*******************************************************/

#ifndef _LIBRERIA_RGB
#define _LIBRERIA_RGB

//-- Especificar el pic a emplear
#include <pic16f876a.h>

//-- Direcciones dispositivos
#define RGB_W	0xA2     // Direccion del chip de la SKYRGB en escritura
#define RGB_R	0xA3     // Direccion del chip de la SKYRGB en lectura




void i2c_configure();


//******************************************
//* Funciones alto nivel SKYRGB            *
//******************************************

// Inicializa la placa
void RGB_init();

// Pone un color RGB en la placa
// red   - intensidad de rojo
// green - intensidad de verde
// blue  - intensidad de azul
// velocidad - velocidad de la transicion
void RGB(unsigned char red, unsigned char green, unsigned char blue, unsigned char velocidad);
	

// Enciende el cubo con color Azul
void Blue(unsigned char intensidad, unsigned char velocidad);

// Enciende el cubo en color rojo
void Red(unsigned char intensidad, unsigned char velocidad);

// Enciende el cubo en color verde
void Green(unsigned char intensidad, unsigned char velocidad);

// Hace un efecto de parpadeo
// Tipo = 0 Lo desactiva
// Tipo = 1 Activa latido Rojo
// Tipo = 2 Activa latido Verde
// Tipo = 3 Activa latido Azul
void Latido(unsigned char tipo, unsigned char min, unsigned char max, unsigned char velocidad);



#endif
