#include <mc68hc908gp32.h>


void sci_init(void) {
	SCBR = 0x22;   //-- 9600 Baudios
	SCC1 = 0x40;   //-- Habilitar SCI
	SCC2 = 0x0C;   //-- Habilitar Transmisor y receptor
}


unsigned char sci_leer_car(void){  
	//-- Esperar a que se ponga a '1' el Flag (Bit 5)
	while(!(SCS1 & 0x20));
 	return SCDR;
}


void sci_enviar_car(const char c){
	/* Esperar hasta que se pueda enviar algun caracter */
	/* Se tiene que activar el bit SCTE del registro SCS1 */
	while(!(SCS1 & 0x80));
	/* Enviar el caracter */
	SCDR = c;
}


void main(void){	
	unsigned char car;
	
	CONFIG1|=0x01;  //-- Deshabilitar el COP
	// Configuramos el puerto serie 
  sci_init();

	for (;;) {	
		// Esperamos a recibir un caracter
		car=sci_leer_car();
		// Lo enviamos por el puerto serie		
		sci_enviar_car(car);
	}
}
