using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Text;
using System.Windows.Forms;
using WiimoteLib;  // Hago la referencia a la librera que voy a usar

namespace wii_leds
{
    public partial class Wii_leds : Form
    {

        private 
            int tmpleds=0;
            Wiimote wm;

        public Wii_leds()
        {
            InitializeComponent();
            
            // Permitimos llamadas cruzadas entre hilos
            CheckForIllegalCrossThreadCalls = false;

            // creamos el objeto WiiMote         
            wm = new Wiimote();

        }

        private void Wii_leds_Load(object sender, EventArgs e)
        {
            try
            {
                wm.Connect();
            }
            catch (Exception ee)
            {
                MessageBox.Show(ee.Message);
                Application.Exit();     
            }

            wm.SetLEDs(false, false, false, false);
        }


        private void Wii_leds_FormClosing(object sender, FormClosingEventArgs e)
        {
            wm.SetLEDs(false, false, false, false);
            wm.Disconnect();
        }

        // Manejadores de los check boxes
        private void Led1_CheckedChanged(object sender, EventArgs e)
        {
            tmpleds = tmpleds ^ 0x01;
            wm.SetLEDs(tmpleds);
        }

        private void Led2_CheckedChanged(object sender, EventArgs e)
        {
            tmpleds = tmpleds ^ 0x02;
            wm.SetLEDs(tmpleds);
        }

        private void Led3_CheckedChanged(object sender, EventArgs e)
        {
            tmpleds = tmpleds ^ 0x04;
            wm.SetLEDs(tmpleds);
        }

        private void Led4_CheckedChanged(object sender, EventArgs e)
        {
            tmpleds = tmpleds ^ 0x08;
            wm.SetLEDs(tmpleds);
        }

    }
}