#!/usr/bin/env python
# -*- coding: UTF-8 -*-
# generated by wxGlade 0.4.1 on Mon Oct 20 18:21:17 2008

# Description: Testing the Skybot Robot
# Copyright (C) 2008 by Juan Gonzalez 
# Author: Juan Gonzalez <juan@iearobotics.com>

# This program is free software; you can redistribute it and/or
# modify it under the terms of the GNU Library General Public
# License as published by the Free Software Foundation; either
# version 2 of the License, or (at your option) any later version.

# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
# Library General Public License for more details.

# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.

import wx
import os
import sys

#-- Modulos de LibIris
import libIris.Pic16_Bootloader
import libIris.Pic16_Firmware
import libIris.IntelHex

#-- Modulos de Stargate
import libStargate.Generic
from libStargate.pic16f876 import *

#-- Estados para el interfaz
GUI_INICIAL    = 0
GUI_OK_SERIAL  = 1
GUI_OK_GENERIC = 2
GUI_PROGESS    = 3

#-- Timeout para la deteccion del bootloader (en segundos)
#-- Usado para la descarga del Monitor (servidor generico)
TIMEOUT = 800

#-- Timeout para la realizacion del PING a la Skypic. En mili-segundos
PING_TIMEOUT = 500

LOAD_TIMEOUT = 100

#-- Etiquetas para el movimiento del robot
SKYBOT_ADELANTE = 0x1C
SKYBOT_ATRAS    = 0X16
SKYBOT_STOP     = 0x00
SKYBOT_IZQUIERDA= 0x1E
SKYBOT_DERECHA  = 0x14


#-------------------------------------------------------------------
#-- Determinar el directorio desde donde se esta ejecutando pyburn
#-------------------------------------------------------------------
def determine_path ():
    """Borrowed from wxglade.py"""
    try:
        root = __file__
        if os.path.islink (root):
            root = os.path.realpath (root)
        return os.path.dirname (os.path.abspath (root))
    except:
        print "I'm sorry, but something is wrong."
        print "There is no __file__ variable. Please contact the author."
        sys.exit ()

#---------------------------------------------------
#-- Dialogo de About
#---------------------------------------------------
class MyDialog(wx.Dialog):
    def __init__(self, *args, **kwds):
        kwds["style"] = wx.DEFAULT_DIALOG_STYLE
        wx.Dialog.__init__(self, *args, **kwds)
        self.text_ctrl_1 = wx.TextCtrl(self, -1, "Skybot-test 1.0\nPruebas del robot Skybot\n http://www.iearobotics.com/wiki/index.php?title=Skybot-test\n\n(c) Juan Gonzalez, OCT-2008\nLICENCIA GPL\n\nLibrerias libIris y libStargate:\n(c) Rafael Trevino y Juan Gonzalez\n", style=wx.TE_MULTILINE|wx.TE_READONLY|wx.TE_RICH|wx.TE_AUTO_URL|wx.NO_BORDER)
        self.static_line_5 = wx.StaticLine(self, -1)
        self.button_1 = wx.Button(self, -1, "OK")

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.about_ok_clicked, self.button_1)

    def __set_properties(self):
        self.SetTitle("Sobre Skybot-test")
        self.text_ctrl_1.SetMinSize((400, 200))
        self.text_ctrl_1.SetBackgroundColour(wx.Colour(246, 244, 241))

    def __do_layout(self):
        sizer_13 = wx.BoxSizer(wx.VERTICAL)
        sizer_13.Add(self.text_ctrl_1, 0, wx.EXPAND, 0)
        sizer_13.Add(self.static_line_5, 0, wx.EXPAND, 0)
        sizer_13.Add(self.button_1, 0, wx.EXPAND|wx.ADJUST_MINSIZE, 0)
        self.SetAutoLayout(True)
        self.SetSizer(sizer_13)
        sizer_13.Fit(self)
        sizer_13.SetSizeHints(self)
        self.Layout()

    def about_ok_clicked(self, event): 
        #print "OK!"
        self.EndModal(0)


class MyFrame(wx.Frame):
  def __init__(self, app, *args, **kwds):
        # begin wxGlade: MyFrame.__init__
        kwds["style"] = wx.DEFAULT_FRAME_STYLE
        wx.Frame.__init__(self, *args, **kwds)
        self.panel_1 = wx.Panel(self, -1, style=wx.SIMPLE_BORDER|wx.TAB_TRAVERSAL)
        self.sizer_16_copy_staticbox = wx.StaticBox(self.panel_1, -1, "6")
        self.sizer_16_copy_1_staticbox = wx.StaticBox(self.panel_1, -1, "5")
        self.sizer_16_copy_2_staticbox = wx.StaticBox(self.panel_1, -1, "4")
        self.sizer_16_copy_3_staticbox = wx.StaticBox(self.panel_1, -1, "3")
        self.sizer_16_copy_4_staticbox = wx.StaticBox(self.panel_1, -1, "2")
        self.sizer_16_copy_5_staticbox = wx.StaticBox(self.panel_1, -1, "1")
        self.sizer_16_copy_6_staticbox = wx.StaticBox(self.panel_1, -1, "0")
        self.sizer_16_copy_2_copy_staticbox = wx.StaticBox(self.panel_1, -1, "5")
        self.sizer_16_copy_6_copy_staticbox = wx.StaticBox(self.panel_1, -1, "4")
        self.sizer_16_copy_6_copy_1_staticbox = wx.StaticBox(self.panel_1, -1, "3")
        self.sizer_16_copy_6_copy_2_staticbox = wx.StaticBox(self.panel_1, -1, "2")
        self.sizer_16_copy_6_copy_3_staticbox = wx.StaticBox(self.panel_1, -1, "1")
        self.sizer_16_copy_6_copy_4_staticbox = wx.StaticBox(self.panel_1, -1, "0")
        self.sizer_4_staticbox = wx.StaticBox(self.panel_1, -1, "E/S")
        self.sizer_8_staticbox = wx.StaticBox(self.panel_1, -1, "Puerto serie")
        self.sizer_9_staticbox = wx.StaticBox(self.panel_1, -1, "Conexion")
        self.sizer_6_staticbox = wx.StaticBox(self.panel_1, -1, "Entradas")
        self.sizer_7_staticbox = wx.StaticBox(self.panel_1, -1, "Controles")
        self.sizer_16_staticbox = wx.StaticBox(self.panel_1, -1, "7")
        
        # Menu Bar
        self.frame_1_menubar = wx.MenuBar()
        wxglade_tmp_menu = wx.Menu()
        self.frame_1_menubar.Append(wxglade_tmp_menu, "item")
        self.SetMenuBar(self.frame_1_menubar)
        # Menu Bar end
        self.statusbar = self.CreateStatusBar(1, 0)
        self.label_26 = wx.StaticText(self.panel_1, -1, "PUERTO B")
        self.label_puertob = wx.StaticText(self.panel_1, -1, "0x00")
        self.label_RB7 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4 = wx.StaticText(self.panel_1, -1, "S4")
        self.label_RB6 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy = wx.StaticText(self.panel_1, -1, "S3")
        self.label_RB5 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_1 = wx.StaticText(self.panel_1, -1, "S2")
        self.label_RB4 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_2 = wx.StaticText(self.panel_1, -1, "M2")
        self.label_RB3 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_3 = wx.StaticText(self.panel_1, -1, "M2")
        self.label_RB2 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_4 = wx.StaticText(self.panel_1, -1, "M1")
        self.label_RB1 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_5 = wx.StaticText(self.panel_1, -1, "M1")
        self.label_RB0 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_6 = wx.StaticText(self.panel_1, -1, "S1")
        self.static_line_1 = wx.StaticLine(self.panel_1, -1)
        self.label_nombre_puertoa = wx.StaticText(self.panel_1, -1, "PUERTO A")
        self.label_puertoa = wx.StaticText(self.panel_1, -1, "0x00")
        self.label_RA5 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_2_copy = wx.StaticText(self.panel_1, -1, "R")
        self.label_RA4 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_6_copy = wx.StaticText(self.panel_1, -1, "B4")
        self.label_RA3 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_6_copy_1 = wx.StaticText(self.panel_1, -1, "B3")
        self.label_RA2 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_6_copy_2 = wx.StaticText(self.panel_1, -1, "B2")
        self.label_RA1 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_6_copy_3 = wx.StaticText(self.panel_1, -1, "B1")
        self.label_RA0 = wx.StaticText(self.panel_1, -1, "X")
        self.label_S4_copy_6_copy_4 = wx.StaticText(self.panel_1, -1, "XX")
        self.entry_serial = wx.ComboBox(self.panel_1, -1, choices=[], style=wx.CB_DROPDOWN)
        self.button_abrir_cerrar = wx.Button(self.panel_1, -1, "  Abrir  ", style=wx.BU_EXACTFIT)
        self.icono_conexion = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.label_conexion = wx.StaticText(self.panel_1, -1, "SIN CONEXION")
        self.button_generic = wx.Button(self.panel_1, -1, "Descargar monitor", style=wx.BU_EXACTFIT)
        self.progressbar = wx.Gauge(self.panel_1, -1, 255)
        self.button_cancel = wx.Button(self.panel_1, wx.ID_CANCEL, "")
        self.label_IR = wx.StaticText(self.panel_1, -1, "Infrarrojos:")
        self.label_1 = wx.StaticText(self.panel_1, -1, "S4")
        self.icono_S4 = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.label_1_copy = wx.StaticText(self.panel_1, -1, "S3")
        self.icono_S3 = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.label_1_copy_1 = wx.StaticText(self.panel_1, -1, "S2")
        self.icono_S2 = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.label_1_copy_2 = wx.StaticText(self.panel_1, -1, "S1")
        self.icono_S1 = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.static_line_2 = wx.StaticLine(self.panel_1, -1)
        self.label_IR_copy = wx.StaticText(self.panel_1, -1, "Bumpers:")
        self.label_1_copy_3 = wx.StaticText(self.panel_1, -1, "B4")
        self.icono_B4 = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.label_1_copy_copy = wx.StaticText(self.panel_1, -1, "B3")
        self.icono_B3 = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.label_1_copy_1_copy = wx.StaticText(self.panel_1, -1, "B2")
        self.icono_B2 = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.label_B1 = wx.StaticText(self.panel_1, -1, "B1")
        self.icono_B1 = wx.StaticBitmap(self.panel_1, -1, wx.NullBitmap)
        self.static_line_3 = wx.StaticLine(self.panel_1, -1)
        self.label_2 = wx.StaticText(self.panel_1, -1, "LUZ:")
        self.label_luz = wx.StaticText(self.panel_1, -1, "XXXX")
        self.progress_luz = wx.Gauge(self.panel_1, -1, 255)
        self.label_5 = wx.StaticText(self.panel_1, -1, "")
        self.button_adelante = wx.Button(self.panel_1, -1, "Adelante")
        self.label_5_copy = wx.StaticText(self.panel_1, -1, "")
        self.button_izquierda = wx.Button(self.panel_1, -1, "Izquierda")
        self.button_stop = wx.Button(self.panel_1, -1, "Stop")
        self.button_derecha = wx.Button(self.panel_1, -1, "Derecha")
        self.button_rele = wx.Button(self.panel_1, -1, "Rele", style=wx.BU_EXACTFIT)
        self.button_atras = wx.Button(self.panel_1, -1, "Atras")
        self.button_led = wx.Button(self.panel_1, -1, "Led", style=wx.BU_EXACTFIT)
        self.static_line_4 = wx.StaticLine(self.panel_1, -1)
        self.label_3 = wx.StaticText(self.panel_1, -1, "Motores")
        self.label_4 = wx.StaticText(self.panel_1, -1, "Motor 1")
        self.button_M1_on = wx.Button(self.panel_1, -1, "ON/OFF", style=wx.BU_EXACTFIT)
        self.button_M1_dir = wx.Button(self.panel_1, -1, "Dir", style=wx.BU_EXACTFIT)
        self.label_4_copy = wx.StaticText(self.panel_1, -1, "Motor 2")
        self.button_M2_on = wx.Button(self.panel_1, -1, "ON/OFF", style=wx.BU_EXACTFIT)
        self.button_M2_dir = wx.Button(self.panel_1, -1, "Dir", style=wx.BU_EXACTFIT)

        self.__set_properties()
        self.__do_layout()

        self.Bind(wx.EVT_BUTTON, self.boton_abrir_cerrar_clicked, self.button_abrir_cerrar)
        self.Bind(wx.EVT_BUTTON, self.generic_clicked, self.button_generic)
        self.Bind(wx.EVT_BUTTON, self.button_cancel_clicked, self.button_cancel)
        self.Bind(wx.EVT_BUTTON, self.button_adelante_clicked, self.button_adelante)
        self.Bind(wx.EVT_BUTTON, self.button_izquierda_clicked, self.button_izquierda)
        self.Bind(wx.EVT_BUTTON, self.button_stop_clicked, self.button_stop)
        self.Bind(wx.EVT_BUTTON, self.button_derecha_clicked, self.button_derecha)
        self.Bind(wx.EVT_BUTTON, self.button_rele_clicked, self.button_rele)
        self.Bind(wx.EVT_BUTTON, self.button_atras_clicked, self.button_atras)
        self.Bind(wx.EVT_BUTTON, self.button_led_clicked, self.button_led)
        self.Bind(wx.EVT_BUTTON, self.button_M1_on_clicked, self.button_M1_on)
        self.Bind(wx.EVT_BUTTON, self.button_M1_dir_clicked, self.button_M1_dir)
        self.Bind(wx.EVT_BUTTON, self.button_M2_on_clicked, self.button_M2_on)
        self.Bind(wx.EVT_BUTTON, self.button_M2_dir_clicked, self.button_M2_dir)
        # end wxGlade
        
        #-- Guardar la aplicacion
        self.app=app;

  def __set_properties(self):
        # begin wxGlade: MyFrame.__set_properties
        self.SetTitle("Skybot-Test")
        self.statusbar.SetStatusWidths([-1])
        # statusbar fields
        statusbar_fields = ["frame_1_statusbar"]
        for i in range(len(statusbar_fields)):
            self.statusbar.SetStatusText(statusbar_fields[i], i)
        self.label_26.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_RB7.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RB7.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RB6.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RB6.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RB5.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RB5.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_1.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RB4.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RB4.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_2.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RB3.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RB3.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_3.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RB2.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RB2.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_4.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RB1.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RB1.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_5.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RB0.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RB0.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_6.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_nombre_puertoa.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_RA5.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RA5.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_2_copy.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_RA4.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RA4.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_6_copy.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RA3.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RA3.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_6_copy_1.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RA2.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RA2.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_6_copy_2.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RA1.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_RA1.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.BOLD, 0, ""))
        self.label_S4_copy_6_copy_3.SetForegroundColour(wx.Colour(0, 0, 255))
        self.entry_serial.SetMinSize((200, 23))
        self.icono_conexion.SetMinSize((35, 35))
        self.label_conexion.SetForegroundColour(wx.Colour(255, 0, 0))
        self.progressbar.SetMinSize((180, 20))
        self.label_IR.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, "Sans"))
        self.icono_S4.SetMinSize((35, 35))
        self.label_1_copy.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1_copy.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, "Sans"))
        self.icono_S3.SetMinSize((35, 35))
        self.label_1_copy_1.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1_copy_1.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, "Sans"))
        self.icono_S2.SetMinSize((35, 35))
        self.label_1_copy_2.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1_copy_2.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, "Sans"))
        self.icono_S1.SetMinSize((35, 35))
        self.label_IR_copy.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1_copy_3.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1_copy_3.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, "Sans"))
        self.icono_B4.SetMinSize((35, 35))
        self.label_1_copy_copy.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1_copy_copy.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, "Sans"))
        self.icono_B3.SetMinSize((35, 35))
        self.label_1_copy_1_copy.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_1_copy_1_copy.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, "Sans"))
        self.icono_B2.SetMinSize((35, 35))
        self.label_B1.SetForegroundColour(wx.Colour(0, 0, 255))
        self.label_B1.SetFont(wx.Font(9, wx.DEFAULT, wx.NORMAL, wx.NORMAL, 0, "Sans"))
        self.icono_B1.SetMinSize((35, 35))
        self.label_2.SetForegroundColour(wx.Colour(0, 0, 255))
        self.progress_luz.SetMinSize((170, 20))
        self.label_3.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_4.SetForegroundColour(wx.Colour(35, 142, 35))
        self.label_4_copy.SetForegroundColour(wx.Colour(35, 142, 35))
        # end wxGlade

  def __do_layout(self):
        # begin wxGlade: MyFrame.__do_layout
        sizer_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_2 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_5 = wx.BoxSizer(wx.VERTICAL)
        sizer_7 = wx.StaticBoxSizer(self.sizer_7_staticbox, wx.VERTICAL)
        sizer_22 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_23 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_24_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_25_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_24 = wx.BoxSizer(wx.VERTICAL)
        sizer_25 = wx.BoxSizer(wx.HORIZONTAL)
        grid_sizer_1 = wx.FlexGridSizer(3, 3, 0, 0)
        sizer_6 = wx.StaticBoxSizer(self.sizer_6_staticbox, wx.VERTICAL)
        sizer_21 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_18_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_19_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_20_copy_2_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_20_copy_1_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_20_copy_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_20_copy_3 = wx.BoxSizer(wx.VERTICAL)
        sizer_18 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_19 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_20_copy_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_20_copy_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_20_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_20 = wx.BoxSizer(wx.VERTICAL)
        sizer_3 = wx.BoxSizer(wx.VERTICAL)
        sizer_9 = wx.StaticBoxSizer(self.sizer_9_staticbox, wx.VERTICAL)
        sizer_11 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_10 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_8 = wx.StaticBoxSizer(self.sizer_8_staticbox, wx.HORIZONTAL)
        sizer_4 = wx.StaticBoxSizer(self.sizer_4_staticbox, wx.VERTICAL)
        sizer_12_copy = wx.BoxSizer(wx.HORIZONTAL)
        sizer_17 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_15_copy_6_copy_4 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_6_copy_4 = wx.StaticBoxSizer(self.sizer_16_copy_6_copy_4_staticbox, wx.HORIZONTAL)
        sizer_15_copy_6_copy_3 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_6_copy_3 = wx.StaticBoxSizer(self.sizer_16_copy_6_copy_3_staticbox, wx.HORIZONTAL)
        sizer_15_copy_6_copy_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_6_copy_2 = wx.StaticBoxSizer(self.sizer_16_copy_6_copy_2_staticbox, wx.HORIZONTAL)
        sizer_15_copy_6_copy_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_6_copy_1 = wx.StaticBoxSizer(self.sizer_16_copy_6_copy_1_staticbox, wx.HORIZONTAL)
        sizer_15_copy_6_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_6_copy = wx.StaticBoxSizer(self.sizer_16_copy_6_copy_staticbox, wx.HORIZONTAL)
        sizer_15_copy_2_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_2_copy = wx.StaticBoxSizer(self.sizer_16_copy_2_copy_staticbox, wx.HORIZONTAL)
        sizer_13_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_12 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_14 = wx.BoxSizer(wx.HORIZONTAL)
        sizer_15_copy_6 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_6 = wx.StaticBoxSizer(self.sizer_16_copy_6_staticbox, wx.HORIZONTAL)
        sizer_15_copy_5 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_5 = wx.StaticBoxSizer(self.sizer_16_copy_5_staticbox, wx.HORIZONTAL)
        sizer_15_copy_4 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_4 = wx.StaticBoxSizer(self.sizer_16_copy_4_staticbox, wx.HORIZONTAL)
        sizer_15_copy_3 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_3 = wx.StaticBoxSizer(self.sizer_16_copy_3_staticbox, wx.HORIZONTAL)
        sizer_15_copy_2 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_2 = wx.StaticBoxSizer(self.sizer_16_copy_2_staticbox, wx.HORIZONTAL)
        sizer_15_copy_1 = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy_1 = wx.StaticBoxSizer(self.sizer_16_copy_1_staticbox, wx.HORIZONTAL)
        sizer_15_copy = wx.BoxSizer(wx.VERTICAL)
        sizer_16_copy = wx.StaticBoxSizer(self.sizer_16_copy_staticbox, wx.HORIZONTAL)
        sizer_15 = wx.BoxSizer(wx.VERTICAL)
        sizer_16 = wx.StaticBoxSizer(self.sizer_16_staticbox, wx.HORIZONTAL)
        sizer_13 = wx.BoxSizer(wx.VERTICAL)
        sizer_13.Add(self.label_26, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_13.Add(self.label_puertob, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_12.Add(sizer_13, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL, 20)
        sizer_16.Add(self.label_RB7, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15.Add(sizer_16, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15.Add(self.label_S4, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_14.Add(sizer_15, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy.Add(self.label_RB6, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy.Add(sizer_16_copy, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy.Add(self.label_S4_copy, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_14.Add(sizer_15_copy, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_1.Add(self.label_RB5, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_1.Add(sizer_16_copy_1, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_1.Add(self.label_S4_copy_1, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_14.Add(sizer_15_copy_1, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_2.Add(self.label_RB4, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_2.Add(sizer_16_copy_2, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_2.Add(self.label_S4_copy_2, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_14.Add(sizer_15_copy_2, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_3.Add(self.label_RB3, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_3.Add(sizer_16_copy_3, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_3.Add(self.label_S4_copy_3, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_14.Add(sizer_15_copy_3, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_4.Add(self.label_RB2, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_4.Add(sizer_16_copy_4, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_4.Add(self.label_S4_copy_4, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_14.Add(sizer_15_copy_4, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_5.Add(self.label_RB1, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_5.Add(sizer_16_copy_5, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_5.Add(self.label_S4_copy_5, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_14.Add(sizer_15_copy_5, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_6.Add(self.label_RB0, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_6.Add(sizer_16_copy_6, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_6.Add(self.label_S4_copy_6, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_14.Add(sizer_15_copy_6, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_12.Add(sizer_14, 1, wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 0)
        sizer_4.Add(sizer_12, 0, wx.EXPAND, 0)
        sizer_4.Add(self.static_line_1, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 10)
        sizer_13_copy.Add(self.label_nombre_puertoa, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_13_copy.Add(self.label_puertoa, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_12_copy.Add(sizer_13_copy, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 20)
        sizer_16_copy_2_copy.Add(self.label_RA5, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_2_copy.Add(sizer_16_copy_2_copy, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_2_copy.Add(self.label_S4_copy_2_copy, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_17.Add(sizer_15_copy_2_copy, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_6_copy.Add(self.label_RA4, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_6_copy.Add(sizer_16_copy_6_copy, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_6_copy.Add(self.label_S4_copy_6_copy, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_17.Add(sizer_15_copy_6_copy, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_6_copy_1.Add(self.label_RA3, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_6_copy_1.Add(sizer_16_copy_6_copy_1, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_6_copy_1.Add(self.label_S4_copy_6_copy_1, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_17.Add(sizer_15_copy_6_copy_1, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_6_copy_2.Add(self.label_RA2, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_6_copy_2.Add(sizer_16_copy_6_copy_2, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_6_copy_2.Add(self.label_S4_copy_6_copy_2, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_17.Add(sizer_15_copy_6_copy_2, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_6_copy_3.Add(self.label_RA1, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_6_copy_3.Add(sizer_16_copy_6_copy_3, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_6_copy_3.Add(self.label_S4_copy_6_copy_3, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_17.Add(sizer_15_copy_6_copy_3, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_16_copy_6_copy_4.Add(self.label_RA0, 0, wx.ADJUST_MINSIZE, 0)
        sizer_15_copy_6_copy_4.Add(sizer_16_copy_6_copy_4, 1, wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_15_copy_6_copy_4.Add(self.label_S4_copy_6_copy_4, 0, wx.TOP|wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 5)
        sizer_17.Add(sizer_15_copy_6_copy_4, 0, wx.RIGHT|wx.EXPAND|wx.ALIGN_CENTER_HORIZONTAL, 5)
        sizer_12_copy.Add(sizer_17, 1, wx.EXPAND, 0)
        sizer_4.Add(sizer_12_copy, 0, wx.EXPAND, 0)
        sizer_3.Add(sizer_4, 0, wx.EXPAND, 0)
        sizer_8.Add(self.entry_serial, 0, wx.LEFT|wx.TOP|wx.BOTTOM|wx.EXPAND|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_8.Add(self.button_abrir_cerrar, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_3.Add(sizer_8, 0, wx.TOP|wx.EXPAND, 5)
        sizer_10.Add(self.icono_conexion, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_10.Add(self.label_conexion, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 10)
        sizer_10.Add(self.button_generic, 0, wx.LEFT|wx.RIGHT|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_9.Add(sizer_10, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 5)
        sizer_11.Add(self.progressbar, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_11.Add(self.button_cancel, 0, wx.LEFT|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL, 5)
        sizer_9.Add(sizer_11, 0, wx.ALL, 5)
        sizer_3.Add(sizer_9, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 5)
        sizer_2.Add(sizer_3, 0, wx.LEFT|wx.EXPAND, 5)
        sizer_18.Add(self.label_IR, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_20.Add(self.label_1, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_20.Add(self.icono_S4, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_19.Add(sizer_20, 1, wx.LEFT|wx.EXPAND, 5)
        sizer_20_copy.Add(self.label_1_copy, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_20_copy.Add(self.icono_S3, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_19.Add(sizer_20_copy, 1, wx.LEFT|wx.EXPAND, 5)
        sizer_20_copy_1.Add(self.label_1_copy_1, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_20_copy_1.Add(self.icono_S2, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_19.Add(sizer_20_copy_1, 1, wx.LEFT|wx.EXPAND, 5)
        sizer_20_copy_2.Add(self.label_1_copy_2, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_20_copy_2.Add(self.icono_S1, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_19.Add(sizer_20_copy_2, 1, wx.LEFT|wx.EXPAND, 5)
        sizer_18.Add(sizer_19, 1, wx.EXPAND, 0)
        sizer_6.Add(sizer_18, 0, wx.EXPAND, 0)
        sizer_6.Add(self.static_line_2, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 5)
        sizer_18_copy.Add(self.label_IR_copy, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_20_copy_3.Add(self.label_1_copy_3, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_20_copy_3.Add(self.icono_B4, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_19_copy.Add(sizer_20_copy_3, 1, wx.LEFT|wx.EXPAND, 5)
        sizer_20_copy_copy.Add(self.label_1_copy_copy, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_20_copy_copy.Add(self.icono_B3, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_19_copy.Add(sizer_20_copy_copy, 1, wx.LEFT|wx.EXPAND, 5)
        sizer_20_copy_1_copy.Add(self.label_1_copy_1_copy, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_20_copy_1_copy.Add(self.icono_B2, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_19_copy.Add(sizer_20_copy_1_copy, 1, wx.LEFT|wx.EXPAND, 5)
        sizer_20_copy_2_copy.Add(self.label_B1, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_20_copy_2_copy.Add(self.icono_B1, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_19_copy.Add(sizer_20_copy_2_copy, 1, wx.LEFT|wx.EXPAND, 5)
        sizer_18_copy.Add(sizer_19_copy, 1, wx.EXPAND, 0)
        sizer_6.Add(sizer_18_copy, 0, wx.EXPAND, 0)
        sizer_6.Add(self.static_line_3, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 5)
        sizer_21.Add(self.label_2, 0, wx.RIGHT|wx.ALIGN_RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_21.Add(self.label_luz, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_21.Add(self.progress_luz, 0, wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 0)
        sizer_6.Add(sizer_21, 0, wx.EXPAND, 0)
        sizer_5.Add(sizer_6, 0, wx.EXPAND, 0)
        grid_sizer_1.Add(self.label_5, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.button_adelante, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.label_5_copy, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.button_izquierda, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.button_stop, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.button_derecha, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.button_rele, 0, wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.button_atras, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        grid_sizer_1.Add(self.button_led, 0, wx.ALIGN_RIGHT|wx.ADJUST_MINSIZE, 0)
        sizer_7.Add(grid_sizer_1, 1, wx.ALIGN_CENTER_HORIZONTAL, 0)
        sizer_7.Add(self.static_line_4, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 5)
        sizer_22.Add(self.label_3, 0, wx.RIGHT|wx.ALIGN_CENTER_VERTICAL|wx.ADJUST_MINSIZE, 5)
        sizer_24.Add(self.label_4, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_25.Add(self.button_M1_on, 0, wx.ADJUST_MINSIZE, 0)
        sizer_25.Add(self.button_M1_dir, 0, wx.ADJUST_MINSIZE, 0)
        sizer_24.Add(sizer_25, 1, wx.EXPAND, 0)
        sizer_23.Add(sizer_24, 1, wx.EXPAND, 0)
        sizer_24_copy.Add(self.label_4_copy, 0, wx.ALIGN_CENTER_HORIZONTAL|wx.ADJUST_MINSIZE, 0)
        sizer_25_copy.Add(self.button_M2_on, 0, wx.ADJUST_MINSIZE, 0)
        sizer_25_copy.Add(self.button_M2_dir, 0, wx.ADJUST_MINSIZE, 0)
        sizer_24_copy.Add(sizer_25_copy, 1, wx.EXPAND, 0)
        sizer_23.Add(sizer_24_copy, 1, wx.EXPAND, 0)
        sizer_22.Add(sizer_23, 1, wx.EXPAND, 0)
        sizer_7.Add(sizer_22, 0, wx.EXPAND, 0)
        sizer_5.Add(sizer_7, 0, wx.TOP|wx.BOTTOM|wx.EXPAND, 5)
        sizer_2.Add(sizer_5, 0, wx.LEFT|wx.RIGHT|wx.EXPAND, 5)
        self.panel_1.SetSizer(sizer_2)
        sizer_1.Add(self.panel_1, 0, 0, 0)
        self.SetSizer(sizer_1)
        sizer_1.Fit(self)
        self.Layout()
        self.Centre()
        # end wxGlade
        
        #--------------------------------------------
        # Fin del codigo generado automaticamente
        #--------------------------------------------
        
        #-- Capturar los eventos del teclado
        self.Bind(wx.EVT_CHAR, self.Tecla_pulsada);
        
        #-------------------------------------------
        #- Encontrar la ruta a los iconos .xpm
        #-------------------------------------------
        PIXMAP_name=os.sep+"pixmaps";
        EXEC_dir = determine_path()
        IMAGE_ON_DIR = EXEC_dir  + PIXMAP_name + os.sep + "on.xpm"
        IMAGE_OFF_DIR= EXEC_dir  + PIXMAP_name + os.sep + "off.xpm"
        
        IMAGE_UNKNOW_DIR = EXEC_dir  + PIXMAP_name + os.sep + "unknow.png"
        IMAGE_NEGRO_DIR  = EXEC_dir  + PIXMAP_name + os.sep + "negro.png"
        IMAGE_BLANCO_DIR = EXEC_dir  + PIXMAP_name + os.sep + "blanco.png"
        IMAGE_NEGRO_DIR  = EXEC_dir  + PIXMAP_name + os.sep + "negro.png"
        IMAGE_OPEN_DIR   = EXEC_dir  + PIXMAP_name + os.sep + "open.png"
        IMAGE_CLOSE_DIR  = EXEC_dir  + PIXMAP_name + os.sep + "close.png"
      
        #-- Debug: imprimir los directorios donde buscar los iconos
        #print IMAGE_ON_DIR
        #print IMAGE_OFF_DIR
        
        #---------------------------------------
        #-- Variables globales
        #---------------------------------------
        #-- Ultimos valores leidos de los puertos B y A
        self.puertob=0x00;
        self.puertoa=0x00;
        
        
        #-- Stargate para la comunicacion con el skybot
        self.generic=None;
        
        #-- Estado en el que se encuentra la GUI
        self.estado_GUI=None
      
        #--  Crear el temporizador para ping
        self.timer = wx.Timer(self, 999999)
        self.Bind(wx.EVT_TIMER, self.skypic_check)
        
        #-- Cargar las imagenes del estado de la conexion
        self.imagen_on = wx.Bitmap(IMAGE_ON_DIR, wx.BITMAP_TYPE_XPM)
        self.imagen_off = wx.Bitmap(IMAGE_OFF_DIR, wx.BITMAP_TYPE_XPM)
        self.imagen_unknow = wx.Bitmap(IMAGE_UNKNOW_DIR, wx.BITMAP_TYPE_PNG)
        self.imagen_negro = wx.Bitmap(IMAGE_NEGRO_DIR, wx.BITMAP_TYPE_PNG)
        self.imagen_blanco = wx.Bitmap(IMAGE_BLANCO_DIR, wx.BITMAP_TYPE_PNG)
        self.imagen_open = wx.Bitmap(IMAGE_OPEN_DIR, wx.BITMAP_TYPE_PNG)
        self.imagen_close = wx.Bitmap(IMAGE_CLOSE_DIR, wx.BITMAP_TYPE_PNG)
        
        #-- Flag de cancelar
        self.cancelar=False
        
        #-- Otros
        self.interfaz_estado(GUI_INICIAL);
        

  #---------------------------------------------------
  #- Funcion invocada cada vez que se pulsa una tecla
  #----------------------------------------------------
  def Tecla_pulsada(self,event):
  
    #-- Solo se tienen en cuenta en el estado GUI_OK_GENERIC
    if self.estado_GUI==GUI_OK_GENERIC:
      
      #-- Leer la tecla
      tecla=event.GetKeyCode()
      if tecla==ord('q'):
        self.button_adelante_clicked(wx.EVT_BUTTON)
      elif tecla==ord(' '):
        self.button_stop_clicked(wx.EVT_BUTTON)
      elif tecla==ord('a'):
        self.button_atras_clicked(wx.EVT_BUTTON)
      elif tecla==ord('o'):
        self.button_izquierda_clicked(wx.EVT_BUTTON)
      elif tecla==ord('p'):
        self.button_derecha_clicked(wx.EVT_BUTTON)
      elif tecla==ord('r'):
        self.generic[PORTA]=self.puertoa ^ 0x20
      elif tecla==ord('l') or tecla==ord('1'):
        self.generic[PORTB]=self.puertob ^ 0x02
      elif tecla==ord('2'):
        self.generic[PORTB]=self.puertob ^ 0x04
      elif tecla==ord('3'):
        self.generic[PORTB]=self.puertob ^ 0x08
      elif tecla==ord('4'):
        self.generic[PORTB]=self.puertob ^ 0x10
      else:
        event.Skip()
    else:
      event.Skip()
      
      
  #-----------------------------------
  #-- Conversion de entero a binario
  #-----------------------------------
  def int2bin(self, n, count=24):
    return "".join([str((n >> y) & 1) for y in range(count-1, -1, -1)])

  #---------------------------------------------------------
  #-- Comprobacion periodica de la conexion con la Skypic  
  #-- La invoca el temporizador
  #---------------------------------------------------------
  def skypic_check(self,event):
    
    #--- Modificar:
    #--- En el estado OK_serial se hace ping normal
    #--- En el estado OK_GENERIC se leen los datos del skybot
    
    if self.generic:
    
      #-------------------------------------------------------
      #-- Estado OK_SERIAL: se comprueba mediante pings e IDS
      #-------------------------------------------------------
      if self.estado_GUI==GUI_OK_SERIAL:
      
        #-- Comprobar si hay conexion con el servidor y si
        #-- es del tipo correcto
      
        es_generic = self.generic.check_server_type()
      
        #--DEBUG: Para ver en la consola si esta activado o no
        print "GENERIC: %s" % es_generic
      
        #-- Actualizar el interfaz en funcion de que se haya detectado o no
        if es_generic:
        
          #--- Configurar SKYBOT
          self.generic[TRISB]=0xE1;
          self.generic[TRISA]=0xDF;
          self.generic[ADCON1]=0x0E;
          self.generic[ADCON0]=0x01
          self.generic[PORTB]=0x00;
          
          self.interfaz_estado(GUI_OK_GENERIC)
        else:
          self.interfaz_estado(GUI_OK_SERIAL)
         
      #----------------------------------------------
      #-- Estado OK_GENERIC: Se leen datos del skybot. Si no se reciben
      #-- se pasa al estado OK_SERIAL
      #------------------------------------------------      
      elif self.estado_GUI==GUI_OK_GENERIC:    

        #-- Si salta una excepcion, pasar a OK_SERIAL
        try:
          self.puertob = self.generic[PORTB];
          self.puertoa = self.generic[PORTA];
          self.generic[ADCON0]=0x05
          luz = self.generic[ADRESH]
        except libStargate.Generic.Error:
          self.interfaz_estado(GUI_OK_SERIAL)
          return

        print "Puerto B: %0X, Puerto A: %0X" % (self.puertob,self.puertoa)
        print "Luz: %0X" % luz
        
        puertob_bin=self.int2bin(self.puertob,8)
        puertoa_bin=self.int2bin(self.puertoa,8)
        
        #--- Actualizar interfaz grafica
        
        #-- Mostrar valor en hexadecimal de los puertos A y B
        self.label_puertob.SetLabel("0x%0X" % self.puertob)
        self.label_puertoa.SetLabel("0x%0X" % self.puertoa)
        
        #-- Mostrar el valor en binario
        self.label_RB7.SetLabel(puertob_bin[0])
        self.label_RB6.SetLabel(puertob_bin[1])
        self.label_RB5.SetLabel(puertob_bin[2])
        self.label_RB0.SetLabel(puertob_bin[7])
        
        self.label_RB4.SetLabel(puertob_bin[3])
        self.label_RB3.SetLabel(puertob_bin[4])
        self.label_RB2.SetLabel(puertob_bin[5])
        self.label_RB1.SetLabel(puertob_bin[6])
        
        self.label_RA5.SetLabel(puertoa_bin[2])
        self.label_RA4.SetLabel(puertoa_bin[3])
        self.label_RA3.SetLabel(puertoa_bin[4])
        self.label_RA2.SetLabel(puertoa_bin[5])
        self.label_RA1.SetLabel(puertoa_bin[6])
        self.label_RA0.SetLabel(puertoa_bin[7])
        
        #-- Mostrar el valor de la luz
        self.progress_luz.SetValue(luz)
        self.label_luz.SetLabel("0x%0X" % luz)
        
        #-- Modificar iconos
        if puertob_bin[0]=='1':
          self.icono_S4.SetBitmap(self.imagen_negro)
        else:
          self.icono_S4.SetBitmap(self.imagen_blanco)
        
        if puertob_bin[1]=='1':
          self.icono_S3.SetBitmap(self.imagen_negro)
        else:
          self.icono_S3.SetBitmap(self.imagen_blanco)
          
        if puertob_bin[2]=='1':
          self.icono_S2.SetBitmap(self.imagen_negro)
        else:
          self.icono_S2.SetBitmap(self.imagen_blanco)
        
        if puertob_bin[7]=='1':
          self.icono_S1.SetBitmap(self.imagen_negro)
        else:
          self.icono_S1.SetBitmap(self.imagen_blanco)
          
        if puertoa_bin[6]=='1':
          self.icono_B1.SetBitmap(self.imagen_close)
        else:
          self.icono_B1.SetBitmap(self.imagen_open)
          
        if puertoa_bin[5]=='1':
          self.icono_B2.SetBitmap(self.imagen_close)
        else:
          self.icono_B2.SetBitmap(self.imagen_open) 

        if puertoa_bin[4]=='1':
          self.icono_B3.SetBitmap(self.imagen_close)
        else:
          self.icono_B3.SetBitmap(self.imagen_open)
          
        if puertoa_bin[3]=='1':
          self.icono_B4.SetBitmap(self.imagen_close)
        else:
          self.icono_B4.SetBitmap(self.imagen_open)  
          

#-----------------------------------------------------------------------#
#                                                                       #
#     FUNCIONES DE RETROLLAMADA DE LOS ELEMENTOS DEL INTERFAZ           #
#                                                                       #
#-----------------------------------------------------------------------#

  #--------------------------------------------
  #- Boton de Abrir/Cerrar el puerto serie
  #--------------------------------------------
  def boton_abrir_cerrar_clicked(self, event):  # wxGlade: MyFrame.<event_handler>
    
    #-- Su funcionamiento depende del estado en el que esta el interfaz
    
    if self.estado_GUI==GUI_INICIAL:
      #-- En estado inicial la accion del boton es ABRIR
      self.open_port()
      
    else:
      #-- En el resto de estados la accion es CERRAR
      
      #-- Cerrarlo! 
      if self.generic:
        self.generic.close()
        
      #-- Actualizar interfaz
      self.interfaz_estado(GUI_INICIAL);

      #-- Actualizar barra de estado
      self.statusbar.SetStatusText("Puerto serie CERRADO",0);

  #-----------------------------
  #-- Grabar el PICP
  #-----------------------------
  def generic_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    print "Download generic"
    self.download_program(libIris.Pic16_Firmware.generic) 
    
  #------------------------
  #-- Boton de cancelacion
  #------------------------ 
  def button_cancel_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    #-- Poner el flag de cancelar a True y deshabilitar el boton
    self.cancelar=True
    self.button_cancel.Disable()


  #--------------
  #- ADELANTE   
  #--------------
  def button_adelante_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=SKYBOT_ADELANTE;
    
  def button_stop_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=SKYBOT_STOP
    
  def button_izquierda_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=SKYBOT_IZQUIERDA

  def button_derecha_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=SKYBOT_DERECHA
    
  def button_atras_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=SKYBOT_ATRAS
    

  def button_rele_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTA]=self.puertoa ^  0x20;

  def button_led_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=self.puertob ^ 0x02
    
  def button_M1_on_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=self.puertob ^ 0x04

  def button_M1_dir_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=self.puertob ^ 0x02 
    
  def button_M2_on_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=self.puertob ^ 0x010 
    

  def button_M2_dir_clicked(self, event): # wxGlade: MyFrame.<event_handler>
    self.generic[PORTB]=self.puertob ^ 0x08
        
        
  #---------------------------------------
  #-- Menu de About
  #----------------------------------------  
  def EVT_MENU(self, event): # wxGlade: MyFrame.<event_handler>
     d=MyDialog(None,-1)
     d.ShowModal()
     d.Destroy()      

#-----------------------------------------------------------------------#
#                                                                       #
#     FUNCIONES PARA IMPLEMENTAR LAS ACCIONES                           #
#                                                                       #
#-----------------------------------------------------------------------#
  
  #------------------------------------------------------------
  #-- Abrir el puerto serie leyendo el dispositivo del entry
  #-- DEVUELVE:
  #--   -True: Ok
  #--   -False: Error al abrir el puerto serie
  #------------------------------------------------------------
  def open_port(self):
    #-- Primero obtener el nombre del dispositivo serie
    serialName=self.entry_serial.GetValue()
    
    #-- Si habia un "Stargate" abierto, cerrarlo primero
    if self.generic:
      self.generic.close()
    
    #-- Abrir el puerto y crear el stargate
    try:
      self.generic = libStargate.Generic.Open(serialName, logCallback=None)
      self.statusbar.SetStatusText("OK. Puerto serie Abierto",0);
      
      #-- Cambiar el estado de la GUI
      self.interfaz_estado(GUI_OK_SERIAL);
      return True
      
    except libStargate.Main.Error, msg:
      self.generic = None
      
      #-- Si hay error indicarlo en la barra de estado y abortar
      self.statusbar.SetStatusText("%s" % msg, 0)
      
      #-- Cambiar estado del interfaz
      self.interfaz_estado(GUI_INICIAL);
      return False  

#----------------------------------------------------------------------------#
#                                                                            #
#   METODOS PARA LA DESCARGA DEL FIRMWARE GENERIC. INTERFAZ CON LA LIBIRIS   #
#                                                                            #
#----------------------------------------------------------------------------#
  

  #--------------------------------------------------------------
  #- Metodo principal para descargar un programa en la skypic
  #--------------------------------------------------------------
  def download_program(self,prog):
    #-- Poner la barra de progreso a 0
    self.progressbar.SetValue(0)
    self.update()
    
    #-- Desactivar flag de cancelacion
    self.cancelar=False
    
    #--------------------------------------------------------------------
    #-- Crear un objeto IRIS para la descarga de firmware. Se asocia
    #-- al puerto serie abierto
    #--------------------------------------------------------------------
    
    #-- Primero obtener el nombre del dispositivo serie
    serialName=self.entry_serial.GetValue()
    
    #-- NOTA para Windows: Hay que cerrar el puerto serie, ya que sino
    #-- al llamar al IRIS dara un error. En windows si un puerto serie ya
    #-- esta abierto, no se puede abrir ningun otro (ni siquiera el mismo)
    if self.generic:
      self.generic.close()
    
    try:
      self.iris = libIris.Pic16_Bootloader.Iris(serialName,logCallback=None)
    except libIris.Pic16_Bootloader.IrisError,msg:
    
      #-- Si hay error indicarlo en la barra de estado y abortar
      self.statusbar.SetStatusText("%s" % msg,0);
      return
    
    #-- Hay que esperar a que detecte el Bootloader
    self.statusbar.SetStatusText("Pulse Reset en la skypic",0);
    
    #-- Pasar al interfaz de "PROGRESO"
    self.interfaz_estado(GUI_PROGESS)
    self.update();
    
    #-- DESCARGAR EL FIRMWARE PICP!!!
    try:
      self.iris.download(prog,stateCallback=self.state)
    except libIris.Pic16_Bootloader.IrisError,msg:
      
      #-- NOTA para Windows: Idem. Es necesario cerrar el puerto serie
      self.iris.close()
      
      #-- Re-abrir el puerto serie
      self.open_port()
      self.statusbar.SetStatusText("%s" % msg,0);
      return
      
    #-- NOTA para Windows: Idem. Es necesario cerrar el puerto serie
    self.iris.close()    
      
    #-- SERVIDOR PICP cargado
    #-- Re-abrir el puerto serie
    self.open_port()
    
    self.statusbar.SetStatusText("Descarga completada",0);


  #------------------------------------------------------------------------
  #-- Funcion de retrollamada de libIris. Segun el estado de la descarga
  #-- Se hace una cosa u otra
  #------------------------------------------------------------------------  
  def state(self,op,inc,total):
    
    #-----------------------------
    #-- Comienzo de descarga
    #-----------------------------
    if op==libIris.Pic16_Bootloader.WRITING_START:

      #-- Barra de progreso a cero
      self.progressbar.SetValue(0)

      #-- Actualizar barra de status
      self.statusbar.SetStatusText("Descargando firmware...",0);
      self.update()      
      return True
      
    #------------------------------
    #-- Incremento en la descarga  
    #------------------------------    
    elif op==libIris.Pic16_Bootloader.WRITING_INC:  
      self.progressbar.SetValue(100*inc/total)      
      self.update()
      
      #-- Comprobar si se ha apretado boton de Cancelar
      if self.cancelar:
        return False
        
      return True

    #-------------------------------
    #-- Fin de la descarga
    #-------------------------------
    elif op==libIris.Pic16_Bootloader.WRITING_END: 
      self.progressbar.SetValue(100)
      self.statusbar.SetStatusText("Completado",0);
      self.update()
      return True
      
    #---------------------------------------------------
    #-- Comienzo de la identificacion del bootloader    
    #---------------------------------------------------    
    elif op==libIris.Pic16_Bootloader.IDENT_START:
      #-- Hay que esperar a que detecte el Bootloader
      self.statusbar.SetStatusText("Pulse Reset en la skypic", 0)
      self.update()
      return True
      
      
    #-----------------------------------------------------------------
    #-- Respuesta no recibida del bootloader tras un mini-timeout    
    #-----------------------------------------------------------------
    elif op==libIris.Pic16_Bootloader.IDENT_NACK:
    
      #-- Mientras que el tiempo total acumulado sea menor que el 
      #-- TIMEOUT indicado, continuar esperando
      self.update()
      
      #-- Si apretado boton de cancelar abortar...
      if self.cancelar:
        return False
      
      if total<=TIMEOUT:
       return True
      else :
        return False      


#-----------------------------------------------------------------------------#
#                                                                             #
#              FUNCIONES DE GESTION DEL INTERFAZ                              #
#                                                                             #
#-----------------------------------------------------------------------------#
  
  #------------------------------------------------
  #-- Procesar eventos pendientes del interfaz 
  #------------------------------------------------
  def update(self):
    while (self.app.Pending()):
        self.app.Dispatch();  
  
  #------------------------------------------------------------------------#
  #-- Establecer estado interfaz. Esta funcion determina que partes del   
  #-- interfaz estan activas en cada momento, segun la situacion
  #--
  #-- ESTADO DEL INTERFAZ
  #--
  #--   INICIAL:   Comienzo del programa. Puerto serie NO abierto
  #--   OK_SERIAL: Puerto serie abierto correctamente
  #--   OK_GENERIC: Servidor Generico detectado
  #--   PROGRESS:   Barra de progreso actualizandose
  #-----------------------------------------------------------------------#
  def interfaz_estado(self,state,force=False):
    
    #-- Por razones de eficiencia, el interfaz solo se actualiza si
    #-- el nuevo estado es diferente del actual.
    #-- Si el Flag force esta activado se actualiza el interfaz sin
    #-- tener en cuenta esto
    if self.estado_GUI==state and force==False:
      return;
    
    #-- Cambiar al estado indicado
    self.estado_GUI=state;
    
    #-----------------------------
    #-- ESTADO INICIAL
    #-----------------------------
    if state==GUI_INICIAL:
      
      #-- Debug
      print "GUI Estado: INICIAL"
      
      #--- Activar combo del puerto serie
      self.entry_serial.Enable();
      
      #-- El boton de Abrir es de Abrir
      self.button_abrir_cerrar.SetLabel("  Abrir  ")
      
      self.button_abrir_cerrar.Enable()
      
      #-- STARGATE
      self.button_generic.Disable()
      
      #-- Skybot
      self.button_adelante.Disable()
      self.button_atras.Disable()
      self.button_derecha.Disable()
      self.button_izquierda.Disable()
      self.button_stop.Disable()
      self.button_rele.Disable()
      self.button_led.Disable()
      
      self.button_M1_on.Disable()
      self.button_M1_dir.Disable()
      self.button_M2_on.Disable()
      self.button_M2_dir.Disable()
      
      #-- OTROS
      self.button_cancel.Disable()
      
      #-- El temporizador en este estado debe estar parado
      if self.timer.IsRunning():
        self.timer.Stop()
        
      #-- no Hay conexion con Monitor
      self.label_conexion.SetLabel("SIN CONEXION")
      self.icono_conexion.SetBitmap(self.imagen_off)
      self.label_conexion.SetForegroundColour(wx.Colour(255, 0, 0))
      
      #-- Modificar iconos
      self.icono_S4.SetBitmap(self.imagen_unknow)  
      self.icono_S3.SetBitmap(self.imagen_unknow)  
      self.icono_S2.SetBitmap(self.imagen_unknow)  
      self.icono_S1.SetBitmap(self.imagen_unknow)  
      self.icono_B2.SetBitmap(self.imagen_unknow)  
      self.icono_B1.SetBitmap(self.imagen_unknow)
      self.icono_B3.SetBitmap(self.imagen_unknow)  
      self.icono_B4.SetBitmap(self.imagen_unknow)
      
      #-- Mostrar valor en hexadecimal de los puertos A y B
      self.label_puertob.SetLabel("XX")
      self.label_puertoa.SetLabel("XX")
      self.progress_luz.SetValue(0)
      self.label_luz.SetLabel("XXXX")
      
      #-- Valores de los bits a X
      self.label_RB7.SetLabel('X')
      self.label_RB6.SetLabel('X')
      self.label_RB5.SetLabel('X')
      self.label_RB0.SetLabel('X')
      
      self.label_RB4.SetLabel('X')
      self.label_RB3.SetLabel('X')
      self.label_RB2.SetLabel('X')
      self.label_RB1.SetLabel('X')
        
      self.label_RA5.SetLabel('X')
      self.label_RA4.SetLabel('X')
      self.label_RA3.SetLabel('X')
      self.label_RA2.SetLabel('X')
      self.label_RA1.SetLabel('X')
      self.label_RA0.SetLabel('X')
      
      self.statusbar.SetStatusText("Seleccionar puerto serie y pulsar en ABRIR",0);

    #----------------------------
    #-- ESTADO OK_SERIAL
    #----------------------------    
    elif state==GUI_OK_SERIAL:
    
      #-- Debug
      print "GUI Estado: GUI_OK_SERIAL"
      
      #-- Desactivar combo del puerto serie
      self.entry_serial.Disable();
      
      #-- El boton de Abrir es ahora de Cerrar
      self.button_abrir_cerrar.SetLabel("Cerrar")
      self.button_abrir_cerrar.Enable()
      
      #-- Se permite descargar el servidor generico
      self.button_generic.Enable()
      
      #-- OTROS
      self.button_cancel.Disable()
      
      #-- Skybot
      self.button_adelante.Disable()
      self.button_atras.Disable()
      self.button_derecha.Disable()
      self.button_izquierda.Disable()
      self.button_stop.Disable()
      self.button_rele.Disable()
      self.button_led.Disable()
      self.button_M1_on.Disable()
      self.button_M1_dir.Disable()
      self.button_M2_on.Disable()
      self.button_M2_dir.Disable()
      
      #-- El temporizador se Activa, para comprobar la conexion con 
      #-- la Skypic
      self.timer.Start(PING_TIMEOUT,wx.TIMER_CONTINUOUS)
      
      #-- no Hay conexion con monitor
      self.label_conexion.SetLabel("SIN CONEXION\n")
      self.icono_conexion.SetBitmap(self.imagen_off)
      self.label_conexion.SetForegroundColour(wx.Colour(255, 0, 0))
      
      #-- Modificar iconos
      self.icono_S4.SetBitmap(self.imagen_unknow)  
      self.icono_S3.SetBitmap(self.imagen_unknow)  
      self.icono_S2.SetBitmap(self.imagen_unknow)  
      self.icono_S1.SetBitmap(self.imagen_unknow)  
      self.icono_B2.SetBitmap(self.imagen_unknow)  
      self.icono_B1.SetBitmap(self.imagen_unknow)
      self.icono_B3.SetBitmap(self.imagen_unknow)  
      self.icono_B4.SetBitmap(self.imagen_unknow)
      
      #-- Mostrar valor en hexadecimal de los puertos A y B
      self.label_puertob.SetLabel("XX")
      self.label_puertoa.SetLabel("XX")
      self.progress_luz.SetValue(0)
      self.label_luz.SetLabel("XXXX")
      
      #-- Valores de los bits a X
      self.label_RB7.SetLabel('X')
      self.label_RB6.SetLabel('X')
      self.label_RB5.SetLabel('X')
      self.label_RB0.SetLabel('X')
      
      self.label_RB4.SetLabel('X')
      self.label_RB3.SetLabel('X')
      self.label_RB2.SetLabel('X')
      self.label_RB1.SetLabel('X')
        
      self.label_RA5.SetLabel('X')
      self.label_RA4.SetLabel('X')
      self.label_RA3.SetLabel('X')
      self.label_RA2.SetLabel('X')
      self.label_RA1.SetLabel('X')
      self.label_RA0.SetLabel('X')
      
      self.statusbar.SetStatusText("No hay conexión con el Skybot",0);
      
    #------------------------------------
    #-- ESTADO OK_GENERIC
    #------------------------------------    
    elif state==GUI_OK_GENERIC:
      print "GUI Estado: GUI_OK_GENERIC"
      
      #-- Desactivar combo del puerto serie
      self.entry_serial.Disable();
      
      #-- El boton de Abrir es ahora de Cerrar
      self.button_abrir_cerrar.SetLabel("Cerrar")
      self.button_abrir_cerrar.Enable()
      
      #-- STARGATE
      self.button_generic.Disable()
      
      #-- OTROS
      self.button_cancel.Disable()
      
      #-- Skybot
      self.button_adelante.Enable()
      self.button_atras.Enable()
      self.button_derecha.Enable()
      self.button_izquierda.Enable()
      self.button_stop.Enable()
      self.button_stop.SetFocus()
      
      self.button_rele.Enable()
      self.button_led.Enable()
      self.button_M1_on.Enable()
      self.button_M1_dir.Enable()
      self.button_M2_on.Enable()
      self.button_M2_dir.Enable()
 
      #-- El temporizador se Activa, para comprobar la conexion con 
      #-- la Skypic
      self.timer.Start(LOAD_TIMEOUT,wx.TIMER_CONTINUOUS)

      #-- Hay conexion con el monitor: Indicarlo
      self.label_conexion.SetLabel("ESTABLECIDA")
      self.icono_conexion.SetBitmap(self.imagen_on)
      self.label_conexion.SetForegroundColour(wx.Colour(35, 142, 35))

      self.statusbar.SetStatusText("Conectado con el Robot",0);

    #----------------------------
    #-- ESTADO: PROGRESS
    #----------------------------    
    elif state==GUI_PROGESS:
      #-- Debug
      #print "GUI Estado: GUI_PROGESS"
      
      #-- El temporizador en este estado debe estar parado
      if self.timer.IsRunning():
        self.timer.Stop()
        
      #-- Boton de cancelacion activa
      self.button_cancel.Enable() 

      #-- Boton de descarga deshabilitado
      self.button_generic.Disable()
      
      #-- Skybot
      self.button_adelante.Disable()
      self.button_atras.Disable()
      self.button_derecha.Disable()
      self.button_izquierda.Disable()
      self.button_stop.Disable()
      
      #--- Desactivar combo del puerto serie
      self.entry_serial.Disable()
      
      #-- Desactivar boton de abrir/cerrar
      self.button_abrir_cerrar.Disable()

    else:
      print "Estado GUI NO implementado"        

    

    
    

   

 





    def EVT_MENU(self, event): # wxGlade: MyFrame.<event_handler>
        print "Event handler `EVT_MENU' not implemented"
        event.Skip()

    def boton_abrir_cerrar(self, event): # wxGlade: MyFrame.<event_handler>
        print "Event handler `boton_abrir_cerrar' not implemented"
        event.Skip()

# end of class MyFrame



#---------------------------------------------------------
#-- Funcion para obtener  la lista de puerto serie
#-- Esto depende de la plataforma en la que se ejecute
#---------------------------------------------------------
def getSerialPorts():

  #-- Windows
  if os.name == 'nt':
    
    #-- Se usan los cinco primeros puertos serie
    return ["","COM1","COM2","COM3","COM4","COM5"]
    
  #-- Linux  
  elif os.name == 'posix':
    return ["","/dev/ttyS0","/dev/ttyS1","/dev/ttyUSB0","/dev/ttyUSB1"]

  else:
    return []


#---------------------------------------------------
#-  Aplicacion principal
#---------------------------------------------------
class MyApp(wx.App):
      
    def OnInit(self):
        self.iris=None
        frame = MyFrame(self,None, -1, "")
        frame.Show(True)
        self.SetTopWindow(frame)
        
        #-- Anadir los nombres de los puertos serie al combobox
        serialports = getSerialPorts()
        for disp in serialports:
          frame.entry_serial.Append(disp) 
            
        return True
        
    def OnExit(self):
        print "Fin..."


#-------------------------------
#-  METODO DE ENTRADA
#-------------------------------
def start():
    app = MyApp(0)
    app.MainLoop()


if __name__ == "__main__":
    start()
