-- Testbench for opb_futaba
--
-- Embedded Systems on a Chip, Ph.D. Course
-- Sergio Lopez-Buedo, January 2005h

library IEEE;
use IEEE.std_logic_1164.all;

library opb_futaba_v1_00_a;
use opb_futaba_v1_00_a.all;

entity opb_futaba_tb is
end opb_futaba_tb;

architecture slb of opb_futaba_tb is

    component opb_futaba is
    generic
    (
        --USER generics added here
        C_CLK_FREQ      : integer           := 50_000_000;
        -- Bus protocol parameters, do not add to or delete
        C_BASEADDR      : std_logic_vector  := X"00000000";
        C_HIGHADDR      : std_logic_vector  := X"0000FFFF";
        C_OPB_AWIDTH    : integer           := 32;
        C_OPB_DWIDTH    : integer           := 32;
        C_FAMILY        : string            := "virtex2p"
    );
    port
    (
        --USER ports added here
        PwmOut          : out   std_logic;
        -- Bus protocol ports, do not add to or delete
        OPB_Clk         : in    std_logic;
        OPB_Rst         : in    std_logic;
        Sl_DBus         : out   std_logic_vector(0 to C_OPB_DWIDTH-1);
        Sl_errAck       : out   std_logic;
        Sl_retry        : out   std_logic;
        Sl_toutSup      : out   std_logic;
        Sl_xferAck      : out   std_logic;
        OPB_ABus        : in    std_logic_vector(0 to C_OPB_AWIDTH-1);
        OPB_BE          : in    std_logic_vector(0 to C_OPB_DWIDTH/8-1);
        OPB_DBus        : in    std_logic_vector(0 to C_OPB_DWIDTH-1);
        OPB_RNW         : in    std_logic;
        OPB_select      : in    std_logic;
        OPB_seqAddr     : in    std_logic
    );
    end component;
    
    signal OPB_addr      : std_logic_vector(0 to 31);
    signal OPB_data_out  : std_logic_vector(0 to 31);
    signal OPB_data_in   : std_logic_vector(0 to 31);
    signal OPB_be        : std_logic_vector(0 to 3);
    signal OPB_clk       : std_logic;
    signal OPB_rst       : std_logic;
    signal OPB_rnw       : std_logic;  
    signal OPB_select    : std_logic;
    signal Sln_xferAck   : std_logic;
    signal PwmOut        : std_logic;
    
begin   

    uut : opb_futaba
    generic map 
    (
        -- User generic
        C_CLK_FREQ         => 65_000_000,
        -- IPIF generics
        C_BASEADDR         => x"4000_0000",
        C_HIGHADDR         => x"4000_00FF",
        C_OPB_AWIDTH       => 32,
        C_OPB_DWIDTH       => 32,
        C_FAMILY           => "spartan3"
    )
    port map
    (
        -- User port
        PwmOut       => PwmOut,
        --Required OPB bus ports
        OPB_ABus     => OPB_addr,
        OPB_BE       => OPB_be,
        OPB_Clk      => OPB_clk,
        OPB_DBus     => OPB_data_out,
        OPB_RNW      => OPB_rnw,
        OPB_Rst      => OPB_rst,
        OPB_select   => OPB_select,
        OPB_seqAddr  => '0',
        Sl_DBus      => OPB_data_in,
        Sl_errAck    => open,
        Sl_retry     => open,
        Sl_toutSup   => open,
        Sl_xferAck   => Sln_xferAck
    );

    process
    begin
        OPB_clk <= '0';
        wait for 7.692 ns;
        OPB_clk <= '1';
        wait for 7.692 ns;
    end process;
    
    process
    
        procedure write(constant addr : in std_logic_vector(0 to 31); constant data : in std_logic_vector(0 to 31)) is
        begin
            wait for 5 ns;
            OPB_addr <= addr; OPB_rnw <= '0'; OPB_data_out <= data; OPB_select <= '1'; OPB_be <= "1111";
            wait until rising_edge(OPB_clk) and Sln_xferAck='1';
            OPB_select <= '0'; OPB_be <= "0000";
        end procedure;
        
        procedure read(constant addr : in std_logic_vector(0 to 31)) is
        begin
            wait for 5 ns;
            OPB_addr <= addr; OPB_rnw <= '1'; OPB_select <= '1'; OPB_be <= "1111";
            wait until rising_edge(OPB_clk) and Sln_xferAck='1';
            OPB_select <= '0'; OPB_be <= "0000";
        end procedure;
        
    begin
        
        OPB_addr <= x"00000000"; OPB_rnw <= '0'; OPB_be <= "0000"; OPB_select <= '0';
        OPB_rst <= '1';
        for i in 1 to 10 loop wait until rising_edge(OPB_clk); end loop;
        OPB_rst <= '0';

        for i in 1 to 5 loop wait until rising_edge(OPB_clk); end loop;
        write(x"4000_0000", x"00000000");
        for i in 1 to 10 loop wait until rising_edge(OPB_clk); end loop;
        read(x"4000_0000");
        
        wait for 60 ms;

        for i in 1 to 5 loop wait until rising_edge(OPB_clk); end loop;
        write(x"4000_0000", x"80000000");
        for i in 1 to 10 loop wait until rising_edge(OPB_clk); end loop;
        read(x"4000_0000");

        wait for 60 ms;

        for i in 1 to 5 loop wait until rising_edge(OPB_clk); end loop;
        write(x"4000_0000", x"FF000000");
        for i in 1 to 10 loop wait until rising_edge(OPB_clk); end loop;
        read(x"4000_0000");

        wait;

   end process;
    
end slb;
