/* $Id: xgpio_sinit.c,v 1.1 2006/02/16 23:28:46 moleres Exp $ */
/******************************************************************************
*
*       XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS"
*       AS A COURTESY TO YOU, SOLELY FOR USE IN DEVELOPING PROGRAMS AND
*       SOLUTIONS FOR XILINX DEVICES.  BY PROVIDING THIS DESIGN, CODE,
*       OR INFORMATION AS ONE POSSIBLE IMPLEMENTATION OF THIS FEATURE,
*       APPLICATION OR STANDARD, XILINX IS MAKING NO REPRESENTATION
*       THAT THIS IMPLEMENTATION IS FREE FROM ANY CLAIMS OF INFRINGEMENT,
*       AND YOU ARE RESPONSIBLE FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE
*       FOR YOUR IMPLEMENTATION.  XILINX EXPRESSLY DISCLAIMS ANY
*       WARRANTY WHATSOEVER WITH RESPECT TO THE ADEQUACY OF THE
*       IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR
*       REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE FROM CLAIMS OF
*       INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*       FOR A PARTICULAR PURPOSE.
*
*       (c) Copyright 2005 Xilinx Inc.
*       All rights reserved.
*
******************************************************************************/
/**
* @file xgpio_sinit.c
*
* The implementation of the XGpio component's static initialzation
* functionality.
*
* @note
*
* None
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who  Date     Changes
* ----- ---- -------- -----------------------------------------------
* 2.01a jvb  10/13/05 First release
* </pre>
*
*****************************************************************************/

/***************************** Include Files ********************************/

#include "xstatus.h"
#include "xparameters.h"
#include "xgpio_i.h"

/************************** Constant Definitions ****************************/

/**************************** Type Definitions ******************************/

/***************** Macros (Inline Functions) Definitions ********************/

/************************** Variable Definitions ****************************/


/************************** Function Prototypes *****************************/


/******************************************************************************/
/**
* Lookup the device configuration based on the unique device ID.  The table
* ConfigTable contains the configuration info for each device in the system.
*
* @param DeviceId is the device identifier to lookup.
*
* @return
*
* - A pointer of data type XGpio_Config which points to the device
*   configuration if DeviceID is found.
* - XNULL if DeviceID is not found.
*
* @note
*
* None.
*
******************************************************************************/
XGpio_Config *XGpio_LookupConfig(Xuint16 DeviceId)
{
    XGpio_Config *CfgPtr = XNULL;

    int i;

    for (i=0; i < XPAR_XGPIO_NUM_INSTANCES; i++)
    {
        if (XGpio_ConfigTable[i].DeviceId == DeviceId)
        {
            CfgPtr = &XGpio_ConfigTable[i];
            break;
        }
    }

    return CfgPtr;
}


/****************************************************************************/
/**
* Initialize the XGpio instance provided by the caller based on the
* given DeviceID.
*
* Nothing is done except to initialize the InstancePtr.
*
* @param InstancePtr is a pointer to an XGpio instance. The memory the pointer
*        references must be pre-allocated by the caller. Further calls to
*        manipulate the component through the XGpio API must be made with this
*        pointer.
*
* @param DeviceId is the unique id of the device controlled by this XGpio
*        component.  Passing in a device id associates the generic XGpio
*        instance to a specific device, as chosen by the caller or application
*        developer.
*
* @return
*
* - XST_SUCCESS           Initialization was successfull.
* - XST_DEVICE_NOT_FOUND  Device configuration data was not found for a device
*                         with the supplied device ID.
*
* @note
*
* None.
*
*****************************************************************************/
XStatus XGpio_Initialize(XGpio *InstancePtr, Xuint16 DeviceId)
{
    XGpio_Config *ConfigPtr;

    /*
     * Assert arguments
     */
    XASSERT_NONVOID(InstancePtr != XNULL);

    /*
     * Lookup configuration data in the device configuration table.
     * Use this configuration info down below when initializing this component.
     */
    ConfigPtr = XGpio_LookupConfig(DeviceId);
    if (ConfigPtr == (XGpio_Config *)XNULL)
    {
        InstancePtr->IsReady = 0;
        return(XST_DEVICE_NOT_FOUND);
    }

    return XGpio_CfgInitialize(InstancePtr, ConfigPtr, ConfigPtr->BaseAddress);
}

