/* $Id: xgpio_selftest.c,v 1.1 2006/02/16 23:28:46 moleres Exp $ */
/******************************************************************************
*
*       XILINX IS PROVIDING THIS DESIGN, CODE, OR INFORMATION "AS IS"
*       AS A COURTESY TO YOU, SOLELY FOR USE IN DEVELOPING PROGRAMS AND
*       SOLUTIONS FOR XILINX DEVICES.  BY PROVIDING THIS DESIGN, CODE,
*       OR INFORMATION AS ONE POSSIBLE IMPLEMENTATION OF THIS FEATURE,
*       APPLICATION OR STANDARD, XILINX IS MAKING NO REPRESENTATION
*       THAT THIS IMPLEMENTATION IS FREE FROM ANY CLAIMS OF INFRINGEMENT,
*       AND YOU ARE RESPONSIBLE FOR OBTAINING ANY RIGHTS YOU MAY REQUIRE
*       FOR YOUR IMPLEMENTATION.  XILINX EXPRESSLY DISCLAIMS ANY
*       WARRANTY WHATSOEVER WITH RESPECT TO THE ADEQUACY OF THE
*       IMPLEMENTATION, INCLUDING BUT NOT LIMITED TO ANY WARRANTIES OR
*       REPRESENTATIONS THAT THIS IMPLEMENTATION IS FREE FROM CLAIMS OF
*       INFRINGEMENT, IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
*       FOR A PARTICULAR PURPOSE.
*
*       (c) Copyright 2002 - 2004 Xilinx Inc.
*       All rights reserved.
*
******************************************************************************/
/**
* @file xgpio_selftest.c
*
* The implementation of the XGpio component's self test function.
* See xgpio.h for more information about the component.
*
* @note
*
* None
*
* <pre>
* MODIFICATION HISTORY:
*
* Ver   Who  Date     Changes
* ----- ---- -------- -----------------------------------------------
* 1.00a rmm  02/04/02 First release
* 2.00a jhl  01/13/04 Addition of dual channels and interrupts.
* </pre>
*
*****************************************************************************/

/***************************** Include Files ********************************/
#include "xgpio.h"

/************************** Constant Definitions ****************************/

/**************************** Type Definitions ******************************/

/***************** Macros (Inline Functions) Definitions ********************/

/************************** Variable Definitions ****************************/

/************************** Function Prototypes *****************************/


/******************************************************************************/
/**
* Run a self-test on the driver/device. This function does a minimal test 
* in which the data register is read. It only does a read without any kind
* of test because the hardware has been parameterized such that it may be only
* an input such that the state of the inputs won't be known.  
*
* All other hardware features of the device are not guaranteed to be in the 
* hardware since they are parameterizable. 
*
* ARGUMENTS:
*
* @param InstancePtr is a pointer to the XGpio instance to be worked on.
*        This parameter must have been previously initialized with
*        XGpio_Initialize().
*
* @return
*
* XST_SUCCESS always. If the GPIO device was not present in the hardware a bus
* error could be generated. Other indicators of a bus error, such as registers
* in bridges or buses, may be necessary to determine if this function caused
* a bus error.
*
* @note
*
* None.
*
******************************************************************************/
XStatus XGpio_SelfTest(XGpio *InstancePtr)
{
    XASSERT_NONVOID(InstancePtr != XNULL);
    XASSERT_NONVOID(InstancePtr->IsReady == XCOMPONENT_IS_READY);

    /* Read from the data register of channel 1 which is always guaranteed
     * to be in the hardware device. Since the data may be configured as
     * all inputs, there is not way to guarantee the value read so don't
     * test it.  
     */
    (void)XGpio_DiscreteRead(InstancePtr, 1);

    return(XST_SUCCESS);
}

