//
//
//
// SGTramas.h: interface for the CSGTramas class.
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
// Comments:  Basado en el servidor PICP del proyecto STARGATE 
//			  por Juan Gonzlez Gmez
//            ( http://www.iearobotics.com ).
//
// License:	  GPL  (LICENSE.TXT)			  
//            
//
//////////////////////////////////////////////////////////////////////



#if !defined(AFX_SGTRAMAS_H__AD299BBA_1108_4944_A6AF_27D2C8D5D594__INCLUDED_)
#define AFX_SGTRAMAS_H__AD299BBA_1108_4944_A6AF_27D2C8D5D594__INCLUDED_

#if _MSC_VER > 1000
#pragma once
#endif // _MSC_VER > 1000

#include "Serial.h"

#define TIMEOUT	100

/*-- Codigos de identificacion de las tramas --*/
#define TRAMA_PING_IT    0x00
#define TRAMA_PONG_IT    0x10
#define TRAMA_ID_IT      0x01
#define TRAMA_RID_IT     0x11
#define TRAMA_LOAD_IT    0x02
#define TRAMA_RLOAD_IT   0x12
#define TRAMA_STORE_IT   0x03
#define TRAMA_RSTORE_IT  0x13
#define TRAMA_UNKNOW_IT  0xFF // Trama desconocida

/*-- Cabeceras de la trama --*/
#define TRAMA_PING_CAB   'P'
#define TRAMA_ID_CAB     'I'
#define TRAMA_RID_CAB    'I'
#define TRAMA_PONG_CAB   'O'
#define TRAMA_LOAD_CAB   'L'
#define TRAMA_RLOAD_CAB  'L'
#define TRAMA_STORE_CAB  'S'
#define TRAMA_RSTORE_CAB 'S'

//-- Servidor picp
#define TRAMA_RD_CAB     'R'
#define TRAMA_RRD_CAB    'R'
#define TRAMA_INC_CAB    'A'
#define TRAMA_RINC_CAB   'A'
#define TRAMA_CONF_CAB   'C'
#define TRAMA_RCONF_CAB  'C'
#define TRAMA_PROG_CAB   'W'
#define TRAMA_RPROG_CAB  'W'
#define TRAMA_RST_CAB    'T'
#define TRAMA_RRST_CAB   'T'
#define TRAMA_DATA_CAB   'D'
#define TRAMA_RDATA_CAB  'D'
#define TRAMA_BEGIN_CAB  'B'
#define TRAMA_RBEG_CAB   'B'

#define TRAMA_SBORRAR_CAB	'X'	
#define TRAMA_RBORRAR_CAB	'X'
#define TRAMA_SENDP_CAB	'E'
#define TRAMA_RENDP_CAB	'E'
#define TRAMA_SPROG_BLOQUE 'K'
#define TRAMA_RPROG_BLOQUE 'K'


#define TRAMA_RDEE_CAB	'V'
#define TRAMA_RRDEE_CAB	'V'
#define TRAMA_LEE_CAB	'W'
#define TRAMA_RLEE_CAB	'W'

/*************************************/
/* Identificacin de los servidores  */
/*************************************/
#define SG_NULL    0x10
#define SG_GENERIC 0x20
#define SG_SERVOS8 0x30
#define SG_PICP    0x40

/***********************************************/
/* Cadenas de identificacin de los servidores */
/***********************************************/
#define SG_NULL_CAD    "NULL"
#define SG_GENERIC_CAD "GENERIC"
#define SG_SERVOS8_CAD "SERVOS8"
#define SG_PICP_CAD    "PICP"

/****************************************/
/* Identificacin del Micro.            */
/****************************************/
#define MICRO_68HC11E2		0x10
#define MICRO_68HC08		0x20
#define MICRO_PIC16F876		0x30
#define MICRO_PIC16F877A	0x40
#define MICRO_PIC16F84A		0x50

/********************************************/
/* Cadenas de identificacin de los micros  */
/********************************************/
#define MICRO_68HC11E2_CAD  "68HC11E2"
#define MICRO_68HC08_CAD    "68HC08"
#define MICRO_PIC16F876_CAD "P16F876"
#define MICRO_PIC16F877A_CAD "P16F877A"
/******************************************/
/* Identificacion de las placas           */
/******************************************/
#define PLACA_XPROGRAMMER	0x601
#define PLACA_XPIC			0x501
#define PLACA_CT6811		0x101
#define PLACA_GPBOT			0x201
#define PLACA_SKYPIC		0x301

/********************************************/
/* Cadenas de identificacion de las placas  */
/********************************************/
#define PLACA_XPIC_CAD	  "X-PIC"
#define PLACA_XPROG_CAD	  "X-PROGRAMMER"
#define PLACA_CT6811_CAD  "CT6811"
#define PLACA_GPBOT_CAD   "GPBOT"
#define PLACA_USER_CAD    "USER"
#define PLACA_SKYPIC_CAD  "SKYPIC"

class CSGTramas : public CSerial  
{
public:
	CSGTramas();
	virtual ~CSGTramas();
	int  SGReset();
	int  SGIncrementAddress();
	int  SGReadData(int *);
	int	 SGLoadConfig();
	int  SGProg(int );
	int  SGLoadData(int );
	int  SGBeginPEC();
	int  SGEndp();
	int  SGBorrarPic();
	int  SGProgBloque(int *);
	int  SGStore(int , int );
	int  SGLoad(int , int *);
	int  SGPing();
	int  SGLoadDataEE(int);
	int  SGReadDataEE(int *);
	int  SGId(unsigned char  *is, unsigned char *im, unsigned char *ipv);
	void SGTramasIPVtoString(unsigned char im, unsigned char ipv, char *);
	void SGTramasIMtoString(unsigned char im, char *);
	void SGTramasIStoString(unsigned char is, char *);
	
};

#endif // !defined(AFX_SGTRAMAS_H__AD299BBA_1108_4944_A6AF_27D2C8D5D594__INCLUDED_)
