//
//
//
// SGTramas.cpp: implementation of the CSGTramas class.
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
// Comments:  Basado en el servidor PICP del proyecto STARGATE 
//			  por Juan Gonzlez Gmez
//            ( http://www.iearobotics.com ).
//
// License:	  GPL			  
//            
//
//////////////////////////////////////////////////////////////////////


#include "StdAfx.h" 
#include "SGTramas.h"
 
//#include "BotControlDlg.h"

#ifdef _DEBUG
#undef THIS_FILE
static char THIS_FILE[]=__FILE__;
#define new DEBUG_NEW
#endif


//////////////////////////////////////////////////////////////////////
// Construction/Destruction
//////////////////////////////////////////////////////////////////////

CSGTramas::CSGTramas()
{

}

CSGTramas::~CSGTramas()
{

}


//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-reset
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////

int CSGTramas::SGReset() {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_RST_CAB;
	this->SendData((const char *)trama,1);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RRST_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}

//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-increment-address
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGIncrementAddress() {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_INC_CAB;
	this->SendData((const char *)trama,1);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RINC_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}


//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-read-data
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGReadData(int *valor) {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_RD_CAB;
	this->SendData((const char *)trama,1);
	unsigned char* lpBuffer = new unsigned char[10];

	memset(lpBuffer,0,10);
	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(11);
		iContTimeout+=1;
		}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
		if( lpBuffer[0] == TRAMA_RRD_CAB ) {
			int bms=lpBuffer[1]; //-- Byte menos significativo
			int BMS=lpBuffer[2]; //-- Byte mas significativo
			*valor =(unsigned int) ((BMS<<8) | bms);
			status=1;
		}
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}

//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-load-config que posiciona al PIC
// en la direccin de memoria 0x2000
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGLoadConfig() {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_CONF_CAB;
	this->SendData((const char *)trama,1);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RCONF_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}


//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-prog
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGProg(int valor) {

	unsigned char trama[4];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_PROG_CAB;
	trama[1]=(char)(valor & 0x00FF);           //-- Byte menos sig.
	trama[2]=(char)((valor>>8)&0x00FF);        //-- Byte mas sig.

	this->SendData((const char *)trama,3);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RPROG_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}

//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-load-data
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGLoadData(int valor) {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_DATA_CAB;
	trama[1]=(char)(valor & 0x00FF);           //-- Byte menos sig.
	trama[2]=(char)((valor>>8)&0x00FF);        //-- Byte mas sig

	this->SendData((const char *)trama,3);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RDATA_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}

//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-begin-pec
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGBeginPEC() {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_BEGIN_CAB;
	this->SendData((const char *)trama,1);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RBEG_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}

//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-endp
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGEndp() {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_SENDP_CAB;
	this->SendData((const char *)trama,1);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RENDP_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}


//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-borrar-pic
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////

int CSGTramas::SGBorrarPic() {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_SBORRAR_CAB;
	this->SendData((const char *)trama,1);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RBORRAR_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}


//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-prog-bloque
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////

int CSGTramas::SGProgBloque(int *bloque) {

	unsigned char trama[17];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;
	int cont=1,i;

	trama[0]=TRAMA_SPROG_BLOQUE;
	for(i=0;i<8;i++) {
  		trama[cont]= (char)(bloque[i] & 0x00FF);           //-- Byte menos sig.
		cont++;
  		trama[cont]= (char)((bloque[i]>>8)&0x00FF);        //-- Byte mas sig.
		cont++;
	}

	this->SendData((const char *)trama,17);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(1);
		iContTimeout+=1;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RPROG_BLOQUE )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}

//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-store
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGStore(int dir, int valor) {

	unsigned char trama[4];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_STORE_CAB;
	trama[1]=(dir & 0x00FF);
	trama[2]=(char)((dir>>8)&0x00FF);
	trama[3]=(char)valor;

	this->SendData((const char *)trama,4);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RSTORE_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}


//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-load
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////

int CSGTramas::SGLoad(int dir, int *valor) {

	unsigned char trama[3];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_LOAD_CAB;
	trama[1]=(dir & 0x00FF);
	trama[2]=(char)((dir>>8)&0x00FF);

	this->SendData((const char *)trama,3);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
		if( lpBuffer[0] == TRAMA_RLOAD_CAB ) {
		status=1;
		*valor=lpBuffer[1];
		}
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}


//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-loadEE (Load data for data memory )
//		
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////

int CSGTramas::SGLoadDataEE(int valor) {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_LEE_CAB;
	trama[1]=(char)(valor & 0x00FF);           //-- Byte menos sig.
	

	this->SendData((const char *)trama,2);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_RLEE_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;


}


//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-readEE (Read data for data memory )
//		
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////
int CSGTramas::SGReadDataEE(int *valor) {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_RDEE_CAB;
	this->SendData((const char *)trama,1);
	unsigned char* lpBuffer = new unsigned char[10];

	memset(lpBuffer,0,10);
	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(11);
		iContTimeout+=1;
		}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
		if( lpBuffer[0] == TRAMA_RRDEE_CAB ) {
			*valor = lpBuffer[1];
			status=1;
		}
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;


}

//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-ping
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////

int CSGTramas::SGPing() {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;

	trama[0]=TRAMA_PING_CAB;

	this->SendData((const char *)trama,1);
	unsigned char* lpBuffer = new unsigned char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
	if( lpBuffer[0] == TRAMA_PONG_CAB )
		status=1;
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}

//////////////////////////////////////////////////////////////////////
// Implementacin del servicio sg-id
//
// Author: Daniel lvarez Snchez        <dani001@gmail.com>
// Date: 22/03/05
//
//////////////////////////////////////////////////////////////////////


int CSGTramas::SGId(unsigned char  *is, unsigned char *im, unsigned char *ipv) {

	unsigned char trama[2];
	int status;
	int iContTimeout=0;
	int nBytesRead=0;


	 *is=0;
     *im=0;
     *ipv=0;

	trama[0]=TRAMA_ID_CAB;

	this->SendData((const char *)trama,1);
	char* lpBuffer = new char[10];

	while( iContTimeout < TIMEOUT  && nBytesRead == 0 ) {
		nBytesRead = this->ReadData(lpBuffer, 10);
		Sleep(10);
		iContTimeout+=10;
	}

	if( nBytesRead == 0 ) {
			status=0;
		}
	else {
		if( lpBuffer[0] == TRAMA_RID_CAB ) {
		status=1;
		*is=lpBuffer[1];
        *im=lpBuffer[2];
        *ipv=lpBuffer[3];
		}
	else
		status=-1;
	}
		
	
	delete []lpBuffer;
	return status;

}


void  CSGTramas::SGTramasIPVtoString(unsigned char im, unsigned char ipv, char *cad) {

 int placa;

  //-- Si los 4 bits mas significativos de IPV estan a cero
  //-- es que se trata de una placa hecha por el usuario
  if ((ipv&0xF0) == 0) {
    strcpy(cad,PLACA_USER_CAD);
    return;
  }

  //-- El campo im junto con los 4 bits mas significativos de IPV
  //-- determinan el tipo de placa que se esta usando
  placa = ((im<<4)&0xFF0) | ((ipv>>4)&0x0F);

  switch(placa) {
  case PLACA_XPIC:
	strcpy(cad,PLACA_XPIC_CAD);
	break;
  case PLACA_CT6811:
    strcpy(cad,PLACA_CT6811_CAD);
    break;
  case PLACA_GPBOT:
    strcpy(cad,PLACA_GPBOT_CAD);
    break;
  case PLACA_SKYPIC:
    strcpy(cad,PLACA_SKYPIC_CAD);
    break;
  default: //-- Placa desconocida
    strcpy(cad,"XXX");
  }

}

void  CSGTramas::SGTramasIMtoString(unsigned char im, char *cad) {

  switch(im) {
  case MICRO_PIC16F877A:
	strcpy(cad,MICRO_PIC16F877A_CAD);
	break;
  case MICRO_68HC11E2:
    strcpy(cad,MICRO_68HC11E2_CAD);
    break;
  case MICRO_68HC08:
    strcpy(cad,MICRO_68HC08_CAD);
    break;
  case MICRO_PIC16F876:
    strcpy(cad,MICRO_PIC16F876_CAD);
    break;
  default:
    strcpy(cad,"XXXX");
 
}

}

void CSGTramas::SGTramasIStoString(unsigned char is, char *cad)
{
  switch(is) {
  case SG_NULL: 
    strcpy(cad,SG_NULL_CAD);
    break;
  case SG_GENERIC:
    strcpy(cad,SG_GENERIC_CAD);
    break;
  case SG_SERVOS8:
    strcpy(cad,SG_SERVOS8_CAD);
    break;
  case SG_PICP:
    strcpy(cad,SG_PICP_CAD);
    break;
  default:
    strcpy(cad,"XXXX");
  }
}


