/***************************************************************************
 *            sg-null-6808-gpbot-0.c
 *
 *  Mon Feb 16 18:38:00 2004
 *  Copyright  2004  Juan Gonzalez
 *  juan@iearobotics.com
 ****************************************************************************/

/* $Revision: 1.1 $ */
/* $Date: 2004/02/16 18:10:26 $  */

/*
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  (at your option) any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU Library General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
 */

#include "sci.h"
#include "mc68hc908gp32.h"

/*---------------------*/
/*   DEFINICIONES      */
/*---------------------*/

//-- Datos devueltos por el servicio de identificacion
#define IS  0x10  // IS. Identificacion del servidor
#define IM  0x20  // IM. Identificacion del microcontrolador (68hc08)
#define IPV 0x10  // IPV. Placa GPBOT. Version 0.

//-- Identificadores de los servicios
#define	SID   0x49 // Servicio de identificacion
#define SPING 0x50 // Servicio de PING (0x50)

//-- Identificadores para la respuesta
#define RPING 0x4F // Respuesta al Servicio de PING (0x4F)
#define RSI   0x49 // RSI. Codigo de respuesta del servicio de identificacion	

/*---------------------*/
/* PROGRAMA PRINCIPAL  */
/*---------------------*/
void main(void)
{
	unsigned char car;
	
	/*----------------------------*/
	/* Configurar el sistema      */
  /*----------------------------*/
	CONFIG1|=0x01;  //-- Deshabilitar el COP
  DDRB=0xFF;      //-- Configurar Puerto B para salida
 	PORTB=0x00;     //-- Poner a 0 Puerto B
	
	/*-----------------------------*/
	/* Configurar el puerto serie  */
	/*-----------------------------*/
	sci_init();
	
	/*------------------*/
	/* Bucle principal  */
	/*------------------*/
	for (;;) {
		//-- Esperar a que se solicite un servicio
	  car=sci_leer_car();
		switch(car) {
			case SID:  //-- Servicio de identificacion 
				sci_enviar_car(RSI);
				sci_enviar_car(IS);
				sci_enviar_car(IM);
				sci_enviar_car(IPV);
				break;
			case SPING: //-- Servicio de PING
				sci_enviar_car(RPING);
				PORTB^=0x01;  //-- Cambiar de estado el bit 0 del puerto B
				break;
		}
	}	
		
}
