;---------------------------------------------------------------------
;- sg-null-6808-gpbot-0.asm.  Febrero 2004                           *
;--------------------------------------------------------------------*
;- (c) 2004 Juan Gonzalez Gomez  <juan@iearobotics.com>              *
;--------------------------------------------------------------------*
; Servidor NULO.                                                     *
; Servidor: sg-null                                                  *
; Implementado para el micro 68hc08GP32 en y la tarjeta GPBOT        *
;--------------------------------------------------------------------*
; Implementa los servicios basicos: PING e identificacion            *
; Al recibir un PING cambia de estado el pin 0 del puerto B          *
;--------------------------------------------------------------------*
; Licencia GPL                                                       *
;---------------------------------------------------------------------

;-- Incluir los registros del 6808
	.include "gpregs.inc"

	;-- Incluir mapa de memoria de la GPBOT
	.include "gpmap.inc"

;-------------------------------------
; DEFINICIONES
;-------------------------------------
;----- Datos devueltos por el servicio de identificacion
    RSI = 0x49  ; RSI. Codigo de respuesta del servicio de identificacion
    IS  = 0x10  ; IS. Identificacion del servidor
    IM  = 0x20  ; IM. Identificacion del microcontrolador (68hc08)
    IPV = 0x10  ; IPV. Placa GPBOT. Version 0.

;-- Identificadores de los servicios
	SID   = 0x49 ; Servicio de identificacion
	SPING = 0x50 ; Servicio de PING (0x50)

;-- Identificadores para la respuesta
	RPING = 0x4F ; Respuesta al Servicio de PING (0x4F)


	;-- Zona de codigo
	.area CSEG (ABS)
	.org RomStart
	
main:
	;-- Inicializar la pila
	ldhx #InitStk
	txs
	
	;-- Deshabilitar el COP
	bset #0,*CONFIG1
	
	;----------------------------------------
	;-- Configuracion comunicaciones serie
	;----------------------------------------
	;-- 9600 Baudios
	lda #0x22
	sta SCBR
	
	;-- Habilitar el SCI
	lda #0x40
	sta SCC1
	
	;-- Habilitar Transmisor y receptor
	lda #0x0C
	sta SCC2
	
	;------------------------
	;- Otras configuraciones
	;-------------------------
	
	;-- Configurar puerto B para salida
	lda	#0xFF
	sta	DDRB
	
	;-- Encender bit0 puerto B
	lda #0x01
	sta PORTB
	
	;-------------------
	;- Bucle principal
	;-------------------
	
server:
	jsr leer_sci	  ;-- Esperar a que PC solicite servicio
	cmp #SPING      ; Servicio de PING?
	beq serv_ping
	
	cmp #SID       ; Servicio de identificacion?
	beq serv_id
	
	bra server
	
;********************
;* Servicio de PING *
;********************
serv_ping:
	lda #RPING  ; Enviar la respuesta al PING
    jsr enviar_sci

	lda PORTB   ; Cambiar el bit 0 del puerto B
	eor #0x01
	sta PORTB

    jmp server
	
;*******************************
;* Servicio de identificacion  *
;*******************************
serv_id:
	lda #RSI   ; Enviar codigo de respuesta
    jsr enviar_sci
	lda #IS    ; Enviar identificacion del servidor
	jsr enviar_sci  
	lda #IM    ; Enviar identificador del micro
	jsr enviar_sci
	lda #IPV   ; Enviar identificador placa/version
	jsr enviar_sci

	jmp server


;---------------------------------------------
;- Enviar un byte por el SCI  
;- ENTRADAS: 
;-   -Acumulador A contiene dato a enviar
;---------------------------------------------
leer_sci:
	brclr #5,*SCS1,leer_sci
	lda SCDR
	rts

;-----------------------------------------
;- Recibir un dato del SCI
;- SALIDAS:      
;-    -Acumulador A devuelve dato leido
;-----------------------------------------
enviar_sci:
	brclr #7,*SCS1,enviar_sci
	sta SCDR
	rts


;---------------------------------------
;- Zona de vectores de interrupcion  
;---------------------------------------
dummy_isr:
	RTI

 	.area VECTOR (ABS)
	.org VectorStart
	.dw dummy_isr	;-- Vector TMB	
	.dw dummy_isr	;-- Vector DAC
	.dw dummy_isr ;-- Vector KBI
	.dw dummy_isr	;-- Vector Transmision SCI
	.dw dummy_isr	;-- Vector Receptor SCI
	.dw dummy_isr	;-- Vector Error SCI		
	.dw dummy_isr	;-- Vector Tranmisor SPI
	.dw dummy_isr	;-- Vector Receptor SPI
	.dw dummy_isr	;-- Vector Overflow TIM2
	.dw dummy_isr	;-- Vector Canal 1 TIM2
	.dw dummy_isr	;-- Vector Canal 0 TIM2
	.dw dummy_isr	;-- Vector Overflow TIM1
	.dw dummy_isr	;-- Vector Canal 1  TIM1
	.dw dummy_isr ;-- Vector Canal 0  TIM1
	.dw dummy_isr ;-- Vector PLL
	.dw dummy_isr ;-- Vector IRQ	
	.dw dummy_isr ;-- Vector SWI
	.dw main	;-- Vector Reset
