;---------------------------------------------------------------------
;- sg-generic-6808-gpbot-0.asm.  Febrero 2004                        *
;--------------------------------------------------------------------*
;- (c) 2004 Juan Gonzalez Gomez  <juan@iearobotics.com>              *
;--------------------------------------------------------------------*
; Servidor GENERICO.                                                 *
; Servidor: sg-generic                                               *
; Implementado para el micro 68hc08GP32 en y la tarjeta GPBOT        *
;--------------------------------------------------------------------*
; Implementa los servicios LOAD y STORE, ademas de los basicos:      *
; PING e identificacion                                              *
;--------------------------------------------------------------------*
; Licencia GPL                                                       *
;---------------------------------------------------------------------

;-- Incluir los registros del 6808
	.include "gpregs.inc"

	;-- Incluir mapa de memoria de la GPBOT
	.include "gpmap.inc"

;-------------------------------------
; DEFINICIONES
;-------------------------------------
;----- Datos devueltos por el servicio de identificacion
    IS  = 0x20  ; IS. Identificacion del servidor
    IM  = 0x20  ; IM. Identificacion del microcontrolador (68hc08)
    IPV = 0x10  ; IPV. Placa GPBOT. Version 0.

;-- Identificadores de los servicios
	SID   = 0x49 ; Servicio de identificacion
	SPING = 0x50 ; Servicio de PING 
	SLD   = 0x4C ; Servicio LOAD
	SST   = 0x53 ; Servicio STORE 

;-- Identificadores para la respuesta
	RPING = 0x4F ; Respuesta al Servicio de PING (0x4F)
	RLD   = 0x4C ; Codigo respuesta servicio LOAD
	RST   = 0x53 ; Codigo respuesta servicio STORE
	RSI   = 0x49 ; RSI. Codigo de respuesta del servicio de identificacion
	
	;-- Zona de codigo
	.area CSEG (ABS)
	.org RomStart
	
main:
	;-- Inicializar la pila
	ldhx #InitStk
	txs
	
	;-- Deshabilitar el COP
	bset #0,*CONFIG1
	
	;----------------------------------------
	;-- Configuracion comunicaciones serie
	;----------------------------------------
	;-- 9600 Baudios
	lda #0x22
	sta SCBR
	
	;-- Habilitar el SCI
	lda #0x40
	sta SCC1
	
	;-- Habilitar Transmisor y receptor
	lda #0x0C
	sta SCC2
	
	;-------------------
	;- Bucle principal
	;-------------------
	
server:
	jsr leer_sci	;-- Esperar a que PC solicite servicio
	cmp #SPING      ; Servicio de PING?
    beq serv_ping
	
	cmp #SID       ; Servicio de identificacion?
	beq serv_id
	
	cmp #SLD       ; Servicio de LOAD?
	beq serv_ld 

	cmp #SST       ; Servicio de STORE?
	BEQ serv_st 
	
	bra server
	
;********************
;* Servicio de PING *
;********************
serv_ping:

	lda #RPING  		; Enviar la respuesta al PING
    jsr enviar_sci

    jmp server
	
;*******************************
;* Servicio de identificacion  *
;*******************************
serv_id:
	lda #RSI   ; Enviar codigo de respuesta
    jsr enviar_sci
	lda #IS    ; Enviar identificacion del servidor
	jsr enviar_sci  
	lda #IM    ; Enviar identificador del micro
	jsr enviar_sci
	lda #IPV   ; Enviar identificador placa/version
	jsr enviar_sci

	jmp server
	
;*********************
;* Servicio LOAD     *
;*********************
serv_ld:
	jsr leer_dir ; Leer la direccion
	lda ,x       ; Leer el dato pedido
	
	psha
	;-- Enviar la respuesta
	lda #RLD
	bsr enviar_sci ; Codigo del load
	pula
	jsr enviar_sci ; Enviar dato
	
	jmp server
	
;**********************
;* Servicio  STORE    *
;**********************
serv_st:
	jsr leer_dir ; Leer la direccion
	jsr leer_sci ; Leer el dato a guardar
	
	sta ,x		 ; Guardar dato
	
	;-- Enviar la respuesta
	lda #RST
	jsr enviar_sci  ; Enviar la respuesta
	
	jmp server

;******************************************************
;* Lee el campo DIRECCION  de las tramas LOAD y STORE *
;* Devuelve en HX la direccion obtenida               *
;******************************************************
leer_dir:
        jsr leer_sci    ; Leer byte bajo de la direccion
        tax             ; X contiene byte bajo direccion
        jsr leer_sci    ; A contiene byte alto de la direccion
		psha
		pulh			; Ahora HX contiene la direccion leida
        RTS


;---------------------------------------------
;- Enviar un byte por el SCI  
;- ENTRADAS: 
;-   -Acumulador A contiene dato a enviar
;---------------------------------------------
leer_sci:
	brclr #5,*SCS1,leer_sci
	lda SCDR
	rts

;-----------------------------------------
;- Recibir un dato del SCI
;- SALIDAS:      
;-    -Acumulador A devuelve dato leido
;-----------------------------------------
enviar_sci:
	brclr #7,*SCS1,enviar_sci
	sta SCDR
	rts


;---------------------------------------
;- Zona de vectores de interrupcion  
;---------------------------------------
dummy_isr:
	RTI

 	.area VECTOR (ABS)
	.org VectorStart
	.dw dummy_isr	;-- Vector TMB	
	.dw dummy_isr	;-- Vector DAC
	.dw dummy_isr ;-- Vector KBI
	.dw dummy_isr	;-- Vector Transmision SCI
	.dw dummy_isr	;-- Vector Receptor SCI
	.dw dummy_isr	;-- Vector Error SCI		
	.dw dummy_isr	;-- Vector Tranmisor SPI
	.dw dummy_isr	;-- Vector Receptor SPI
	.dw dummy_isr	;-- Vector Overflow TIM2
	.dw dummy_isr	;-- Vector Canal 1 TIM2
	.dw dummy_isr	;-- Vector Canal 0 TIM2
	.dw dummy_isr	;-- Vector Overflow TIM1
	.dw dummy_isr	;-- Vector Canal 1  TIM1
	.dw dummy_isr ;-- Vector Canal 0  TIM1
	.dw dummy_isr ;-- Vector PLL
	.dw dummy_isr ;-- Vector IRQ	
	.dw dummy_isr ;-- Vector SWI
	.dw main	;-- Vector Reset
