	; 68HC908GP20/GP32 Equates

	PTA	= 0x0000 ; Ports and data direction
	PORTA	= 0x0000
	PTB 	= 0x0001
	PORTB 	= 0x0001
	PTC	= 0x0002
	PORTC 	= 0x0002
	PTD 	= 0x0003
	PORTD 	= 0x0003
	DDRA	= 0x0004
	DDRB 	= 0x0005
	DDRC 	= 0x0006
	DDRD 	= 0x0007
	PTE 	= 0x0008
	PORTE	= 0x0008
	DDRE	= 0x000C 

	PTAPUE	= 0x000D ; Port pull-up enables
	PTCPUE 	= 0x000E
	PTDPUE 	= 0x000F

	SPCR 	= 0x0010 ; SPI (Syncronous communications) 
	SPSCR 	= 0x0011 
	SPDR 	= 0x0012 
	
	SCC1 	= 0x0013 ; SPI (Asyncronous communications)
	SCC2 	= 0x0014 
	SCC3 	= 0x0015 
	SCS1 	= 0x0016 
	SCS2 	= 0x0017 
	SCDR 	= 0x0018
	SCBR 	= 0x0019

	INTKBSCR= 0x001a ; Keyboard interrupt control/status
	INTKBIER= 0x001b

	TBCR	= 0x001c ; Time base module

	INTSCR 	= 0x001d ; IRQ status/control

	CONFIG2 = 0x001e ; System configuration
 	CONFIG1 = 0x001f 

	T1SC  	= 0x0020 ; Timer 1 
	T1CNTH 	= 0x0021
	T1CNTL 	= 0x0022
	T1MODH	= 0x0023
	T1MODL 	= 0x0024
	T1SC0 	= 0x0025
	T1CH0H 	= 0x0026
	T1CH0L 	= 0x0027
	T1SC1 	= 0x0028
	T1CH1H 	= 0x0029
	T1CH1L 	= 0x002a

	T2SC 	= 0x002b ; Timer 2
	T2CNTH	= 0x002c 
	T2CNTL  = 0x002d
	T2MODH 	= 0x002e
	T2MODL 	= 0x002f
	T2SC0 	= 0x0030
	T2CH0H	= 0x0031
	T2CH0L 	= 0x0032
	T2SC1 	= 0x0033
	T2CH1H	= 0x0034
	T2CH1L	= 0x0035

	PCTL 	= 0x0036 ; Phase lock loop (for crystals)
	PBWC 	= 0x0037 
	PMSH 	= 0x0038
	PMSL 	= 0x0039
 	PMRS 	= 0x003A
 	PMDS 	= 0x003B

 	ADSCR 	= 0x003C ; A to D converter 
	ADR 	= 0x003D 
	ADCLK 	= 0x003E 

	SBSR 	= 0xfe00 ; System integration 
	SRSR 	= 0xfe01 
	SUBAR 	= 0xfe02 
	SBFCR 	= 0xfe03

	INT1 	= 0xfe04 ; Interrupt status
	INT2 	= 0xfe05

	INT3 	= 0xfe06 
	FLTCR 	= 0xfe07 ; Flash test/programming 
	FLCR 	= 0xfe08
 
	BRKH 	= 0xfe09 ; Hardware breakpoint 
	BRKL 	= 0xfe0a 
	BRKSCR 	= 0xfe0b
 
	LVISR 	= 0xfe0c ; Low voltage detect 
	FLBPR 	= 0xff80 ; Flash boot protect 
	COPCTL 	= 0xffff ; COP (Computer operating properly) control 

	;(C)opywrite P&E Microcomputer Systems, 1998 
	; You may use this code freely as long as this copyright notice 
	; is included.

