/************************************************************************/
/* SIN.H   (c) MICROBOTICA, S.L        Diciembre 1998.                  */
/*----------------------------------------------------------------------*/
/* Estructuras de datos e interfaz del modulo SIN.C                     */
/*----------------------------------------------------------------------*/
/*  Modificacion a 23 de diciembre de 1998:                             */
/*     - Se han anadido el campo nlinea a cada instruccion que contiene */
/*       el numero de linea en el codigo fuente.                        */
/*     - Se ha anadido el campo quedan en la estructura de REPITE que   */
/*       indica el numero de repeticiones que quedan por hacer.         */ 
/************************************************************************/

/***************************/
/* Tipos de sentencias     */
/***************************/
enum tsentencia {
  s_repite, s_if, s_espera, s_motor, s_salida, s_nula
};

/************************************************************/
/* Identificadores para las entradas y salidas (ON y OFF)   */
/************************************************************/
enum tident_io {
  i_on, i_off
};

/*****************************************************/
/* Identificadores para las control de los motores   */
/*****************************************************/
enum tident_mot {
  m_off, m_derecha, m_izquierda,
};

/* ------------------- ESTRUCTURAS DE DATOS ---------------------------*/


/***********************************/
/* Lista encadenada de sentencias  */
/***********************************/
typedef struct sentencias lista_sentencias;
struct sentencias {  
  enum tsentencia ts;    /* Tipo de sentencia      */
  void *s;               /* Puntero a la sentencia */
  lista_sentencias *ss;  /* Puntero a las siguientes sentencias */
};

/***************************************************/
/* Estructura para las sentencias del tipo repite  */
/***************************************************/
typedef struct srep tipo_srepite;
struct srep {
  int repeticion;       /* Numero de veces a repetir bucle      */
  int quedan;           /* Numero de repeticiones que quedan    */
  int nlinea;           /* Numero de linea en el codigo fuente  */
  lista_sentencias *ss; /* Lista de sentencias dentro del bucle */
};

/*****************************************************/
/* Estructura para las sentencias del tipo salida    */
/*****************************************************/
typedef struct ssal tipo_ssalida;
struct ssal {
  int nsal;                 /* Numero de salida    */
  int nlinea;               /* Numero de linea en codigo fuente  */
  enum tident_io estado;    /* Estado de la salida */
};


/****************************************************/
/* Estructura para las sentencias del tipo espera   */
/****************************************************/
typedef struct sesp tipo_sespera;
struct sesp {
  int seg;        /* Segundos de espera */
  int nlinea; 
};

/*****************************************************/
/* Estructura para las sentencias del tipo motor     */
/*****************************************************/
typedef struct smotor tipo_smotor;
struct smotor {
  int nmotor;                   /* Numero de motor  */
  int nlinea;                   /* Numero linea en codigo fuente */
  enum tident_mot estado;       /* Estado del motor */
};

/*****************************************************/
/* Estructura para la condicion entrada              */
/*****************************************************/
typedef struct cent tipo_centrada;
struct cent {
  int nent;                 /* Numero de la Entrada */
  int nlinea;               /* Numero de linea en codigo fuente */
  enum tident_io estado;    /* Estado de la entrada */
};

/****************************************/
/* Estructura para la sentencia IF      */
/****************************************/
typedef struct sif tipo_sif;
struct sif {
  tipo_centrada *condicion;  /* Condicion del if */
  int nlinea;                /* Numero de linea en codigo fuente */
  lista_sentencias *ss;      /* Puntero a lista de sentencias */
};

/* -------------------------- INTERFAZ ------------------------------ */


extern lista_sentencias *crear_ast(int,int *);
/**************************************************************/
/*  Devolver un puntero al arbol abstracto de datos creado.   */
/**************************************************************/

extern void print_ast(lista_sentencias *);
/******************************************/
/* Imprimir en pantalla el ast pasado     */
/******************************************/

extern char *getsin_error();
/*****************************************************************/
/* Devolver la cadena de error del ultimo error producido.       */
/*****************************************************************/

extern int get_num_sin_error();
/***********************************/
/*  Devolver el numero de error    */
/***********************************/

extern int get_linea_error();
/****************************************/
/*  Devolver el numero de linea donde   */
/*  se ha producido el error.           */
/****************************************/

