/***********************************************************************/
/*  SEM.C   (C) Microbotica, S.L.      Diciembre 1998.                 */
/*---------------------------------------------------------------------*/
/* PROYECTO: PC-BOT                                                    */
/* SUBPROYECTO: Interprete para PC-BOT                                 */
/* DESCRIPCION: Analizador semantico                                   */
/***********************************************************************/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "ctype.h"
#include "io.h"
#include "stdlib.h"
#include <alloc.h>

#include "sin.h"
#include "sem.h"

static int nsemerror=0;
static int nlinea;      /* Numero de linea donse se ha producido el error */

/* Errores que se pueden producir en el analizador semantico */
static char sem_error[3][80]={
  {"Sentencia ENTRADA: Numero de entrada incorrecto"},    /* 1 */
  {"Sentencia MOTOR: Numero de motor incorrecto"},        /* 2 */ 
  {"Sentencia SALIDA: Numero de salida incorrecta"},      /* 3 */ 
};

void verificar_sentencias(lista_sentencias *,int *);

/*******************************************************************/
/*             C   O   D   I   G   O                               */
/*******************************************************************/

char *getsem_error()
/*****************************************************************/
/* Devolver la cadena de error del ultimo error producido.       */
/*****************************************************************/
{
  if (nsemerror==0) return 0;  /* No hay errores */
  return (char *)&sem_error[nsemerror-1];
}

int get_num_sem_error()
/***********************************/
/*  Devolver el numero de error    */
/***********************************/
{
  return nsemerror;
}

int get_sem_linea_error()
/***************************************************/
/*  Devolver linea donde se ha producido el error  */
/***************************************************/
{
  return nlinea;
}

void verificar_entrada(tipo_centrada *ent, int *error)
/*************************************/
/* Verificar la condicion entrada    */
/*************************************/
{
  if (ent==NULL) return;
  
  if (ent->nent==0 || ent->nent>MAXENTRADAS) {
    *error=1;
    nsemerror=1;  /* Numero de entrada incorrecto */
    nlinea=ent->nlinea;
    return;
  }
}

void verificar_sif(tipo_sif *sif,int *error)
/********************************/
/* Verificar una sentencia if   */
/********************************/
{
  if (sif==NULL) return;
  
  verificar_entrada(sif->condicion,error);
  if (*error) return;
  verificar_sentencias(sif->ss,error);
}

void verificar_srepite(tipo_srepite *repite,int *error)
/*************************************/
/* Verificar una sentencia repite    */
/*************************************/
{
  if (repite==NULL) return;
  
  verificar_sentencias(repite->ss,error);
}

void verificar_sespera(tipo_sespera *esp,int *error)
/**********************************/
/*  Verificar sentencia espera    */
/**********************************/
{
  if (esp==NULL) return;
  
  /* En las sentencias espera no hay nada que verificar */
  /* en principio                                       */
}

void verificar_smotor(tipo_smotor *mot, int *error)
/************************************/
/*  Verificar la sentencia motor    */
/************************************/
{
  if (mot==NULL) return;
  
  if (mot->nmotor==0 || mot->nmotor>MAXMOTORS) {
    *error=1;
    nsemerror=2;  /* Numero de motor incorrecto */
    nlinea=mot->nlinea;
    return;
  }
}

void verificar_ssalida(tipo_ssalida *sal, int *error)
/************************************/
/* Verificar la sentencia salida    */
/************************************/
{
  if (sal==NULL) return;
  
  if (sal->nsal==0 || sal->nsal>MAXSALIDAS) {
    *error=1;
    nsemerror=3;
    nlinea=sal->nlinea;
    return;
  }
}

void verificar_sentencias(lista_sentencias *ls,int *error)
/******************************************/
/*  Verificar una lista de sentencias     */
/******************************************/
{
  if (ls==NULL) return;
  
  switch(ls->ts) {
    case s_repite: verificar_srepite((tipo_srepite *)ls->s,error); break;
    case s_if    : verificar_sif((tipo_sif *)ls->s,error); break;
    case s_espera: verificar_sespera((tipo_sespera *)ls->s,error); break;
    case s_motor : verificar_smotor((tipo_smotor *)ls->s,error); break;
    case s_salida: verificar_ssalida((tipo_ssalida *)ls->s,error); break;
  }
  if (*error) return;
  verificar_sentencias(ls->ss,error);
}


void verificar_ast(lista_sentencias *ast,int *error)
/*********************************************/
/* Realizar el analisis semantico            */
/*********************************************/
{
  *error=0;
  
  if (ast==NULL) return;
  verificar_sentencias(ast,error);
}

