/*********************************************************************/
/* PSIN.C   (C) MICROBOTICA, S.L.      Diciembre 1998.               */
/*-------------------------------------------------------------------*/
/* Programa de prueba del modulo SIN.C                               */
/*********************************************************************/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "ctype.h"
#include "io.h"
#include "stdlib.h"
#include <fcntl.h>

/* Modulos incluidos */
#include "sin.h"

extern int errno;

int procesar_argumentos(int argc, char **argv)
/***************************************************************/
/* Abrir el fichero que se pasa como argumento. Si no se pasa  */
/* ninguno se toma la entrada estandar (teclado).              */
/*  Se devuelve el descriptor del fichero o -1 si ha habido    */
/*  algun error.                                               */
/***************************************************************/
{
  int fd;
  
  printf ("\n");
  if (argc==2){
    fd=open(argv[1],O_RDONLY);
    if (fd==-1) {
      printf ("Error!: %s\n",strerror(errno));
    }
    else printf ("Abierto fichero: %s\n",argv[1]);
  }
  else {
    printf ("Entrada estandar\n");
    fd=0;
  }
  return fd;
}

main(int argc, char **argv)
{
  int error;
  lista_sentencias *ls;
  int fd;                 /* Descriptor del fichero */
  int linea;
  
  fd=procesar_argumentos(argc,argv);
  if (fd==-1) exit(1);
  
  printf ("Analisis sintactico..");
  ls=crear_ast(fd,&error);
  if (error) {
    linea=get_linea_error();
    printf ("\nError en linea %u!! %s\n",linea,getsin_error());
  }
  else {
    printf ("OK!\n\n");
    print_ast(ls);
    free(ls);  
  }  
    
  close(fd);
}

