/****************************************************************/
/* PLEX.C    (c) Microbotica.           Diciembre 1998.         */
/*--------------------------------------------------------------*/
/* Programa de prueba del modulo LEX.C                          */
/****************************************************************/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "ctype.h"
#include "io.h"
#include "stdlib.h"
#include <fcntl.h>

/* Modulos incluidos */
#include "lex.h"

extern int errno;


int procesar_argumentos(int argc, char **argv)
/***************************************************************/
/* Abrir el fichero que se pasa como argumento. Si no se pasa  */
/* ninguno se toma la entrada estandar (teclado).              */
/*  Se devuelve el descriptor del fichero o -1 si ha habido    */
/*  algun error.                                               */
/***************************************************************/
{
  int fd;
  
  printf ("\n");
  if (argc==2){
    fd=open(argv[1],O_RDONLY);
    if (fd==-1) {
      printf ("Error!: %s\n",strerror(errno));
    }
    else printf ("Abierto fichero: %s\n",argv[1]);
  }
  else {
    printf ("Entrada estandar\n");
    fd=0;
  }
  return fd;
}

main(int argc, char **argv)
{
  int fd;  /* Descriptor del fichero */
  char c;
  struct tipo_token t;
  
  fd=procesar_argumentos(argc,argv);
  if (fd==-1) exit(1);
  
  do {
    leer_token(&t,fd);
    print_token(&t);
  } while (t.tipo!=t_fin_fichero);  
    
  close(fd);
}
