/*********************************************************************/
/* PINT.C   (C) MICROBOTICA, S.L.      Diciembre 1998.               */
/*-------------------------------------------------------------------*/
/* Programa de prueba del modulo INT.C                               */
/*********************************************************************/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "ctype.h"
#include "io.h"
#include "stdlib.h"

#include "R6811pc.h"
#include "serie.h"
#include "ctclient.h"
#include "bootstrp.h"

#include <fcntl.h>
#include <alloc.h>

/* Modulos incluidos del analizador */
#include "sin.h"
#include "sem.h"
#include "int.h"


int i=0;
int n=0;
extern int errno;


void accion_rxcar()
{
}

void accion_break()
{
}

void carga()
{
  static byte n=0;
  static byte i=0;

  if (n==16 || i==255) {
    n=0;
    printf ("");
  }

  i++;
  n++;
}

int inicializar_ct6811()
/*
Ŀ
  Incializar la CT6811 con el CTSERVER. Se comprueba si el CTSERVER   
  est cargado. En caso de no estarlo se carga.                       
                                                                      
  La funcin devuelve 1 en caso de que todo funcione. 0 en caso de    
  haberse establecido la conexion con el servidor.                    
*/

{
  char c;
  S19 fs19;
  char *caderror;

  

  printf ("\n");
  check_conexion();
  if (!hay_conexion()) {
    printf ("CARGANDO SOFTWARE EN TARJEA PCBOT\n");
    if (abrir_s19("pcbots.s19",&fs19,1)==0) {
      caderror=(char *)geterrors19();
      printf ("Error: %s\n",caderror);
      return 0;
    }
    printf ("\n");

    printf ("0%     50%   100%\n");
    printf ("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");

    resetct6811();
    if (cargars19_ramint(fs19,carga)==0) {
      printf ("\nError: %s",getloaderror());
      cerrar_s19(fs19);
      return 0;
    }
    else {
      printf (" OK!!\n\n");
      cerrar_s19(fs19);
      delay(100);
      baudios(9600);
    }
  }
  printf ("CONEXION ESTABLECIDA\n");
  return 1;
}

int procesar_argumentos(int argc, char **argv)
/***************************************************************/
/* Abrir el fichero que se pasa como argumento. Si no se pasa  */
/* ninguno se toma la entrada estandar (teclado).              */
/*  Se devuelve el descriptor del fichero o -1 si ha habido    */
/*  algun error.                                               */
/***************************************************************/
{
  int fd;
  
  printf ("\n");
  if (argc==2){
    fd=open(argv[1],O_RDONLY);
    if (fd==-1) {
      printf ("Error!: %s\n",strerror(errno));
    }
    else printf ("Abierto fichero: %s\n",argv[1]);
  }
  else {
    printf ("Entrada estandar\n");
    fd=0;
  }
  return fd;
}

lista_sentencias *analisis(int fd, int *error)
/**************************************************************/
/* Realizar analisis sintactico y semantico y devolver el     */
/* ast.                                                       */
/**************************************************************/
{
  int linea;
  lista_sentencias *ls;
  
  printf ("Analisis sintactico..");
  ls=crear_ast(fd,error);
  if (*error) {
    linea=get_linea_error();
    printf ("\nError en linea %u!! %s\n",linea,getsin_error());
    return NULL;
  }
  printf ("OK!\n");
  printf ("Analisis semantico..");
  verificar_ast(ls,error);
  if (*error) {
    printf ("\nError semantico!! %s\n",getsem_error());
    return NULL;
  }
  printf ("OK|\n");
  return ls;
}

int ready_ct()
/***********************************************************/
/* Abrir puerto serie y cargar programa servidor.          */
/* Se devuelve 1 si se ha cargado sin problemas, 0 en caso */
/* contrario.                                              */
/***********************************************************/
{
  return inicializar_ct6811();
}

main(int argc, char **argv)
{
  int error;
  lista_sentencias *ls;
  int fd;                 /* Descriptor del fichero */ 
  int linea;
  

  fd=procesar_argumentos(argc,argv);
  if (fd==-1) exit(1);

  /* Analizar el programa fuente */
  ls=analisis(fd,&error);
  if (error)  return 0;
  close(fd);

  abrir_puerto_serie(2);  /* Abrir sesion con puerto serie COM2 */
  baudios(9600);

  /* Cargar el CTSERVER */
  if (!ready_ct()) {
    cerrar_puerto_serie();
    return 0;
  }
  
  printf ("Interpretando...\n\n");
  if (!interpreta_ast(ls)) {
    linea=get_int_linea_error();
    printf ("\nLinea %u: %s\n",linea,getint_error());
  }
  else {
    printf ("OK\n\n");
  }

/*  print_ast(ls); */
  free(ls);
  cerrar_puerto_serie();
}

