/*****************************************************************/
/* LEX.H     (c) Microbotica.  Diciembre 1998.                   */
/*---------------------------------------------------------------*/
/* Estructuras de datos e interfaz del modulo LEX.C              */
/*****************************************************************/

#define LF 10

#define MAXINST     7   /* Numero de instrucciones del lenguaje */
#define MAXLONGINST 10  /* Maximo numero de caracteres de las instrucciones */
#define MAXIDENTIF  50  /* Longitud maxima de un identificador  */

typedef unsigned short int byte;

/************************/
/*  Tipos de Tokens     */
/************************/
enum ttoken {
  /* Token de las instrucciones */
  t_repite, t_if, t_espera, t_salida, t_motor, t_entrada, t_nota,
  
  /* Token de delimitacion */
  t_abre_block, t_cierra_block, t_abre_par, t_cierra_par, t_puntycoma,
  t_fin_linea, t_fin_fichero, t_coma,
  
  /* Otros tokens */
  t_numero, t_on, t_off, t_derecha, t_izquierda, t_unknow
};

/****************************/
/* Estructura de los tokens */
/****************************/
struct tipo_token {
  enum ttoken tipo;   /* Tipo de token            */
  byte valor;         /* Valor del token t_numero */
};

/*************************/
/*   I N T E R F A Z     */
/*************************/

extern int leer_token(struct tipo_token *,int);
/*********************************************/
/*  Leer un token del fichero especificado   */
/*  Se devuelve 0 si ha habido error         */
/*********************************************/

extern void print_token(struct tipo_token *);
/**********************************************************************/
/* Imprimir el tipo de token. Esta funcion solo se utiliza a efectos  */
/* de depuracion.                                                     */
/**********************************************************************/

extern char *getlex_error();
/*******************************************************************/
/* Devolver la cadena de error del ultimo error producido.         */
/*******************************************************************/

extern int get_num_lex_error();
/***********************************/
/* Devolver el numero de error     */
/***********************************/

extern void reset_lex();
