/*********************************************************************/
/* INTPCBOT.C   (C) MICROBOTICA, S.L.      Enero 1998.               */
/*-------------------------------------------------------------------*/
/* Interprete para la placa PC-BOT.                                  */
/* Version para MICRO-LOG.                                           */
/*********************************************************************/

#include "stdio.h"
#include "dos.h"
#include "conio.h"
#include "ctype.h"
#include "io.h"
#include "stdlib.h"
#include "string.h"

#include "R6811pc.h"
#include "serie.h"
#include "ctclient.h"
#include "bootstrp.h"

#include <fcntl.h>
#include <alloc.h>

/* Modulos incluidos del analizador */
#include "sin.h"
#include "sem.h"
#include "int.h"


const float VERSION = 1.0;

extern int errno;
int puertopc=2;    /* Puerto donde esta conectado PC-BOT */
char nomfich[80];
int i=0;
int n=0;

/*-------------------------------------------------------------------*/
/*---        Rutinas de inicializacion de PC-BOT      ---------------*/
/*-------------------------------------------------------------------*/

void accion_rxcar()
{
}

void accion_break()
{
}

void carga()
{
  static byte n=0;
  static byte i=0;

  if (n==16 || i==255) {
	n=0;
	textcolor(BROWN);
	cprintf ("");
  }

  i++;
  n++;
}

int inicializar_pcbot()
/***********************************/
/* Inicializar la tarjeta PC-BOT   */
/***********************************/
{
  char c;
  char *caderror;
  unsigned short int programint[256]={
 0x20 , 0x05 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0xCE ,
 0x10 , 0x00 , 0x1F , 0x2E , 0x40 , 0xFC , 0x86 , 0x30 ,
 0xA7 , 0x2B , 0xCE , 0x10 , 0x00 , 0x8D , 0x66 , 0x97 ,
 0x06 , 0x81 , 0x44 , 0x27 , 0x13 , 0x81 , 0x43 , 0x27 ,
 0x54 , 0x81 , 0x41 , 0x27 , 0x17 , 0x81 , 0x42 , 0x27 ,
 0x0E , 0x81 , 0x45 , 0x27 , 0x6A , 0x7E , 0x00 , 0x12 ,
 0x86 , 0x4A , 0x8D , 0x50 , 0x7E , 0x00 , 0x12 , 0x7C ,
 0x00 , 0x06 , 0x20 , 0x03 , 0x7F , 0x00 , 0x06 , 0x8D ,
 0x4A , 0x18 , 0xDF , 0x02 , 0x8D , 0x45 , 0x18 , 0xDF ,
 0x04 , 0x18 , 0x8C , 0x00 , 0x00 , 0x27 , 0x23 , 0x18 ,
 0xDE , 0x02 , 0x96 , 0x06 , 0x4D , 0x26 , 0x07 , 0x18 ,
 0xA6 , 0x00 , 0x8D , 0x28 , 0x20 , 0x05 , 0x8D , 0x1D ,
 0x18 , 0xA7 , 0x00 , 0x18 , 0x08 , 0x18 , 0xDF , 0x02 ,
 0x18 , 0xDE , 0x04 , 0x18 , 0x09 , 0x18 , 0xDF , 0x04 ,
 0x20 , 0xD7 , 0x7E , 0x00 , 0x12 , 0x8D , 0x14 , 0x18 ,
 0xDF , 0x02 , 0x18 , 0x6E , 0x00 , 0x1F , 0x2E , 0x20 ,
 0xFC , 0xA6 , 0x2F , 0x39 , 0x1F , 0x2E , 0x80 , 0xFC ,
 0xA7 , 0x2F , 0x39 , 0x36 , 0x37 , 0x8D , 0xEE , 0x16 ,
 0x8D , 0xEB , 0x18 , 0x8F , 0x33 , 0x32 , 0x39 , 0x8D ,
 0xF2 , 0x18 , 0xDF , 0x02 , 0x8D , 0xED , 0x18 , 0xDF ,
 0x04 , 0x18 , 0x8C , 0x00 , 0x00 , 0x27 , 0x34 , 0x18 ,
 0xDE , 0x02 , 0xC6 , 0x16 , 0xF7 , 0x10 , 0x3B , 0x18 ,
 0xE7 , 0x00 , 0xC6 , 0x17 , 0xF7 , 0x10 , 0x3B , 0x8D ,
 0x28 , 0xC6 , 0x02 , 0xF7 , 0x10 , 0x3B , 0x8D , 0xBD ,
 0x8D , 0xC2 , 0x18 , 0xA7 , 0x00 , 0xC6 , 0x03 , 0xF7 ,
 0x10 , 0x3B , 0x8D , 0x15 , 0x18 , 0x08 , 0x18 , 0xDF ,
 0x02 , 0x18 , 0xDE , 0x04 , 0x18 , 0x09 , 0x18 , 0xDF ,
 0x04 , 0x20 , 0xC6 , 0x7F , 0x10 , 0x3B , 0x7E , 0x00 ,
 0x12 , 0x18 , 0x3C , 0x18 , 0xCE , 0x0D , 0x10 , 0x18 ,
 0x09 , 0x18 , 0x8C , 0x00 , 0x00 , 0x26 , 0xF8 , 0x18 ,
 0x38 , 0x39 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,
 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 , 0x00 ,} ;


  check_conexion();
  if (!hay_conexion()) {
	vaciar_buffer();
	resetct6811();
	delay(100);
	if (!ok_break()) {
	  cprintf ("Tarjeta PCBOT no detectada en com%u\n\r",puertopc);
	  return 0;
	}
	textcolor(LIGHTGREEN);
	cprintf ("RESET DE LA TARJETA PCBOT\n\r");
	textcolor(CYAN);
	cprintf ("CARGANDO SOFTWARE\n\r");
	cprintf ("\n\r");
	textcolor(YELLOW);
	cprintf ("0%     50%   100%\n\r");
	cprintf ("\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b\b");

	if (cargar_ramint(programint,carga)==0) {
	  textcolor(7);
	  cprintf ("\n\rError en inicializacion de la tarjeta\n\r");
	  /*printf ("\nError: %s",getloaderror());*/
	  return 0;
	}
	textcolor(7);
	cprintf (" OK!!\n\n\r");
	delay(100);
	baudios(9600);
  }
  return 1;
}

/* ---------------------------------------------------------------- */
/* ----         OTRAS   RUTINAS                                 --- */
/* ---------------------------------------------------------------- */

int procesar_argumentos(int argc, char **argv)
/***************************************************************/
/* Abrir el fichero que se pasa como argumento. Si no se pasa  */
/* ninguno se toma la entrada estandar (teclado).              */
/*  Se devuelve el descriptor del fichero o -1 si ha habido    */
/*  algun error.                                               */
/***************************************************************/
{
  int fd;
  
  cprintf ("\n\r");
  if (argc==2){
    fd=open(argv[1],O_RDONLY);
    if (fd==-1) {
	  cprintf ("Error!: %s\n\r",strerror(errno));
    }
	else cprintf ("Abierto fichero: %s\n\r",argv[1]);
  }
  else {
	cprintf ("Entrada estandar\n\r");
    fd=0;
  }
  return fd;
}

lista_sentencias *analisis(int fd, int *error)
/**************************************************************/
/* Realizar analisis sintactico y semantico y devolver el     */
/* ast.                                                       */
/**************************************************************/
{
  int linea;
  lista_sentencias *ls;
  
  ls=crear_ast(fd,error);
  if (*error) {
    linea=get_linea_error();
	cprintf ("\n\rError en linea %u!! %s\n\r",linea,getsin_error());
	return NULL;
  }
  verificar_ast(ls,error);
  if (*error) {
	linea=get_sem_linea_error();
	cprintf ("\n\rError en linea %u!! %s\n\r",linea,getsem_error());
    return NULL;
  }
  cprintf ("OK!\n\r");
  return ls;
}

void presenta()
{
  cprintf ("\r\n\n");
  textcolor(12); cprintf ("INTPCBOT ");
  textcolor(11); cprintf ("Versin %0.1f ",VERSION);
  textcolor(10);
  cprintf ("(C) Microbtica,S.L.\n\r");
  textcolor(9);
  cprintf ("Intrprete para la tarjeta PC-BOT\r\n\n");
}

void display_help()
{
  cprintf ("Sintaxis: intpcbot puerto [programa]\n\n\r");
  cprintf ("El parmetro puerto especifica el puerto donde se encuentra\n\r");
  cprintf ("la tarjeta PCBOT.Este parametro es de la forma:\n\r");
  cprintf ("     -comx  :  siendo x un nmero entre 1,2,3  4. Utilizar el\n\r");
  cprintf ("               puerto x. (com1, com2, com3  com4)\n\r");
  cprintf ("\n\n\r");
  cprintf ("Ejemplo:  intpcbot -com2 prueba.bot\n\n\r");
  cprintf ("En este ejemplo el puerto empleado es el com2 y el programa\n\r");
  cprintf ("que se ejecuta es prueba.bot \n\n\r");
}


int es_puerto(char *arg)
/* Ŀ
    Comprobar si el parmetro arg es un parmetro que especifica         
    un puerto serie. En caso de ser as se actualiza la variable global  
    puerto que especifica el puerto de comunicaciones actual.            
                                                                         
    SALIDAS:                                                             
              0 --> El parmetro no especificaba un puerto serie valido  
              1 --> Era un puerto serie (com1, com2, com3  com4)        
   */
{
  if (strcmp(arg,"-com1")==0) {
    puertopc=1;
    return 1;
  }
  if (strcmp(arg,"-com2")==0) {
    puertopc=2;
    return 1;
  }
  if (strcmp(arg,"-com3")==0) {
    puertopc=3;
    return 1;
  }
  if (strcmp(arg,"-com4")==0) {
    puertopc=4;
    return 1;
  }
  return 0;
}

int analiza_parametros(int na,char *arg[])
/**********************************************************/
/* Analizar los parametros de la linea de argumentos.     */
/* Si los argumentos no son correctos se devuelve 0       */
/**********************************************************/
{
  int i;
  char temp[10];

  if (na > 1 && strcmp(arg[1],"-h")==0) {   /* Parmetro -h --> Sacar ayuda */
    display_help();
    return 0;
  }

  if (na>3) {
	cprintf ("Demasiados parametros. Utilice intpcbot -h para obtener ayuda\n\r");
    return 0;
  }

  nomfich[0]=0;

  switch(na) {
	case 1 : cprintf ("No se ha especificado puerto. Utilice intpcbot -h para obtener ayuda\n\r");
	     return 0;
    case 2 : if (!es_puerto(arg[1])) {
		   cprintf ("No se ha especificado puerto. Utilice intpcbot -h para obtener ayuda\n\r");
	       return 0;
	     }
	     break;
    case 3 : if (!es_puerto(arg[1])){
		   cprintf ("No se ha especificado puerto. Utilice intpcbot -h para obtener ayuda\n\r");
	       return 0;
	     }
	     if (strlen(arg[2])>12) {
		   cprintf ("%s : fichero incorrecto\n\r",arg[1]);
	       return 0;
	     }
	     strcpy(nomfich,arg[2]);
	     break;
  }
  return 1;
}

int interpretar(char *prog)
{
  int fd;
  int error;
  int linea;
  lista_sentencias *ls;

  if (!inicializar_pcbot()) {
	return 0;
  }

  textcolor(15);
  cprintf ("LEYENDO PROGRAMA: ");
  textcolor(7);
  cprintf ("%s\n\r",prog);
  fd=open(nomfich,O_RDONLY);
  if (fd==-1) {
	  cprintf ("Error!: No se puede cargar el programa\n\r");
	  return 0;
  }

  /* Analizar el programa fuente */
  textcolor(15);
  cprintf ("ANALIZANDO PROGRAMA........");
  textcolor(7);
  ls=analisis(fd,&error);
  close(fd);
  if (error) {
	return 0;
  }


  /* Ejecutar el programa */
  textcolor(15);
  cprintf ("EJECUTANDO PROGRAMA........\n\n\r");
  textcolor(7);
  if (!interpreta_ast(ls)) {
	textcolor(7);
	cprintf (" \n\r");
	linea=get_int_linea_error();
	cprintf ("Linea %u: %s\n\r",linea,getint_error());
  }
  else {
	textcolor(7);
	cprintf ("\n\rPrograma terminado\n\n\r");
  }
  free(ls);
  textcolor(7);
  return 1;
}

int inicializacion(int argc, char **argv)
{
  presenta();
  textcolor(7);
  if (!analiza_parametros(argc,argv)) return 0;

  abrir_puerto_serie(puertopc);  /* Abrir sesion con puerto serie COM2 */
  baudios(9600);

  cprintf ("PUERTO: COM%u\n\n\r",puertopc);

  
  return 1;
}

int pedir_programa(char *prog)
{
  cprintf ("\n\rPrograma a ejecutar? (ENTER para finalizar): ");
  gets(prog);
  if (prog[0]==0) return 0;
  return 1;
}

void salir()
{
  cprintf ("\n\rFin del programa\n\n\r");
  cerrar_puerto_serie();
  exit(0);
}

main(int argc, char **argv)
{

  if (!inicializacion(argc,argv)) return 0;

  inicializar_pcbot();

  /* Si no se ha introducido programa por argumentos se pide */
  if (nomfich[0]==0) {
	if (!pedir_programa(nomfich)) salir();
  }

  /* ----  Bucle principal ----*/
  do {
	interpretar(nomfich);
  } while(pedir_programa(nomfich));

  salir();
}

