//////////////////////////////////////////////////////////
// DLLCTS.H
// Funciones especiales para el puerto serie de Windows 
// 24 - octubre -2000
//


// Funciones prototipo

#ifdef __cplusplus // si los ficheros fuente son .cpp
	extern "C" {
#endif


/*
    This function puts the DTR line high
	Parameters
	Return values
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)

*/
int WINAPI win_dtr_on();



/*
    This function puts the DTR line low
	Parameters
	Return values
		Returns the serial port handle 	  
*/
HANDLE WINAPI getserial_fd();



/*
    This function puts the DTR line low
	Parameters
	Return values
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
int WINAPI win_dtr_off();



/* 
	This function change the baud rate of the serial port
	Parameters
	  ibaud can be 9600, 7680 and 1200
	Return values:
	  Nonzero indicates success.
	  Zero indicates error (use GetLastError for more information)
*/
int WINAPI win_baudios(int ibaud) ;



/*
	This function tries to entablish the port conection
	Parameters
	   indPuerto: Defines the port that will be used
	Return
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI AbrirPuertoSerie(int indPuerto);



/*
	This function entablish the dafault configuration
	Parameters:
	   mbaud: It specifies the baud rate of the port
	Return
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI ConfigurarPuertoSerie(int mbaud);




/*
	This function close the serial port
	Parameters:
	Return values:
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI CerrarPuertoSerie();



/* 
	This function write characters into the serial port
	Parameters
	  car : Character to be sended
	Return
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI EnviarCar(CHAR car) ;


/*
   This function reads characters from the serial port
   Parameters
	  Car: The read character is returned inside de variable
   Return
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI Leer_Car(CHAR *car);


#ifdef __cplusplus // si el compilador es c++
	}
#endif
