//////////////////////////////////////////////////////////
// DLLCTS.CPP
// Funciones especiales para el puerto serie de Windows 
// 24 - octubre -2000
//

#include <windows.h>
#include "dllcts.h"

#define COLARX 128
#define COLATX 128

#define CBR_7680 7680



//-------------------------------------------------
// Funcin DllMain
// 

BOOL WINAPI DllMain(HANDLE hModule,DWORD dwReason,LPVOID lpReserved)
{
	switch (dwReason) {
	case DLL_PROCESS_ATTACH:
		break;
	case DLL_THREAD_ATTACH:
		break;
	case DLL_THREAD_DETACH:
		break;
	case DLL_PROCESS_DETACH:
		break;
	}
	return TRUE;
}









HANDLE hDisComm;  // Defined as a global variable
int iConexionEstablecida;
char lpBuf[2];

BOOL WINAPI ConfigurarPuertoSerie(int );
BOOL WINAPI LeerCar(CHAR *car);



/*
    This function puts the DTR line high
	Parameters
	Return values
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)

*/
int WINAPI win_dtr_on()
{
	return EscapeCommFunction( hDisComm, SETDTR);
}	



/*
    This function puts the DTR line low
	Parameters
	Return values
		Returns the serial port handle 	  
*/
HANDLE WINAPI getserial_fd()
{
	return hDisComm;
}





/*
    This function puts the DTR line low
	Parameters
	Return values
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
int WINAPI win_dtr_off()
{
	return EscapeCommFunction( hDisComm, CLRDTR);
}



/* 
	This function change the baud rate of the serial port
	Parameters
	  ibaud can be 9600, 7680 and 1200
	Return values:
	  Nonzero indicates success.
	  Zero indicates error (use GetLastError for more information)
*/
int WINAPI win_baudios(int ibaud) 
{
	// Para que al cambiar los baudios no cambie la linea DTR hay que
	// poner DTR_CONTROL_DISABLE en la inicializacin del puerto. Es
	// decir en ConfigurarDisCom()

	DCB dcb={0};

	if (GetCommState(hDisComm, &dcb)==0)
		return 0;

	switch (ibaud) {
		case 1200: dcb.BaudRate=CBR_1200; break; 
		case 7680: dcb.BaudRate=CBR_7680; break;
		case 9600: dcb.BaudRate=CBR_9600; break;
		default: dcb.BaudRate=CBR_7680; break;
	}
	if (SetCommState(hDisComm, &dcb)==0)
		return 0;

	return 1;
}



/*
	This function tries to entablish the port conection
	Parameters
	   indPuerto: Defines the port that will be used
	Return
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI AbrirPuertoSerie(int indPuerto)
{
	char szPuerto[10];
	BOOL bExito=FALSE;
	

	// Formar la cadena "COM" mas el nmero de dispositivo
	wsprintf(szPuerto, "COM%d",indPuerto);

	// Cerrar el puerto si estuviera abierto
	if (hDisComm) CloseHandle(hDisComm);

	// Abrir el puerto serie
	hDisComm = CreateFile( szPuerto,
							 GENERIC_READ | GENERIC_WRITE,
						     0,    // acceso exclusivo
							 NULL, // sin atributos de seguridad
							 OPEN_EXISTING,
							 FILE_FLAG_OVERLAPPED,
							 NULL);

	if (hDisComm == INVALID_HANDLE_VALUE) {
		// Visualizar error ocurrido
		// MensajeDeError( GetLastError() );
		MessageBeep( 0xFFFFFFFF ); 
		return FALSE;
	}

	// Especificar los eventos que sern atendidos
	SetCommMask( hDisComm, EV_RXCHAR | EV_TXEMPTY | EV_RX80FULL | EV_ERR);

	// Establecer el tamao de las colas de recepcin y de transmisin
	SetupComm(hDisComm, COLARX, COLATX);

	// Terminar las operaciones de lectura y escritura pendientes y limpiar
	// las colas Rx y Tx
	PurgeComm( hDisComm, PURGE_TXABORT | PURGE_RXABORT | 
				             PURGE_TXCLEAR | PURGE_RXCLEAR );

	// establecer los parmetros de la comunicacin
	bExito = ConfigurarPuertoSerie(7680);

	if (bExito) {
		iConexionEstablecida = TRUE;
		// Enviar la seal DTR
		EscapeCommFunction(hDisComm, SETDTR);
	}
	else {

		iConexionEstablecida = FALSE;
		CloseHandle(hDisComm);
	}

    return bExito;
}


/*
	This function entablish the dafault configuration
	Parameters:
	   mbaud: It specifies the baud rate of the port
	Return
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI ConfigurarPuertoSerie(int mbaud)
{
	DCB dcb;  // variable del tipo DEVICE CONTROL BLOCK

	dcb.DCBlength = sizeof (DCB);    
	GetCommState( hDisComm, &dcb);   // Lee la configuracin del Puerto

	dcb.BaudRate = mbaud;  
	dcb.Parity   = NOPARITY;
	dcb.ByteSize = (BYTE) 8;
	dcb.StopBits = ONESTOPBIT;

	// Establecer el control de flujo Xon/Xoff
	dcb.fInX = dcb.fOutX = 1;
	dcb.XonChar=0x11;  // ASCII_XON
	dcb.XoffChar=0x13; // ASCII_XOFF
	dcb.XonLim  = 100;  
	dcb.XoffLim = 100;

	// Establecer el control de flujo hardware
	// Es muy importante poner DTR_CONTROL_DISABLE para que 
	// no se resetee el puerto al cambiar los baudios
		
	dcb.fOutxDsrFlow = 0;  // Control por DTR
	dcb.fDtrControl = DTR_CONTROL_DISABLE;

	dcb.fOutxCtsFlow = 0;  // CTS desactivado
	dcb.fRtsControl = RTS_CONTROL_DISABLE;

	// Otras especificaciones

	dcb.fBinary = TRUE;
	dcb.fParity = TRUE;

	if (SetCommState(hDisComm, &dcb) == 0) {
		// visualizar el error ocurrido
		MessageBeep( 0XFFFFFFFF); 
		return FALSE;
	}

	// Establecer los tiempo lmites para las operaciones de E/S
	COMMTIMEOUTS CommTimeOuts;

	CommTimeOuts.ReadIntervalTimeout= MAXWORD;
	CommTimeOuts.ReadTotalTimeoutMultiplier=0;
	CommTimeOuts.ReadTotalTimeoutConstant = 1000;
	
	// CBR_9600 es aproximadamente 1 byte/ms. Para nuestros propsitos permitiremos 
	// un tiempo de espera por caracter doble al necesario.
	CommTimeOuts.WriteTotalTimeoutMultiplier= 2*CBR_9600/dcb.BaudRate;
	CommTimeOuts.WriteTotalTimeoutConstant=0;

	SetCommTimeouts( hDisComm, &CommTimeOuts);

	return TRUE;
}





/*
	This function close the serial port
	Parameters:
	Return values:
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI CerrarPuertoSerie()
{
	iConexionEstablecida=FALSE;

	// Inhabilitar todos los eventos
	SetCommMask( hDisComm, 0);

	// Desactivar DTR
	EscapeCommFunction( hDisComm, CLRDTR);

	// Terminar las operaciones de lectura y escritura pendientes y
	// limpiar las colas Rx y Tx
	PurgeComm(hDisComm, PURGE_TXABORT | PURGE_TXCLEAR |
						  PURGE_RXABORT | PURGE_RXCLEAR );
	CloseHandle( hDisComm );
	hDisComm = NULL;

	return TRUE;
}



/* 
	This function write characters into the serial port
	Parameters
	  car : Character to be sended
	Return
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI EnviarCar(CHAR car) 
{
	DWORD  dwWritten;
	OVERLAPPED sOverWrite;
	BOOL ret;

	sOverWrite.hEvent=CreateEvent(NULL,TRUE,FALSE,NULL);
	ret=WriteFile(hDisComm, &car, 1, &dwWritten, &sOverWrite);
	CloseHandle(sOverWrite.hEvent);
	return ret;
}




/*
   This function reads characters from the serial port
   Parameters
	  Car: The read character is returned inside de variable
   Return
	  Nonzero indicates succes. 
	  Zero indicates error (use GetLastError for more information)
*/
BOOL WINAPI Leer_Car(CHAR *car)
{
	DWORD dwRead;
	OVERLAPPED sOverRead;
	BOOL ret;

	sOverRead.hEvent=CreateEvent(NULL,TRUE,FALSE,NULL);
	ret=ReadFile(hDisComm, car, 1, &dwRead, &sOverRead);
	CloseHandle(sOverRead.hEvent);

	return ret;
}
