/*
 ͻ
  TERM4.C     (c) GRUPO J&J. Julio 1997.                                   
 ͹
                                                                           
  Ejemplo de manejo de las rutinas de comunicaciones serie.                
  El programa hace de terminal de comunicaciones. Cada vez que se pulsa    
  la tecla 'R' se realiza un reset de la CT6811.                           
                                                                           
 ͼ
*/

#include "serie.h"
#include "stdio.h"
#include "conio.h"
#include "dos.h"


#define ESC  27

/* Puntero para acceder directamente a la memoria de Video */
char far *punt = (char far *) 0xb800009A;


void accion_break()
/*
Ŀ
 Cada vez que se recibe un BREAK se escribe un caracter en la esqui-  
 na superior derecha de la pantalla.                                  
*/
{
  static char faseb[4] = {2,1,'o','.'};
  static char pfb = 0;

  *(punt+4)=faseb[pfb];
  pfb=(pfb+1) % 4;

}

void accion_rxcar()
/*
Ŀ
 Cada vez que se recibe un carcter se hace girar un 'palito' situado 
 en la esquina superior derecha de la pantalla.                       
*/
{
  static char fase[4]  = {'-','\\','||','/'};
  static char pf1 = 0;

  *(punt+4)=' ';

  *punt=fase[pf1];
  pf1= (pf1 + 1) % 4;
}

void reset(void)
/*
Ŀ
 Realizar un RESET de la CT6811  
*/
{
  dtr_on();
  delay(200);
  dtr_off();
}


main()
{
  char c;
  char d;

  clrscr();
  printf ("Pequeo terminal de comunicaciones. Pulse ESC para terminar\n\n");

  abrir_puerto_serie(COM2);  /* Abrir sesion con puerto serie COM2 */
  baudios(7680);

  do {
    if (kbhit()) {           /* Si se ha pulsado una tecla ...       */
      c=getch();             /* Leer tecla pulsada                   */
      enviar_car(c);         /* Enviar la tecla por el puerto serie  */
      if (c=='R') reset();   /* Si tecla 'R' se hace un reset        */
    }
    if (car_waiting()) {     /* Si llega caracter por puerto serie   */
      d=leer_car();          /* leer caracter que llega              */
      printf ("%c",d);       /* Imprimirlo por la pantalla           */
    }
  }while (c!=ESC);           /* Cuando se pulsa ESC se termina       */

  cerrar_puerto_serie();     /* Cerrar la sesin con el COM2 */
  return 0;
}