/*
 ͻ
  CTDETECT.C  (c) GRUPO J&J. Julio 1997.                                   
 ͹
                                                                           
  Programa para detectar el puerto en el que se encuentra la tarjeta CT6811
  Para ello se exploran los puerto COM1 y COM2. La exploracin consiste    
  en hacer reset hasta que se detecte que se reciben seales de BREAK.     
                                                                           
 ͼ
*/

#include "serie.h"
#include "stdio.h"
#include "dos.h"

/*
Ŀ
 No se realiza ninguna accion especial al recibir un caracter o una   
 seal de BREAK.                                                      
*/

void accion_rxcar()
{
}

void accion_break()
{
}

void reset()
/*
Ŀ
 Realizar un RESET de la tarjeta CT6811  
 seal de BREAK.                         
*/
{
  dtr_on();
  delay(300);
  dtr_off();
}

main()
{
  int puerto;
  int ok=0,nok=0;
  int intento;

  printf ("Autodeteccin de la tarjeta CT6811\n\n");

  /* Bucle de exploracin: COM1 y COM2 */

  for (puerto=1; puerto<=2; puerto++) {
    printf ("Explorando puerto COM%u\n",puerto);

    abrir_puerto_serie(puerto);  /* Abrir sesion con el puerto */

    enviar_car('J');  /* Enviar un carcter cualquiera */
    delay(100);
    ok=0; nok=0;

    /* Se realizan 3 intentos por cada puerto */

    for (intento=1; intento<=3; intento++) {
      printf ("Intento %u",intento);


      reset();  /* Se hace un reset y se espera la seal de BREAK */

      if (wait_break(5)==0) {  /* Timeout */
	printf ("....Timeout\n");
	nok++;
      }
      else {
	printf ("....OK!\n");
	ok++;
      }
    }
    printf ("\n");
    if (ok==3) printf ("Tarjeta CT6811 detectada en COM%u\n\n",puerto);

    cerrar_puerto_serie();  /* Cerrar sesin con el puerto */

  }
  return 0;
}