/*
 ͻ
  LEERS19     (c) GRUPO J&J. Julio 1997.                                   
 ͹
                                                                           
  Ejemplo de utilizacion de la libreria S19.C.                             
                                                                           
    Este programa lee un archivo en formato .S19 y devuelve el numero de   
  bytes que ocupa el cdigo, el numero de registros del tipo 1 y la direc- 
  cin de comienzo del codigo/datos.                                       
                                                                           
 ͼ
*/

#include "stdio.h"

/* ---- Librerias del Grupo J&J ---- */

#include "s19.h"

main()
{
  S19 mi_s19;               /* Fichero S19        */
  char cad[80];             /* Nombre del fichero */
  char *caderror;           /* Cadena de error    */
  unsigned int dir;         /* Direccin comienzo */


  /* ------------------------------- */
  /* ---- ABRIR EL FICHERO S19 ----- */
  /* --------------------------------*/
  printf ("\nNombre fichero: ");
  gets(cad);
  if (abrir_s19(cad,&mi_s19,1)==0) {   /* Si se ha producido un error */
    caderror=geterrors19();            /* Leer la cadena de error     */
    printf ("Error: %s\n",caderror);   /* Imprimir mensaje de error   */
    return 0;
  }
  printf ("\n");

  /* -------------------------------------------- */
  /* ---- MOSTRAR LA INFORMACION DEL FICHERO ---- */
  /* -------------------------------------------- */
  printf ("Numero de registros  : %u\n",getnregs19(mi_s19));
  printf ("Tamao en Bytes      : %u\n",getnbytes19(mi_s19));

  leerdir_s19(mi_s19,1,&dir);   /* Leer direccin del primer registro */
  printf ("Direccin de comienzo: %X\n",dir);

  printf ("Situacin programa   : ");
  if (dir<=0xFF)
     printf ("RAM INTERNA");
  else if (dir<=0xB7FF && dir>=0xB600)
	 printf ("EEPROM INTERNA");
       else
	 printf ("RAM EXTERNA");

  printf ("\n");

  /* ------------------------------- */
  /* ---- CERRAR EL FICHERO S19 ---- */
  /* ------------------------------- */
  cerrar_s19(mi_s19);
  return 0;
}