/*
 ͻ
  CTSERVER.C  (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Versin 2.0.  Rutinas para realizar llamadas remotas a los servicios     
  del servidor de propsito general CTSERVER.                              
                                                                           
    Esta libreria se utiliza para implementar CLIENTES para el servidor    
  CTSERVER.                                                                
                                                                           
 ͼ
*/

#include "dos.h"

/* Librerias del Grupo J&J utilizadas */

#include "serie.h"

typedef unsigned short int byte;
typedef unsigned int uint;


/*			 ͻ
			                         
ĺ   I N T E R F A Z      
			                         
			 ͼ                      */

int ctalive();
/* Ŀ
    Comprobar si existe conexin con el servidor CTSERVER.               
                                                                         
    Se devuelve:                                                         
              0 --> Servidor no responde                                 
              1 --> El servidor ha respondido                            
   */

void ctsend_block(uint dir, uint tam, byte *buff, void (*sendcar)());
/*Ŀ
   Enviar un bloque de datos desde el PC al 68HC11. El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento sendcar pasado
   como argumento.                                                      
                                                                        
  */

int ctreceive_block(uint dir, uint tam, byte *buff, void (*reccar)());
/*Ŀ
   Recibir un bloque de datos desde el 68HC11. El bloque tiene un       
   tamao tam y comienza a partir de la direccin dir. El bloque reci-  
   bido se sita en el buffer buff. Cada vez que se recibe un byte se   
   llama al procedimiento reccar pasado como parametro.                 
                                                                        
     La funcin devuelve un 0 si el CTSERVER no responde. Se enva un   
   1 si la operacin se ha realizado con xito.                         
                                                                        
  */

int ctsave_eeprom(uint dir,uint tam,byte *buff, void (*eeprcar)());
/*Ŀ
   Grabar un bloque de datos en la memoria EEPROM.  El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento eepromcar     
   pasado como argumento.                                               
                                                                        
     La funcin devuelve 0 si ha ocurido algn error. Devuelve 1 en     
   caso de exito.                                                       
                                                                        
  */

void ctexecute(uint dir);
/* Ŀ
    Llamar al servicio de salto y ejecucin del servidor CTSERVER.       
   */

void ctsend_byte(uint dir, byte valor);
/*Ŀ
   Enviar el byte especificado en la direccin indicada. 
  */

int ctreceive_byte(uint dir,byte *valor);
/*Ŀ
   Leer un byte de la direccin de memoria especificada. La funcin     
   devuelve 0 si el CTSERVER no responde. 1 en caso contrario.          
  */



/*		   ͻ
		                                 
ĺ I M P L E M E N T A C I O N  
		                                 
		   ͼ                      */

#define TIMEOUT   5
#define EETIMEOUT 30


void hacer_nada()
{
}

int ctalive()
/* Ŀ
    Comprobar si existe conexin con el servidor CTSERVER.               
                                                                         
    Se devuelve:                                                         
              0 --> Servidor no responde                                 
              1 --> El servidor ha respondido                            
   */
{
  int timeout;
  char c;

  vaciar_buffer();
  enviar_car('D');   /* Solicitar servicio de supervivencia */
  c=leer_car_plazo(TIMEOUT,&timeout);   /* Esperar respuesta */
  if (timeout==1) return 0;   /* Error de timeout: no responde */
  if (c!='J') return 0;       /* Error: Servidor ha respondido con un */
			      /* caracter diferentes del enviado      */
  return 1;
}


void ctsend_block(uint dir, uint tam, byte *buff, void (*sendcar)())
/*Ŀ
   Enviar un bloque de datos desde el PC al 68HC11. El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento sendcar pasado
   como argumento.                                                      
                                                                        
  */
{
  byte dirc[2];
  byte tamc[2];
  int i;

  dirc[0]=(byte) (dir & 0xFF);
  dirc[1]=(byte) (dir>>8 & 0xFF);

  tamc[0]=(byte) (tam & 0xFF);
  tamc[1]=(byte) (tam>>8 & 0xFF);

  enviar_car('B');       /* Enviar cdigo de servicio */
  enviar_car(dirc[0]);   /* Byte bajo direccion       */
  enviar_car(dirc[1]);   /* Byte alto direccion       */
  enviar_car(tamc[0]);   /* Byte bajo tamao bloque   */
  enviar_car(tamc[1]);   /* Byte alto tamao bloque   */

  i=0;                /* Enviar bloque solicitado */
  while (tam>0) {
    enviar_car(buff[i]);
    (*sendcar)();
    i++;
    tam--;
  }
}

int ctreceive_block(uint dir, uint tam, byte *buff, void (*reccar)())
/*Ŀ
   Recibir un bloque de datos desde el 68HC11. El bloque tiene un       
   tamao tam y comienza a partir de la direccin dir. El bloque reci-  
   bido se sita en el buffer buff. Cada vez que se recibe un byte se   
   llama al procedimiento reccar pasado como parametro.                 
                                                                        
     La funcin devuelve un 0 si el CTSERVER no responde. Se enva un   
   1 si la operacin se ha realizado con xito.                         
                                                                        
  */
{
  byte dirc[2];
  byte tamc[2];
  int i;
  int timeout;

  vaciar_buffer();

  dirc[0]=(byte) (dir & 0xFF);
  dirc[1]=(byte) (dir>>8 & 0xFF);

  tamc[0]=(byte) (tam & 0xFF);
  tamc[1]=(byte) (tam>>8 & 0xFF);

  enviar_car('A');        /* Enviar cdigo de servicio */
  enviar_car(dirc[0]);    /* Byte bajo direccion       */
  enviar_car(dirc[1]);    /* Byte alto direccion       */
  enviar_car(tamc[0]);    /* Byte bajo tamao bloque   */
  enviar_car(tamc[1]);    /* Byte alto tamao bloque   */

  i=0;                /* Enviar bloque solicitado */
  while (tam>0) {
    buff[i]=leer_car_plazo(TIMEOUT,&timeout);
    if (timeout==1) {
      return 0;         /* El servidor no responde */
    }
    (*reccar)();
    i++;
    tam--;
  }
  return 1;
}

int ctsave_eeprom(uint dir,uint tam,byte *buff, void (*eeprcar)())
/*Ŀ
   Grabar un bloque de datos en la memoria EEPROM.  El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento eepromcar     
   pasado como argumento.                                               
                                                                        
     La funcin devuelve 0 si ha ocurido algn error. Devuelve 1 en     
   caso de exito.                                                       
                                                                        
  */
{
  byte dirc[2];
  byte tamc[2];
  int i;
  int timeout;
  byte c;
  byte temp;

  dirc[0]=(byte) (dir & 0xFF);
  dirc[1]=(byte) (dir>>8 & 0xFF);

  tamc[0]=(byte) (tam & 0xFF);
  tamc[1]=(byte) (tam>>8 & 0xFF);

  vaciar_buffer();
  enviar_car('E');       /* Enviar cdigo de servicio */
  enviar_car(dirc[0]);   /* Byte bajo direccion       */
  enviar_car(dirc[1]);   /* Byte alto direccion       */
  enviar_car(tamc[0]);   /* Byte bajo tamao bloque   */
  enviar_car(tamc[1]);   /* Byte alto tamao bloque   */

  i=0;                /* Enviar bloque solicitado */
  while (tam>0) {
    temp=buff[i]&0xFF;  /* Convertir a tipo Byte */
    enviar_car(temp);
    c=leer_car_plazo(EETIMEOUT,&timeout);
    if (timeout==1) return 0;   /* Error: CTSERVER no responde */
    if (c!=temp) return 0;     /* Error: Eco incorrecto       */
    (*eeprcar)();
    i++;
    tam--;
  }
  return 1;
}

void ctexecute(uint dir)
/* Ŀ
    Llamar al servicio de salto y ejecucin del servidor CTSERVER.       
   */
{
  byte cad[2];

  cad[0]=(byte) (dir & 0xFF);
  cad[1]=(byte) (dir>>8 & 0xFF);

  enviar_car('C');
  enviar_car(cad[0]);
  enviar_car(cad[1]);
}

void ctsend_byte(uint dir, byte valor)
/*Ŀ
   Enviar el byte especificado en la direccin indicada. 
  */
{
  byte cad[2];

  cad[0]=valor;
  ctsend_block(dir,1,cad,hacer_nada);
}

int ctreceive_byte(uint dir,byte *valor)
/*Ŀ
   Leer un byte de la direccin de memoria especificada. La funcin     
   devuelve 0 si el CTSERVER no responde. 1 en caso contrario.          
  */
{
  return ctreceive_block(dir,1,valor,hacer_nada);
}



