/*
 ͻ
  CTSAVEEE.C  (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Programa de prueba de las rutinas de llamada a los servicios del CTSERVER
                                                                           
  El programa graba una cadena en la memoria EEPROM.                       
                                                                           
 ͼ
*/
#include <stdio.h>
#include <conio.h>

#include "serie.h"
#include "ctserver.h"

#define EEPROM 0xB600

typedef unsigned short int byte;


void accion_rxcar()
{
}

void accion_break()
{
}

void car_grab()
{
  static nbyte=0;

  nbyte++;
  if (nbyte==8) {
    printf ("");
    nbyte=0;
  }
}

main()
{
  byte cad[512];
  byte ok;
  byte tam;
  int i;
  int x,y;

  abrir_puerto_serie(2);
  baudios(9600);

  if (!ctalive()) {
    printf("No hay conexin");
    cerrar_puerto_serie();
    return 0;
  }

  printf ("\nGrabar una cadena en la memoria EEPROM\n\n");

  printf ("Introduzca la cadena a grabar (Maximo 512 bytes!!):\n ");

  i=0;
  tam=0;
  /*---------- Leer la cadena y meterla en cad ----------*/
  do {
    cad[i]=getch();
    if (cad[i]==13) {
      cad[i]=0;
      break;
    }
    printf("%c",cad[i]);
    i++;
    tam++;
  } while (i<512);

  if (tam>0) {
    printf ("\n\nGrabando: ");
    x=wherex();
    y=wherey();
    printf ("................................................................");
    gotoxy(x,y);

    ok=ctsave_eeprom(EEPROM,tam,cad,car_grab);

    if (ok) {
      printf ("\nGrabacin completada");
    }
    else printf ("\nConexion perdida");
  }

  cerrar_puerto_serie();
  return 0;
}