/*
 ͻ
  CTDUMPEE.C  (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Programa ejemplo de las llamadas a los servicios del CTSERVER.           
                                                                           
  El programa vuelca en contenido de la EEPROM en ASCII                    
                                                                           
 ͼ
*/

typedef unsigned short int byte;

#define EEPROM 0xB600

#include "stdio.h"
#include "conio.h"

/* Librerias utilizadas del Grupo J&J */

#include "serie.h"
#include "ctserver.h"

void accion_rxcar()
{
}

void accion_break()
{
}

void car_rec()
{
  static nbyte=0;

  nbyte++;
  if (nbyte==8) {
    printf ("");
    nbyte=0;
  }
}

main()
{
  byte eeprom[512];
  byte ok;
  int x,y;
  int i;


  abrir_puerto_serie(2);
  baudios(9600);

  printf ("\nPrograma para volcar la EEPROM en ASCII\n\n");

  if (!ctalive()) {
    printf("No hay conexin");
    cerrar_puerto_serie();
    return 0;
  }

  printf ("Leyendo: ");
  x=wherex();
  y=wherey();
  printf ("................................................................");
  gotoxy(x,y);

  /* ---- Leer memoria eeprom y meterla en el buffer ----- */
  ok=ctreceive_block(EEPROM,512,eeprom,car_rec);

  if (ok) {            /* Si no ha habido errores .. Imprimir */
    printf ("\n\n");
    x=0;
    for (i=0; i<512; i++) {
      if (eeprom[i]>31 && eeprom[i]<127) printf ("%c",eeprom[i]);
      else printf (".");
      x++;
      if (x==32) {
	x=0;
	printf ("\n");
      }
    }
    printf ("\nVolcado completado\n");
  }
  else printf ("\nConexin PERDIDA\n\n");

  cerrar_puerto_serie();
  return 0;
}