/*
 ͻ
  CTCLIENT.C  (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Rutinas para la realizacion de CLIENTES para el servidor CTSERVER.       
                                                                           
  Se utilizan las librerias SERIE.C y CTSERVER.C                           
                                                                           
 ͼ
*/

#include "ctserver.h"

#define SI 1
#define NO 0

typedef unsigned short int byte;
typedef unsigned int uint;

/*			 ͻ
			                         
ĺ   I N T E R F A Z      
			                         
			 ͼ                      */

int load(byte *valor, uint dir);
/*Ŀ
   Leer un byte de la direccin de memoria especificada. La funcin     
   devuelve 0 si el CTSERVER no responde. 1 en caso contrario.          
  */

int load_block(byte *buff, uint tam, uint dir, void (*reccar)());
/*Ŀ
   Recibir un bloque de datos desde el 68HC11. El bloque tiene un       
   tamao tam y comienza a partir de la direccin dir. El bloque reci-  
   bido se sita en el buffer buff. Cada vez que se recibe un byte se   
   llama al procedimiento reccar pasado como parametro.                 
                                                                        
     La funcin devuelve un 0 si el CTSERVER no responde. Se enva un   
   1 si la operacin se ha realizado con xito.                         
                                                                        
  */

void store(byte valor, uint dir);
/*Ŀ
   Enviar el byte especificado en la direccin indicada. 
  */

void store_block(byte *buff, uint tam, uint dir, void (*sendcar)());
/*Ŀ
   Enviar un bloque de datos desde el PC al 68HC11. El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento sendcar pasado
   como argumento.                                                      
                                                                        
  */

int store_block_eeprom(byte *buff, uint tam, uint dir, void (*eeprcar)());
/*Ŀ
   Grabar un bloque de datos en la memoria EEPROM.  El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento eepromcar     
   pasado como argumento.                                               
                                                                        
     La funcin devuelve 0 si ha ocurido algn error. Devuelve 1 en     
   caso de exito.                                                       
                                                                        
  */

int check_conexion();
/* Ŀ
    Comprobar si existe conexin con el servidor CTSERVER.               
                                                                         
    Se devuelve:                                                         
              0 --> Servidor no responde                                 
              1 --> El servidor ha respondido                            
   */

void execute(uint dir);
/* Ŀ
    Llamar al servicio de salto y ejecucin del servidor CTSERVER.       
   */

int hay_conexion();
/* Ŀ
    Devolver estado conexin de la ultima comunicacion con CTSERVER      
   */


/*		   ͻ
		                                 
ĺ I M P L E M E N T A C I O N  
		                                 
		   ͼ                      */

static conexion = 0;

int load(byte *valor, uint dir)
/*Ŀ
   Leer un byte de la direccin de memoria especificada. La funcin     
   devuelve 0 si el CTSERVER no responde. 1 en caso contrario.          
  */
{
  int ok;

  if (conexion) {
    ok=ctreceive_byte(dir,valor);
    if (!ok) {
      conexion = NO;
      return 0;
    }
    conexion = SI;
    return 1;
  }
  return 0;
}

int load_block(byte *buff, uint tam, uint dir, void (*reccar)())
/*Ŀ
   Recibir un bloque de datos desde el 68HC11. El bloque tiene un       
   tamao tam y comienza a partir de la direccin dir. El bloque reci-  
   bido se sita en el buffer buff. Cada vez que se recibe un byte se   
   llama al procedimiento reccar pasado como parametro.                 
                                                                        
     La funcin devuelve un 0 si el CTSERVER no responde. Se enva un   
   1 si la operacin se ha realizado con xito.                         
                                                                        
  */
{
  int ok;

  if (conexion) {
    ok=ctreceive_block(dir, tam, buff, reccar);
    if (!ok) {
      conexion=NO;
      return 0;
    }
    conexion = SI;
    return 1;
  }
  return 0;
}

void store(byte valor, uint dir)
/*Ŀ
   Enviar el byte especificado en la direccin indicada. 
  */
{
  if (conexion) ctsend_byte(dir, valor);
}


void store_block(byte *buff, uint tam, uint dir, void (*sendcar)())
/*Ŀ
   Enviar un bloque de datos desde el PC al 68HC11. El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento sendcar pasado
   como argumento.                                                      
                                                                        
  */
{
  if (conexion) ctsend_block(dir,tam,buff,sendcar);
}


int store_block_eeprom(byte *buff, uint tam, uint dir, void (*eeprcar)())
/*Ŀ
   Grabar un bloque de datos en la memoria EEPROM.  El bloque se encuen-
   tran en el buffer buff, que tiene un tamao tam. El bloque se debe   
   situar a patir de la direccin indicada.                             
                                                                        
   Cada vez que se enva un byte se llama a procedimiento eepromcar     
   pasado como argumento.                                               
                                                                        
     La funcin devuelve 0 si ha ocurido algn error. Devuelve 1 en     
   caso de exito.                                                       
                                                                        
  */
{
  int ok;

  if (conexion) {
    ok=ctsave_eeprom(dir,tam,buff,eeprcar);
    if (!ok) {
      conexion=NO;
      return 0;
    }
    conexion=SI;
    return 1;
  }
  return 0;
}

int check_conexion()
/* Ŀ
    Comprobar si existe conexin con el servidor CTSERVER.               
                                                                         
    Se devuelve:                                                         
              0 --> Servidor no responde                                 
              1 --> El servidor ha respondido                            
   */
{
  int ok;

  ok=ctalive();
  if (ok) {
    conexion=SI;
    return 1;
  }
  else {
    conexion=NO;
    return 0;
  }
}

void execute(uint dir)
/* Ŀ
    Llamar al servicio de salto y ejecucin del servidor CTSERVER.       
   */
{
  if (conexion) ctexecute(dir);
}

int hay_conexion()
/* Ŀ
    Devolver estado conexin de la ultima comunicacion con CTSERVER      
   */
{
  return conexion;
}
