/*
 ͻ
  BOOTSTRP.C  (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Versin 2.0.                                                             
                                                                           
    Rutinas para la carga de programas en la ram interna del 68HC11 cuando 
  arranca en modo bootstrap. Esta libreria necesita de las librerias:      
  S19.C, S19UTIL.C y SERIE.C.                                              
                                                                           
 ͼ
*/

#include "dos.h"

/* -- Librerias del Grupo J&J Empeadas -- */

#include "serie.h"
#include "s19.h"
#include "s19util.h"



/*			 ͻ
			                         
ĺ   I N T E R F A Z      
			                         
			 ͼ                      */

#define TIMEOUT_BREAK 4


void resetct6811();
/*
Ŀ
  Realizar un reset de la CT6811.   
*/

int okreset();
/*
Ŀ
  Realizar un reset de la CT6811 y esperar la seal de BREAK          
  correspondiente. Si no se recibe dentro del plazo establecido la    
  funcion devuelve 0. 1 en caso de recibirse el BREAK.                
*/

int jump_eeprom();
/*
Ŀ
  Saltar a la memoria EEPROM. La funcin de-  
  vuelve 1 si se ha recibido el BREAK y se ha 
  saltado correctamente. En caso de no reci-  
  bir el BREAK se devuelve 0.                 
*/

int jump_ram();
/*
Ŀ
  Saltar a la direccin $0000 de la memoria.  
  La funcion devuelve 1 si se ha recibido el  
  BREAK y se ha saltado correctamente a la    
  RAM. En caso de no recibir el BREAK se      
  devuelve 0.                                 
*/


int cargar_ramint(byte *ramint, void (*car)());
/*
Ŀ
  Enviar el programa especificado por la matriz ramint a la tarjeta   
  CT6811. Cada vez que se ha enviado un byte de cdigo se llama a la  
  funcin car.                                                        
                                                                      
    La funcin devuelve 1 si no se ha producido ningn error. Se      
  devuelve 0 en caso de error. Si se ha producido un error con la     
  funcin getloaderror se devuelve la cadena que indica el error.     
                                                                      
    ES NECESARIO QUE SE HAYA ABIERTO EL PUERTO SERIE ANTES DE ENVIAR  
  CUALQUIER PROGRAMA.                                                 
                                                                      
*/

int cargars19_ramint(S19 fs19, void (*car)());
/*
Ŀ
  Enviar el fichero .S19 especificado a la tarjeta CT6811. El         
  fichero debe estar preparado para la ram interna. Cada vez que se   
  enva un carcter se llama a la funcin car.                        
                                                                      
    La funcin devuelve 1 si no se ha producido ningn error. Se      
  devuelve 0 en caso de error. Si se ha producido un error con la     
  funcin getloaderror se devuelve la cadena que indica el error.     
                                                                      
    ES NECESARIO QUE SE HAYA ABIERTO EL PUERTO SERIE ANTES DE ENVIAR  
  CUALQUIER PROGRAMA.                                                 
                                                                      
*/


char *getloaderror();
/*
Ŀ
  Devolver la cadena del error producido en la ultima carga de programas  
  en la RAM interna                                                       
*/




/*		   ͻ
		                                 
ĺ I M P L E M E N T A C I O N  
		                                 
		   ͼ                        */


#define TIEMPO 5    /* Timeout para recibir el eco */
#define NULL 0


static int nerror;
char errorload[8][80] = {
 "",                               /* 1 */ /* Error en .S19 */
 "La tarjeta CT6811 no responde",  /* 2 */
 "Fallo en la transmisin",        /* 3 */
 "No se recibe seal de BREAK",    /* 4 */
 "El programa no es para la RAM interna",                 /* 5 */
 "El programa desborda los 256 bytes de la RAM interna",  /* 6 */

};

void resetct6811()
/*
Ŀ
  Realizar un reset de la CT6811.   
*/
{
  dtr_on();
  delay(300);
  dtr_off();
}

int okreset()
/*
Ŀ
  Realizar un reset de la CT6811 y esperar la seal de BREAK          
  correspondiente. Si no se recibe dentro del plazo establecido la    
  funcion devuelve 0. 1 en caso de recibirse el BREAK.                
*/
{
  resetct6811();
  if (wait_break(TIMEOUT_BREAK)==0) return 0;
  else return 1;
}

int jump_eeprom()
/*
Ŀ
  Saltar a la memoria EEPROM. La funcin de-  
  vuelve 1 si se ha recibido el BREAK y se ha 
  saltado correctamente. En caso de no reci-  
  bir el BREAK se devuelve 0.                 
*/
{
  if (okreset()) {
    enviar_car(0x00);
    return 1;
  }
  return 0;
}

int jump_ram()
/*
Ŀ
  Saltar a la direccin $0000 de la memoria.  
  La funcion devuelve 1 si se ha recibido el  
  BREAK y se ha saltado correctamente a la    
  RAM. En caso de no recibir el BREAK se      
  devuelve 0.                                 
*/
{
  if (okreset()) {
    enviar_car(0x55);
    return 1;
  }
  return 0;
}


int cargar_ramint(byte *ramint, void (*car)())
/*
Ŀ
  Enviar el programa especificado por la matriz ramint a la tarjeta   
  CT6811. Cada vez que se ha enviado un byte de cdigo se llama a la  
  funcin car.                                                        
                                                                      
    La funcin devuelve 1 si no se ha producido ningn error. Se      
  devuelve 0 en caso de error. Si se ha producido un error con la     
  funcin getloaderror se devuelve la cadena que indica el error.     
                                                                      
    ES NECESARIO QUE SE HAYA ABIERTO EL PUERTO SERIE ANTES DE ENVIAR  
  CUALQUIER PROGRAMA.                                                 
                                                                      
*/
{
  int i;
  unsigned short int c;
  int timeout;

  nerror=0;

  baudios(7680);
  vaciar_buffer();
  resetct6811();
  if (wait_break(40)==0) {
    nerror=4;                /* No se recibe BREAK */
    return 0;
  }

  delay(100);
  enviar_car(0xFF);          /* Especificar 7680 baudios */


  for (i=0; i<=255; i++) {
    enviar_car(ramint[i]);
    c=(unsigned short int)leer_car_plazo(TIEMPO,&timeout)&0xFF;

    if (timeout) {
      nerror=2;      /* Error de timeout */
      return 0;
    }
    if (c!=ramint[i]) {
      nerror=3;      /* Se ha recibido un eco diferente */
      return 0;      /* El ltimo eco no se cuenta...   */
    }
    (*car)();
  }
  return 1;
}

int cargars19_ramint(S19 fs19, void (*car)())
/*
Ŀ
  Enviar el fichero .S19 especificado a la tarjeta CT6811. El         
  fichero debe estar preparado para la ram interna. Cada vez que se   
  enva un carcter se llama a la funcin car.                        
                                                                      
    La funcin devuelve 1 si no se ha producido ningn error. Se      
  devuelve 0 en caso de error. Si se ha producido un error con la     
  funcin getloaderror se devuelve la cadena que indica el error.     
                                                                      
    ES NECESARIO QUE SE HAYA ABIERTO EL PUERTO SERIE ANTES DE ENVIAR  
  CUALQUIER PROGRAMA.                                                 
                                                                      
*/
{
  byte ramint[256];
  byte ramintoc[256];
  int ov;

  
  if (situacion_progs19(fs19,&ov)!=1) {
    nerror=5;               /* Programa no es para ram interna */
    return 0;
  }
  if (ov==1) {
    nerror=6;    /* El programa desborda la RAM interna */
    return 0;
  }
  s19toramint(fs19,ramint,ramintoc);
  return cargar_ramint(ramint,car);
}

char *getloaderror()
/*
Ŀ
  Devolver la cadena del error producido en la ultima carga de programas  
  en la RAM interna                                                       
*/
{
  if (nerror==0) return NULL;
  if (nerror==1) return (char *)geterrors19();   /* Error en .S19   */
  return (char *)&errorload[nerror-1];    /* Error al cargar */
}

