/*
 ͻ
  ASCBIN.C    (c) GRUPO J&J. Julio 1997.                                   
 ͹
                                                                           
  Versin 1.0.                                                             
                                                                           
    Rutinas para la conversin de digitos ASCII a numeros binarios y       
  viceversa.                                                               
                                                                           
                                                                           
 ͼ
*/


/*

			 ͻ
			                         
ĺ   I N T E R F A Z      
			                         
			 ͼ                       */


int char1tobyte(char car,unsigned short int *dec);
/*
Ŀ
  Se toma una carcter hexadecimal en ASCII y se convierte a un nmero   
  entero.                                                                
                                                                         
    EJ: char1tobyte('A',&x);  Se convertira el digito ASCII 'A' en el   
                              numero 10 que se devolvera en x.          
                                                                         
    Se devuelve 0 si el carcter no es un digito en hexadecimal          
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/


int char2tobyte(char *cad,unsigned short int *dec);
/*
Ŀ
  Se toma una cadena con dos dgitos hexadecimales ASCII y los convierte 
  en un nmero entero de 8 bits                                          
                                                                         
  Ej: char2tobyte("FF",&x);  Se convierte la cadena "FF" en el nmero    
                             255 que se devuelve en x.                   
                                                                         
    Se devuelve 0 si algn digito no est en hexadecimal.                
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/

int char4toint(char *cad,unsigned int *dec);
/*
Ŀ
  Se toma una cadena con 4 dgitos hexadecimales ASCII y los convierte   
  en un nmero entero de 16bits                                          
                                                                         
  Ej. char4toint("123C",&x); Se convierte la cadena "123C" en el nmero  
                             4668 que se devuelve en x.                  
                                                                         
    Se devuelve 0 si algn digito no est en hexadecimal.                
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/

int bytetochar1(unsigned short int byte, char *car);
/*
Ŀ
  Convertir un nmero entre 0-15 a caracteres hexadecimales en ASCII     
                                                                         
  Ej. bytetochar1(12,cad);  Se convierte el nmero 12 a la cadena "C"    
                            que se devuelve en cad                       
                                                                         
  Se devuelve un 1 si se ha realizado correctamente la conversin.       
  Se devuelve un 0 en caso contrario.                                    
                                                                         
*/


int bytetochar2(short num, char *cad);
/*Ŀ
   Convertir un nmero entre 0-255 a 2 caracters ASCII hexadecimales.    
                                                                         
   Ej. bytetochar2(127,cad); Se convierte el nmero 127 en la cadena "7F"
                             que se devuelve en cad                      
                                                                         
   Se devuelve un 1 si se ha realizado correctamente la conversin.      
   Se devuelve un 0 en caso contrario.                                   
                                                                         
  */


int inttochar4(long num, char *cad);
/*Ŀ
   Convertir un nmero entre 0-65535 a 4 caracters ASCII hexadecimales.  
                                                                         
   Ej. inttochar4(14563,cad); Se convierte el numero 14563 en la cadena  
                              "38E3" que se devuelve en cad              
                                                                         
   Se devuelve un 1 si se ha realizado correctamente la conversin.      
   Se devuelve un 0 en caso contrario.                                   
                                                                         
  */





/*		   ͻ
		                                 
ĺ I M P L E M E N T A C I O N  
		                                 
		   ͼ                      */



int char1tobyte(char car,unsigned short int *dec)
/*
Ŀ
  Se toma una carcter hexadecimal en ASCII y se convierte a un nmero   
  entero.                                                                
                                                                         
    Se devuelve 0 si el carcter no es un digito en hexadecimal          
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/
{
  if (car>='0' && car<='9')
      *dec=car-'0';
  else if (car<='F' && car>='A')
      *dec=car-'A'+10;
       else return 0;     /*  El dgito no est en hexadecimal  */

  return 1;		  /*  No ha habido errores              */
}

int char2tobyte(char *cad,unsigned short int *dec)
/*
Ŀ
  Se toma una cadena con dos dgitos hexadecimales ASCII y los convierte 
  en un nmero entero de 8 bits                                          
                                                                         
    Se devuelve 0 si algn digito no est en hexadecimal.                
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/
{
  unsigned short num1,num2;

  if (char1tobyte(cad[0],&num1))  /* Si se convierte bien el primer digito */
    if (char1tobyte(cad[1],&num2)){/* y se convierte bien el segundo...    */
      *dec=num1*16+num2;           /* Se calcula en numero en decimal      */
      return 1;
    }
  return 0;           /* Ha habido algn error en la conversin */
}


int char4toint(char *cad,unsigned int *dec)
/*
Ŀ
  Se toma una cadena con 4 dgitos hexadecimales ASCII y los convierte   
  en un nmero entero de 16bits                                          
                                                                         
    Se devuelve 0 si algn digito no est en hexadecimal.                
    Se devuelve 1 en caso contrario.                                     
                                                                         
*/
{
  unsigned short int num1,num2;

  if (char2tobyte(&cad[0],&num1))     /* Si se convierten bien 1er par de dig */
    if (char2tobyte(&cad[2],&num2)) { /* Y se convierten bien el 2 par..     */
      *dec=num1*256 + num2;         /* Calcular nmero decimal resultante   */
      return 1;
    }

  return 0;        /* Error en la conversin */
}


int bytetochar1(unsigned short int byte, char *car)
/*
Ŀ
  Convertir un nmero entre 0-15 a caracteres hexadecimales en ASCII     
                                                                         
  Se devuelve un 1 si se ha realizado correctamente la conversin.       
  Se devuelve un 0 en caso contrario.                                    
                                                                         
*/
{
  if (byte>15) return 0;
  if (byte<10)
    *car='0'+byte;
  else
    *car='A'-10+byte;

  return 1;
}

int bytetochar2(short num, char *cad)
/*Ŀ
   Convertir un nmero entre 0-255 a 2 caracters ASCII hexadecimales.    
                                                                         
   Se devuelve un 1 si se ha realizado correctamente la conversin.      
   Se devuelve un 0 en caso contrario.                                   
                                                                         
  */
{
  if (bytetochar1(num>>4,&cad[0])==0)    return 0;  /* Digito mayor peso */
  if (bytetochar1(num & 0xF,&cad[1])==0) return 0;  /* Digito menor peso */
  cad[2]=0;
  return 1;
}

int inttochar4(long num, char *cad)
/*Ŀ
   Convertir un nmero entre 0-65535 a 4 caracters ASCII hexadecimales.  
                                                                         
   Se devuelve un 1 si se ha realizado correctamente la conversin.      
   Se devuelve un 0 en caso contrario.                                   
                                                                         
  */
{
  if (bytetochar2(num>>8,cad)==0) return 0;
  if (bytetochar2(num&0xFF,&cad[2])==0) return 0;
  cad[4]=0;
  return 1;
}

