/*
 ͻ
  KAD.C       (c) GRUPO J&J. Agosto 1997.                                  
 ͹
                                                                           
  Ejemplo de prueba de la libreria CTCLIENT.C                              
                                                                           
  Se muestran en pantalla 4 canales analgicos de entrada del 68HC11.      
                                                                           
 ͼ
*/

typedef unsigned short int byte;

#include "conio.h"
#include "stdio.h"

#include "R6811pc.h"
#include "serie.h"
#include "ctclient.h"

void accion_rxcar()
{
}

void accion_break()
{
}

void nada()
{
}

main()
{
  byte ad;
  byte muestra[4];
  byte x;
  byte error;
  int i;

  abrir_puerto_serie(2);
  baudios(9600);

  clrscr();

  check_conexion();        /* Comprobar conexion */
  if (!hay_conexion()) {
    printf("No hay conexin");
    cerrar_puerto_serie();
    return 0;
  }

  store(0x80,OPTION); /* Encender conversor */
  store(0x30,ADCTL);

  do {
    load(&ad,ADCTL);  /* Comprobar si conversion realizada */
    if ((ad & 0x80)==0x80) {
      load_block(muestra,4,ADR1,nada);  /* Leer muestras */

      /* --- Dibujar vumetros --- */

      for (i=0; i<4; i++) {
	gotoxy(5,5+i*2);
	muestra[i]=muestra[i]&0xFF;
	printf ("%2X",muestra[i]);
	muestra[i]=muestra[i]>>2;
	gotoxy(5,6+i*2);
	for (x=0; x<64; x++) {
	  if (x<=muestra[i]) printf ("");
	  else printf (".");
	}
      }
    }
  } while (!kbhit() && hay_conexion());

  if (!hay_conexion()) printf ("\nConexion perdida...");
  getch();

  cerrar_puerto_serie();
  return 0;
}
