/*
 * ReadTh.cpp                     2001/09/05
 *
 * Ctload para Windows
 *
 * Copyright (C) 2001 Javier de Lope Asian <jdlope@eui.upm.es>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Terminal.h"
#include "Main.h"
#pragma package(smart_init)
//---------------------------------------------------------------------------
__fastcall TReadThread::TReadThread(bool CreateSuspended, bool TermHex) : TThread(CreateSuspended)
{
  termHex = TermHex;
}
//---------------------------------------------------------------------------
void __fastcall TReadThread::DisplayIt()
{
  if (termHex) {
    char byte[5];
    for (int i = 0; i < (int)bytesRead; i++) {
      sprintf(byte, "0x%02X ", buffer[i] & 0xFF);
      FormTerminal->Memo->SetSelTextBuf(byte);
    }
  }
  else
    // Ojo! Puede sacar el string de forma incompleta si uno de los
    // caracteres es el 0x00 (indicador de fin de string)
    FormTerminal->Memo->SetSelTextBuf(buffer);
}
//---------------------------------------------------------------------------
void __fastcall TReadThread::Execute()
{
  FreeOnTerminate = true;
  while (! Terminated) {
     FormMain->ct6811.ReadString(buffer, sizeof(buffer), &bytesRead);
     if (bytesRead) {
       buffer[bytesRead] = 0;
       Synchronize(DisplayIt);
     }
   }
}
//---------------------------------------------------------------------------
