/*
 * Options.cpp                    2001/09/05
 *
 * Ctload para Windows
 *
 * Copyright (C) 2001 Javier de Lope Asian <jdlope@eui.upm.es>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include "Options.h"
#include "Errors.h"
#include "Main.h"
#include "Ct294.h"
#include "Sending.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormOptions *FormOptions;
//---------------------------------------------------------------------------
__fastcall TFormOptions::TFormOptions(TComponent* Owner) : TForm(Owner)
{
}
//---------------------------------------------------------------------------
void __fastcall TFormOptions::FormShow(TObject *Sender)
{
  ComboPort->SetFocus();
  CheckHex->Enabled = CheckTerminal->Checked;
  CheckEco->Enabled = CheckTerminal->Checked;
}
//---------------------------------------------------------------------------
void __fastcall TFormOptions::Exec294Click(TObject *Sender)
{
  int err;

  FormSending->InitComm();
  if ((err = FormMain->ct6811.InitComm(ComboPort->Items->Strings[ComboPort->ItemIndex].c_str())) == NO_ERR) {
    FormSending->SendingServer();
    if ((err = FormMain->ct6811.SendServer(BarPosition)) == NO_ERR) {
      FormSending->CloseComm();
      FormMain->ct6811.SetBaud(B_9600);
      FormCT294->ShowModal();
    }
  }
  // Slo oculta la ventana de progreso de la comunicacin
  FormSending->CloseComm();
  FormMain->ct6811.CloseComm();
  if (err != NO_ERR)
    FormMain->ShowError(err);
  SetFocus();
}
//---------------------------------------------------------------------------
void __fastcall TFormOptions::CheckTerminalClick(TObject *Sender)
{
  CheckHex->Enabled = CheckTerminal->Checked;
  CheckEco->Enabled = CheckTerminal->Checked;
}
//---------------------------------------------------------------------------

