/*
 * Main.cpp                       2001/09/05
 *
 * Ctload para Windows
 *
 * Copyright (C) 2001 Javier de Lope Asian <jdlope@eui.upm.es>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//---------------------------------------------------------------------------
#include <vcl.h>
#pragma hdrstop

#include <stdio.h>
#include <registry.hpp>
// #include <inifiles.hpp>

#include "Ctload.h"
#include "Errors.h"
#include "Main.h"
#include "Acerca.h"
#include "Options.h"
#include "Sending.h"
#include "Terminal.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TFormMain *FormMain;
//---------------------------------------------------------------------------
__fastcall TFormMain::TFormMain(TComponent* Owner) : TForm(Owner)
{
  TRegIniFile *reg = new TRegIniFile("Software\\Microbotica\\Ctload");
  strcpy(port, reg->ReadString("Puerto", "Puerto", "COM1").c_str());
  openTerm = reg->ReadBool("Terminal", "Activo", false);
  termHex  = reg->ReadBool("Terminal", "Hexadecimal", false);
  termEco  = reg->ReadBool("Terminal", "Eco", false);
  delete reg;

  // char buffer[512];
  // sprintf(buffer, "<%s> <%s> <%s>", port, openTerm ? "Term" : "NoTerm", termHex ? "Hex" : "NoHex");
  // Application->MessageBox(buffer, APPNAME, MB_OK | MB_ICONINFORMATION);
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::FormDestroy(TObject *Sender)
{
  TRegIniFile *reg = new TRegIniFile("Software\\Microbotica\\Ctload");
  reg->WriteString("Puerto", "Puerto", port);
  reg->WriteBool("Terminal", "Activo", openTerm);
  reg->WriteBool("Terminal", "Hexadecimal", termHex);
  reg->WriteBool("Terminal", "Eco", termEco);
  delete reg;
                                           
  // char buffer[512];
  // sprintf(buffer, "<%s> <%s> <%s>", port, openTerm ? "Term" : "NoTerm", termHex ? "Hex" : "NoHex");
  // Application->MessageBox(buffer, APPNAME, MB_OK | MB_ICONINFORMATION);
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::BtnSendClick(TObject *Sender)
{
  if (OpenDialog->Execute()) {
    SendFile(OpenDialog->FileName.c_str());
  }
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::BtnResendClick(TObject *Sender)
{
  SendFile(OpenDialog->FileName.c_str());
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::BtnOptionsClick(TObject *Sender)
{
  // FormOptions->ComboPort->ItemIndex = 0;

  for (int i = 0; i < FormOptions->ComboPort->Items->Count; i++) {
    if (! strcmp(FormOptions->ComboPort->Items->Strings[i].c_str(), port))
      FormOptions->ComboPort->ItemIndex = i;
  }
  FormOptions->CheckTerminal->Checked = openTerm;
  FormOptions->CheckHex->Checked = termHex;
  FormOptions->CheckEco->Checked = termEco;

  if (FormOptions->ShowModal() == mrOk) {
    strcpy(port, FormOptions->ComboPort->Items->Strings[FormOptions->ComboPort->ItemIndex].c_str());
    openTerm = FormOptions->CheckTerminal->Checked;
    termHex  = FormOptions->CheckHex->Checked;
    termEco  = FormOptions->CheckEco->Checked;
  }
}
//---------------------------------------------------------------------------
void __fastcall TFormMain::BtnAboutClick(TObject *Sender)
{
  AcercaDe->ShowModal();
}
//---------------------------------------------------------------------------
void TFormMain::SendFile(const char *filename)
{
  FILE *fd;
  char buffer[1024], memozone;
  unsigned int bytes, memoini;
  int err;

  if ( (fd = fopen(filename, "rt")) == NULL) {
    sprintf(buffer, "Error abriendo el fichero %s", filename);
    Application->MessageBox(buffer, APPNAME, MB_OK | MB_ICONERROR);
    ResetResend();
  }
  else {
    fscanf(fd, "%s", buffer);
    if ( (buffer[0] == 'S') && (buffer[1] == '0') )
      fscanf(fd, "%s", buffer);
    if ( (buffer[0] != 'S') || (buffer[1] != '1') ) {
      sprintf(buffer, "Formato de fichero no compatible", filename);
      Application->MessageBox(buffer, APPNAME, MB_OK | MB_ICONERROR);
      ResetResend();
    }
    else {
      LabelFilename->Caption = filename;

      /*
      if ( (buffer[4] == '0') && (buffer[5] == '0') && (buffer[6] == '0') && (buffer[7] == '0') )
        memozone = '0'
      if ( (buffer[4] == 'B') && (buffer[5] == '6') && (buffer[6] == '0') && (buffer[7] == '0') )

      switch (memozone = buffer[4]) {
        case '0': LabelMemory->Caption = "RAM Interna";
                   break;
        case '8' : LabelMemory->Caption = "RAM Externa";
                   break;
        case 'B' : LabelMemory->Caption = "EEPROM";
                   break;             ;
        default  : LabelMemory->Caption = "Desconocida";
                   break;
      }
      */

      memoini  = 0x1000 * tonum(buffer[4]) + 0x0100 * tonum(buffer[5]) +
                 0x0010 * tonum(buffer[6]) + tonum(buffer[7]);
      if ( /* (memoini >= 0x0000) && */ (memoini <= 0x00FF) ) {
        LabelMemory->Caption = "RAM Interna";
        memozone = '0';
      }
      else if ( (memoini >= 0xB600) && (memoini <= 0xB7FF) ) {
        LabelMemory->Caption = "EEPROM";
        memozone = 'B';
      }
      else {
        LabelMemory->Caption = "RAM Externa";
        memozone = '8';
      }

      bytes = 0;
      while (! feof(fd)) {
        if (buffer[1] == '1')
          bytes += 16 * tonum(buffer[2]) + tonum(buffer[3]) - 3;
        fscanf(fd, "%s", buffer);
      }
      sprintf(buffer, "%d bytes", bytes);
      LabelSize->Caption = buffer;

      Update();

      BtnResend->Enabled = true;

      rewind(fd);
      switch (memozone) {
        case '0' : FormSending->InitComm();
                   if ((err = ct6811.InitComm(port)) == NO_ERR) {
                     FormSending->SendingProgram();
                     FormSending->ProgressBar->Max = 256;
                     err = ct6811.SendToRAM(fd, BarPosition);
                   }
                   FormSending->CloseComm();
                   if (err != NO_ERR)
                     ShowError(err);
                   else
                     if (openTerm)
                       FormTerminal->ShowModal();
                   ct6811.CloseComm();
                   break;
        case '8' : FormSending->InitComm();
                   if ((err = ct6811.InitComm(port)) == NO_ERR) {
                     FormSending->SendingServer();
                     FormSending->ProgressBar->Max = 256;
                     if ((err = ct6811.SendServer(BarPosition)) == NO_ERR) {
                       ct6811.SetBaud(B_9600);
                       FormSending->SendingProgram();
                       FormSending->ProgressBar->Max = bytes;
                       err = ct6811.SendToExt(fd, memoini, BarPosition);
                     }
                   }
                   FormSending->CloseComm();
                   if (err != NO_ERR)
                     ShowError(err);
                   else
                     if (openTerm)
                       FormTerminal->ShowModal();
                   ct6811.CloseComm();
                   break;
        case 'B' : FormSending->InitComm();
                   if ((err = ct6811.InitComm(port)) == NO_ERR) {
                     FormSending->SendingServer();
                     FormSending->ProgressBar->Max = 256;
                     if ((err = ct6811.SendServer(BarPosition)) == NO_ERR) {
                       ct6811.SetBaud(B_9600);
                       FormSending->SendingProgram();
                       FormSending->ProgressBar->Max = bytes;
                       err = ct6811.SendToEEPROM(fd, BarPosition);
                     }
                   }
                   FormSending->CloseComm();
                   if (err != NO_ERR)
                     ShowError(err);
                   else
                     if (openTerm)
                       FormTerminal->ShowModal();
                   ct6811.CloseComm();
                   break;
        default  : Application->MessageBox(
                     "Esta versin no soporta este modo de memoria. La transmisin no se realizar.",
                     APPNAME, MB_OK | MB_ICONWARNING);
                   ResetResend();
      }
    }
    fclose(fd);
  }
}
//---------------------------------------------------------------------------
void TFormMain::ResetResend()
{
  LabelFilename->Caption = "Ninguno";
  LabelMemory->Caption = "";
  LabelSize->Caption = "";
  BtnResend->Enabled = false;
}
//---------------------------------------------------------------------------
void TFormMain::ShowError(int err)
{
  switch (err) {
    case NO_RESET :
      Application->MessageBox(
        "No es posible realizar un reset de la tarjeta",
        APPNAME, MB_OK | MB_ICONERROR);
      break;
    case NO_OPEN :
      Application->MessageBox(
        "No es posible abrir el puerto de comunicaciones",
        APPNAME, MB_OK | MB_ICONERROR);
      break;
    case NO_ANSWER :
      Application->MessageBox(
        "No hay respuesta de la tarjeta",
        APPNAME, MB_OK | MB_ICONERROR);
      break;
    case NO_ECHO :
      Application->MessageBox(
        "No se recibe eco de la tarjeta",
        APPNAME, MB_OK | MB_ICONERROR);
      break;
    default :
      Application->MessageBox(
        "Se est quemando el puerto de la impresora",
        APPNAME, MB_OK | MB_ICONERROR);
  }
}
//---------------------------------------------------------------------------

