/*
 * Ct6811.h                       2001/09/05
 *
 * Ctload para Windows
 *
 * Copyright (C) 2001 Javier de Lope Asian <jdlope@eui.upm.es>
 *
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

//---------------------------------------------------------------------------
#ifndef Ct6811H
#define Ct6811H
//---------------------------------------------------------------------------
#include "Comm.h"
#include <stdio.h>
//---------------------------------------------------------------------------
class TCT6811 : public TComm
{
  public:
    TCT6811();

    int Reset   ();

    int Load        (int addr, unsigned char *value);
    int Load        (int addr, unsigned char *buffer, unsigned int size);
    int Store       (int addr, unsigned char  value);
    int Store       (int addr, unsigned char *buffer, unsigned int size, void (*BarPos)(int));
    int StoreEEPROM (int addr, unsigned char *buffer, unsigned int size, void (*BarPos)(int));
    int Execute     (int addr);
    int Alive       ();

    int  InitComm     (char *port);
    void CloseComm    ();
    int  SendServer   (void (*BarPos)(int));
    int  SendToRAM    (FILE *fd, void (*BarPos)(int));
    int  SendToExt    (FILE *fd, unsigned int memoini, void (*BarPos)(int));
    int  SendToEEPROM (FILE *fd, void (*BarPos)(int));

    // inline void SendReset() { SendDTR(); }
};
//---------------------------------------------------------------------------
#endif
